#!/usr/bin/perl -w
#
# Convert a single gnuplot demo script to a web page
# Usage:
#	webify xxx
#
# Reads xxx.dem and creates xxx.html along with associated 
# png images output to xxx.<n>.png 
#
# If gpsavediff is present also create a set of scripts
# xxx.<n>.gnu corresponding to the minimal set of commands 
# needed to generate that png image.
#
# If gnuplot_demo.css is present, link to it as a stylesheet.
#
# Ethan A Merritt <merritt@u.washington.edu>
# December 2003
#
# EAM Jan 2004
#   use gpsavediff if available
#   link to gnuplot_demo.css if available
#
# EAM Aug 2005
# If DEMOTERM is present as an environmental variable, then use
#    set term DEMOTERM
# rather than the default terminal settings
#    setenv DEMOTERM "pngcairo font 'arial,10' transparent size 600,400"
#    ./webify.pl image
#
# EAM Apr 2009
#    new layout for generated web pages
#
use Env qw(DEMOTERM GNUPLOT_LIB);

use Time::localtime;
use HTML::Entities;

# Use the in-tree copy of gnuplot if there is one
	my $gnuplot = ( -x "../../src/gnuplot" ) ? "../../src/gnuplot" : "gnuplot" ;

	if ((!defined $ENV{GNUPLOT_LIB}) || $GNUPLOT_LIB eq "") {
	    $GNUPLOT_LIB = "..";
	}
	my $date = ctime();
	my $plot = 1;

# input and output files
	open(IN,  "<$GNUPLOT_LIB/$ARGV[0].dem") or die "can't open $GNUPLOT_LIB/$ARGV[0].dem";
	open(OUT, ">$ARGV[0].html") or die "can't open $ARGV[0].html";
	binmode IN, ":encoding(UTF-8)";
	binmode OUT,":encoding(UTF-8)";

# open pipe to gnuplot and set terminal type
	open(GNUPLOT, "|$gnuplot") or die "can't find gnuplot";
	binmode GNUPLOT,":encoding(UTF-8)";
	if ((defined $ENV{DEMOTERM}) && $DEMOTERM ne "") {
	    print GNUPLOT "set term $DEMOTERM\n";
	} else {
	    print GNUPLOT "set term pngcairo font 'arial,10' transparent size 600,400\n";
	}
	print GNUPLOT "set output \"$ARGV[0].$plot.png\"\n";

# suppress animations
 	print GNUPLOT "NO_ANIMATION = 1\n";

# find out if gpsavediff is available in current path
	my $savescripts = T;
	{local $^W=0; $savescripts = open(FOO, "|gpsavediff") }
	close FOO if ($savescripts);

# Boiler plate header
	print OUT "<html>\n<head>\n<title>gnuplot demo script: $ARGV[0].dem </title>\n";
	print OUT "<meta charset=\"UTF-8\" />\n";
	print OUT "<link rel=\"stylesheet\" href=\"gnuplot_demo.css\" type=\"text/css\">\n"
		  if (-e "gnuplot_demo.css");
	print OUT "</head>\n";
	print OUT "<body>\n";
	print OUT "<a href=index.html><image src=return.png alt=\"Back to demo index\" class=\"icon-image\"></a>\n";
	print OUT "<h2>gnuplot demo script: <font color=blue>$ARGV[0].dem</font> </h2>\n";
	print OUT "<i>autogenerated by webify.pl on $date</i>";

# try to find gnuplot version
	$version = `$gnuplot --version`;
	print OUT "\n<br><i>gnuplot version $version</i>";
	print OUT "<hr>\n";

# Start processing
	print OUT "<table><tr><td class='LIMG'>";
	print OUT "<img src=\"$ARGV[0].$plot.png\" alt=\"\">\n";
	print OUT "</td><td>";
	print OUT "<pre>\n";

	while (<IN>) {
		if (/^ *pause -1/) {
			if ($savescripts) {
			    print OUT "<br><p>Click <a href=$ARGV[0].$plot.gnu>here</a> ",
				  "for minimal script to generate this plot</p>\n";
			    print GNUPLOT "save \"| gpsavediff > $ARGV[0].$plot.gnu\"\n";
			}
			print OUT "</pre></td></tr></table>\n<br clear=all>\n<hr>\n";
			$plot++;
			print OUT "<table><tr><td class='LIMG'>";
			print OUT "<img src=\"$ARGV[0].$plot.png\" alt=\"\">\n";
			print OUT "</td><td>\n";
			print OUT "<pre>\n";
			print GNUPLOT "set output \"$ARGV[0].$plot.png\"\n";
		} elsif (/^pause/) {
			print GNUPLOT "set output \"$ARGV[0].$plot.png\"\n";
		} elsif (/^ *reset/) {
			print GNUPLOT;
		} else {
			print OUT HTML::Entities::encode($_);
			print GNUPLOT;
		}
	}

# Amazingly enough, that's it.
# Unlink leftover empty plot before leaving.
	close GNUPLOT;
	unlink("$ARGV[0].$plot.png");
	print OUT "</pre></td></tr></table>\n";
	print OUT "</body>\n</html>\n";

