/* main.c generated by valac 0.56.18, the Vala compiler
 * generated from main.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright(c) 2013 Peng Huang <shawn.p.huang@gmail.com>
 * Copyright(c) 2015-2025 Takao Fujiwara <takao.fujiwara1@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <ibus.h>
#include <gobject/gvaluecollector.h>
#include <stdio.h>
#include <gio/gio.h>
#include <ibusinternal.h>
#include <unistd.h>
#include <wayland-client.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <glib/gstdio.h>
#include <ibusimmodule.h>
#include <locale.h>

#define IBUS_SCHEMAS_GENERAL "org.freedesktop.ibus.general"
#define IBUS_SCHEMAS_GENERAL_HOTKEY "org.freedesktop.ibus.general.hotkey"
#define IBUS_SCHEMAS_PANEL "org.freedesktop.ibus.panel"
#define IBUS_SCHEMAS_PANEL_EMOJI "org.freedesktop.ibus.panel.emoji"
#define SYSTEMD_SESSION_GNOME_FILE "org.freedesktop.IBus.session.GNOME.service"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ENGINE_LIST (engine_list_get_type ())
#define ENGINE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENGINE_LIST, EngineList))
#define ENGINE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENGINE_LIST, EngineListClass))
#define IS_ENGINE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENGINE_LIST))
#define IS_ENGINE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENGINE_LIST))
#define ENGINE_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENGINE_LIST, EngineListClass))

typedef struct _EngineList EngineList;
typedef struct _EngineListClass EngineListClass;
typedef struct _EngineListPrivate EngineListPrivate;
typedef struct _ParamSpecEngineList ParamSpecEngineList;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _wl_display_disconnect0(var) ((var == NULL) ? NULL : (var = (wl_display_disconnect (var), NULL)))
typedef void (*wl_RegistryListenerGlobal) (void* data, struct wl_registry* wl_registry, guint32 name, const gchar* interface, guint32 version);
typedef void (*wl_RegistryListenerGlobalRemove) (void* data, struct wl_registry* wl_registry, guint32 name);
#define _wl_registry_destroy0(var) ((var == NULL) ? NULL : (var = (wl_registry_destroy (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_source_unref0(var) ((var == NULL) ? NULL : (var = (g_source_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _engine_list_unref0(var) ((var == NULL) ? NULL : (var = (engine_list_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define TYPE_KRC_FILE (krc_file_get_type ())
#define KRC_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KRC_FILE, KRcFile))
#define KRC_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KRC_FILE, KRcFileClass))
#define IS_KRC_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KRC_FILE))
#define IS_KRC_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KRC_FILE))
#define KRC_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KRC_FILE, KRcFileClass))

typedef struct _KRcFile KRcFile;
typedef struct _KRcFileClass KRcFileClass;
#define _krc_file_unref0(var) ((var == NULL) ? NULL : (var = (krc_file_unref (var), NULL)))
typedef struct _Block3Data Block3Data;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_settings_schema_source_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_source_unref (var), NULL)))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
typedef gint (*EntryFunc) (gchar** argv, gint argv_length1, gpointer user_data);

#define TYPE_COMMAND_ENTRY (command_entry_get_type ())
typedef struct _CommandEntry CommandEntry;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _EngineList {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EngineListPrivate * priv;
	IBusEngineDesc** data;
	gint data_length1;
	gint _data_size_;
};

struct _EngineListClass {
	GTypeClass parent_class;
	void (*finalize) (EngineList *self);
};

struct _ParamSpecEngineList {
	GParamSpec parent_instance;
};

struct _Block1Data {
	int _ref_count_;
	GDBusConnection* connection;
	gboolean verbose;
};

struct _Block2Data {
	int _ref_count_;
	guint id;
	gboolean retval;
	GDBusConnection* connection;
	gboolean verbose;
};

struct _Block3Data {
	int _ref_count_;
	guint id;
	IBusBus* bus;
};

struct _CommandEntry {
	const gchar* name;
	const gchar* description;
	EntryFunc entry;
	gpointer entry_target;
};

VALA_EXTERN gboolean is_wayland_session;
gboolean is_wayland_session = FALSE;
VALA_EXTERN gboolean name_only;
gboolean name_only = FALSE;
VALA_EXTERN gboolean is_system;
gboolean is_system = FALSE;
VALA_EXTERN gchar* cache_file;
gchar* cache_file = NULL;
VALA_EXTERN gchar* engine_id;
gchar* engine_id = NULL;
VALA_EXTERN gboolean verbose;
gboolean verbose = FALSE;
VALA_EXTERN gchar* daemon_type;
gchar* daemon_type = NULL;
VALA_EXTERN gchar* systemd_service_file;
gchar* systemd_service_file = NULL;
VALA_EXTERN GMainLoop* loop;
GMainLoop* loop = NULL;
static gpointer engine_list_parent_class = NULL;
VALA_EXTERN gchar* program_name;
gchar* program_name = NULL;

VALA_EXTERN gpointer engine_list_ref (gpointer instance);
VALA_EXTERN void engine_list_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_engine_list (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_engine_list (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_engine_list (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_engine_list (const GValue* value);
VALA_EXTERN GType engine_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EngineList, engine_list_unref)
VALA_EXTERN EngineList* engine_list_new (void);
VALA_EXTERN EngineList* engine_list_construct (GType object_type);
static void engine_list_finalize (EngineList * obj);
static GType engine_list_get_type_once (void);
VALA_EXTERN gboolean is_kde (gboolean verbose);
VALA_EXTERN IBusBus* get_bus (void);
VALA_EXTERN void name_appeared_handler (GDBusConnection* connection,
                            const gchar* name,
                            const gchar* name_owner);
VALA_EXTERN void kde_virtual_keyboard_avail_cb (GDBusConnection* connection,
                                    const gchar* sender_name,
                                    const gchar* object_path,
                                    const gchar* interface_name,
                                    const gchar* signal_name,
                                    GVariant* parameters);
VALA_EXTERN GDBusConnection* get_session_bus (gboolean verbose);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void _name_appeared_handler_gbus_name_appeared_callback (GDBusConnection* connection,
                                                         const gchar* name,
                                                         const gchar* name_owner,
                                                         gpointer self);
static void __lambda4_ (Block1Data* _data1_,
                 GObject* obj,
                 GAsyncResult* res);
static void ___lambda4__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
VALA_EXTERN gchar* get_ibus_systemd_object_path (GDBusConnection* connection,
                                     gboolean verbose);
VALA_EXTERN gboolean is_running_daemon_via_systemd (GDBusConnection* connection,
                                        const gchar* object_path,
                                        gboolean verbose);
VALA_EXTERN void registry_global_cb (void* data,
                         struct wl_registry* wl_registry,
                         guint32 name,
                         const gchar* interface,
                         guint32 version);
VALA_EXTERN void registry_global_remove_cb (void* data,
                                struct wl_registry* wl_registry,
                                guint32 name);
VALA_EXTERN gboolean check_wayland_protocols (void);
static void _registry_global_cb_wl_registrylistenerglobal (void* data,
                                                    struct wl_registry* wl_registry,
                                                    guint32 name,
                                                    const gchar* interface,
                                                    guint32 version);
static void _registry_global_remove_cb_wl_registrylistenerglobalremove (void* data,
                                                                 struct wl_registry* wl_registry,
                                                                 guint32 name);
VALA_EXTERN gboolean start_daemon_in_wayland (gboolean restart,
                                  gchar** _argv,
                                  gint _argv_length1);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add4 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add5 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add6 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
VALA_EXTERN gboolean start_daemon_with_dbus_systemd (GDBusConnection* connection,
                                         gboolean restart,
                                         gboolean verbose);
VALA_EXTERN gboolean operate_daemon_with_dbus_kde_real (GDBusConnection* connection,
                                            gboolean verbose);
static void _kde_virtual_keyboard_avail_cb_gd_bus_signal_callback (GDBusConnection* connection,
                                                            const gchar* sender_name,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* signal_name,
                                                            GVariant* parameters,
                                                            gpointer self);
VALA_EXTERN gboolean operate_daemon_with_dbus_kde (GDBusConnection* connection,
                                       gboolean start,
                                       gboolean verbose);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean __lambda5_ (Block2Data* _data2_);
static gboolean ___lambda5__gsource_func (gpointer self);
VALA_EXTERN gint list_engine (gchar** argv,
                  gint argv_length1);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void _g_free0_ (gpointer var);
static void _engine_list_unref0_ (gpointer var);
static void _vala_array_add7 (IBusEngineDesc** * array,
                       gint* length,
                       gint* size,
                       IBusEngineDesc* value);
VALA_EXTERN gint exec_setxkbmap (IBusEngineDesc* engine);
static void _vala_array_add8 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add9 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add10 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add11 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add12 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add13 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add14 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
VALA_EXTERN gint get_set_engine (gchar** argv,
                     gint argv_length1);
VALA_EXTERN gint message_watch (gchar** argv,
                    gint argv_length1);
VALA_EXTERN gboolean operate_daemon_in_kde_wayland (GDBusConnection* connection,
                                        gboolean start,
                                        gboolean verbose);
VALA_EXTERN gpointer krc_file_ref (gpointer instance);
VALA_EXTERN void krc_file_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_krc_file (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags);
VALA_EXTERN void value_set_krc_file (GValue* value,
                         gpointer v_object);
VALA_EXTERN void value_take_krc_file (GValue* value,
                          gpointer v_object);
VALA_EXTERN gpointer value_get_krc_file (const GValue* value);
VALA_EXTERN GType krc_file_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (KRcFile, krc_file_unref)
VALA_EXTERN KRcFile* krc_file_new (void);
VALA_EXTERN KRcFile* krc_file_construct (GType object_type);
VALA_EXTERN gboolean krc_file_load_from_file (KRcFile* self,
                                  const gchar* path,
                                  GKeyFileFlags flags,
                                  GError** error);
VALA_EXTERN gboolean krc_file_has_group (KRcFile* self,
                             const gchar* group_name);
VALA_EXTERN gboolean krc_file_has_key (KRcFile* self,
                           const gchar* group_name,
                           const gchar* key,
                           GError** error);
VALA_EXTERN gchar* krc_file_get_value (KRcFile* self,
                           const gchar* group_name,
                           const gchar* key,
                           GError** error);
VALA_EXTERN void krc_file_set_value (KRcFile* self,
                         const gchar* group_name,
                         const gchar* key,
                         const gchar* value);
VALA_EXTERN gboolean krc_file_save_to_file (KRcFile* self,
                                const gchar* filename,
                                GError** error);
VALA_EXTERN gchar** krc_file_get_keys (KRcFile* self,
                           const gchar* group_name,
                           gint* result_length1,
                           GError** error);
VALA_EXTERN gboolean krc_file_remove_group (KRcFile* self,
                                const gchar* group_name,
                                GError** error);
VALA_EXTERN gboolean krc_file_remove_key (KRcFile* self,
                              const gchar* group_name,
                              const gchar* key,
                              GError** error);
VALA_EXTERN gboolean start_daemon_with_systemd (gboolean restart,
                                    gboolean verbose);
VALA_EXTERN gint start_daemon_real (gchar** argv,
                        gint argv_length1,
                        gboolean restart);
VALA_EXTERN gint restart_daemon (gchar** argv,
                     gint argv_length1);
VALA_EXTERN gint start_daemon (gchar** argv,
                   gint argv_length1);
VALA_EXTERN gboolean exit_daemon_with_systemd (IBusBus* bus,
                                   gboolean verbose);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gboolean __lambda6_ (Block3Data* _data3_);
static gboolean ___lambda6__gsource_func (gpointer self);
VALA_EXTERN gint exit_daemon (gchar** argv,
                  gint argv_length1);
VALA_EXTERN gint print_version (gchar** argv,
                    gint argv_length1);
VALA_EXTERN gint read_cache (gchar** argv,
                 gint argv_length1);
VALA_EXTERN gint write_cache (gchar** argv,
                  gint argv_length1);
VALA_EXTERN gint print_address (gchar** argv,
                    gint argv_length1);
VALA_EXTERN gint read_config_options (gchar** argv,
                          gint argv_length1);
VALA_EXTERN GSList* get_ibus_schemas (void);
VALA_EXTERN gint read_config (gchar** argv,
                  gint argv_length1);
static inline void _g_slist_free__g_free0_ (GSList* self);
VALA_EXTERN gint reset_config (gchar** argv,
                   gint argv_length1);
VALA_EXTERN gint emoji_dialog (gchar** argv,
                   gint argv_length1);
VALA_EXTERN gint read_im_module (gchar** argv,
                     gint argv_length1);
VALA_EXTERN gint print_help (gchar** argv,
                 gint argv_length1);
VALA_EXTERN void print_usage (FILE* stream);
VALA_EXTERN GType command_entry_get_type (void) G_GNUC_CONST ;
VALA_EXTERN CommandEntry* command_entry_dup (const CommandEntry* self);
VALA_EXTERN void command_entry_free (CommandEntry* self);
static gint _get_set_engine_entry_func (gchar** argv,
                                 gint argv_length1,
                                 gpointer self);
static gint _exit_daemon_entry_func (gchar** argv,
                              gint argv_length1,
                              gpointer self);
static gint _list_engine_entry_func (gchar** argv,
                              gint argv_length1,
                              gpointer self);
static gint _message_watch_entry_func (gchar** argv,
                                gint argv_length1,
                                gpointer self);
static gint _restart_daemon_entry_func (gchar** argv,
                                 gint argv_length1,
                                 gpointer self);
static gint _start_daemon_entry_func (gchar** argv,
                               gint argv_length1,
                               gpointer self);
static gint _print_version_entry_func (gchar** argv,
                                gint argv_length1,
                                gpointer self);
static gint _read_cache_entry_func (gchar** argv,
                             gint argv_length1,
                             gpointer self);
static gint _write_cache_entry_func (gchar** argv,
                              gint argv_length1,
                              gpointer self);
static gint _print_address_entry_func (gchar** argv,
                                gint argv_length1,
                                gpointer self);
static gint _read_config_entry_func (gchar** argv,
                              gint argv_length1,
                              gpointer self);
static gint _reset_config_entry_func (gchar** argv,
                               gint argv_length1,
                               gpointer self);
static gint _emoji_dialog_entry_func (gchar** argv,
                               gint argv_length1,
                               gpointer self);
static gint _read_im_module_entry_func (gchar** argv,
                                 gint argv_length1,
                                 gpointer self);
static gint _print_help_entry_func (gchar** argv,
                             gint argv_length1,
                             gpointer self);
static gint _vala_main (gchar** argv,
                 gint argv_length1);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

const CommandEntry commands[15] = {{"engine", N_ ("Set or get engine"), _get_set_engine_entry_func}, {"exit", N_ ("Exit ibus-daemon"), _exit_daemon_entry_func}, {"list-engine", N_ ("Show available engines"), _list_engine_entry_func}, {"watch", N_ ("(Not implemented)"), _message_watch_entry_func}, {"restart", N_ ("Restart ibus-daemon"), _restart_daemon_entry_func}, {"start", N_ ("Start ibus-daemon"), _start_daemon_entry_func}, {"version", N_ ("Show version"), _print_version_entry_func}, {"read-cache", N_ ("Show the content of registry cache"), _read_cache_entry_func}, {"write-cache", N_ ("Create registry cache"), _write_cache_entry_func}, {"address", N_ ("Print the D-Bus address of ibus-daemon"), _print_address_entry_func}, {"read-config", N_ ("Show the configuration values"), _read_config_entry_func}, {"reset-config", N_ ("Reset the configuration values"), _reset_config_entry_func}, {"emoji", N_ ("Save emoji on dialog to clipboard"), _emoji_dialog_entry_func}, {"im-module", N_ ("Retrieve im-module value from GTK instance"), _read_im_module_entry_func}, {"help", N_ ("Show this information"), _print_help_entry_func}};

EngineList*
engine_list_construct (GType object_type)
{
	EngineList* self = NULL;
	self = (EngineList*) g_type_create_instance (object_type);
	return self;
}

EngineList*
engine_list_new (void)
{
	return engine_list_construct (TYPE_ENGINE_LIST);
}

static void
value_engine_list_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_engine_list_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		engine_list_unref (value->data[0].v_pointer);
	}
}

static void
value_engine_list_copy_value (const GValue* src_value,
                              GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = engine_list_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_engine_list_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_engine_list_collect_value (GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		EngineList * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = engine_list_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_engine_list_lcopy_value (const GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	EngineList ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = engine_list_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_engine_list (const gchar* name,
                        const gchar* nick,
                        const gchar* blurb,
                        GType object_type,
                        GParamFlags flags)
{
	ParamSpecEngineList* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_ENGINE_LIST), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_engine_list (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENGINE_LIST), NULL);
	return value->data[0].v_pointer;
}

void
value_set_engine_list (GValue* value,
                       gpointer v_object)
{
	EngineList * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENGINE_LIST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ENGINE_LIST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		engine_list_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		engine_list_unref (old);
	}
}

void
value_take_engine_list (GValue* value,
                        gpointer v_object)
{
	EngineList * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENGINE_LIST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ENGINE_LIST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		engine_list_unref (old);
	}
}

static void
engine_list_class_init (EngineListClass * klass,
                        gpointer klass_data)
{
	engine_list_parent_class = g_type_class_peek_parent (klass);
	((EngineListClass *) klass)->finalize = engine_list_finalize;
}

static void
engine_list_instance_init (EngineList * self,
                           gpointer klass)
{
	IBusEngineDesc** _tmp0_;
	_tmp0_ = g_new0 (IBusEngineDesc*, 0 + 1);
	self->data = _tmp0_;
	self->data_length1 = 0;
	self->_data_size_ = self->data_length1;
	self->ref_count = 1;
}

static void
engine_list_finalize (EngineList * obj)
{
	EngineList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ENGINE_LIST, EngineList);
	g_signal_handlers_destroy (self);
	self->data = (_vala_array_free (self->data, self->data_length1, (GDestroyNotify) g_object_unref), NULL);
}

static GType
engine_list_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_engine_list_init, value_engine_list_free_value, value_engine_list_copy_value, value_engine_list_peek_pointer, "p", value_engine_list_collect_value, "p", value_engine_list_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (EngineListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) engine_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EngineList), 0, (GInstanceInitFunc) engine_list_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType engine_list_type_id;
	engine_list_type_id = g_type_register_fundamental (g_type_fundamental_next (), "EngineList", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return engine_list_type_id;
}

GType
engine_list_get_type (void)
{
	static volatile gsize engine_list_type_id__once = 0;
	if (g_once_init_enter (&engine_list_type_id__once)) {
		GType engine_list_type_id;
		engine_list_type_id = engine_list_get_type_once ();
		g_once_init_leave (&engine_list_type_id__once, engine_list_type_id);
	}
	return engine_list_type_id__once;
}

gpointer
engine_list_ref (gpointer instance)
{
	EngineList * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
engine_list_unref (gpointer instance)
{
	EngineList * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		ENGINE_LIST_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

gboolean
is_kde (gboolean verbose)
{
	const gchar* desktop = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	const gchar* _tmp9_;
	gboolean result;
	_tmp0_ = g_getenv ("XDG_CURRENT_DESKTOP");
	desktop = _tmp0_;
	_tmp1_ = desktop;
	if (g_strcmp0 (_tmp1_, "KDE") == 0) {
		result = TRUE;
		return result;
	}
	_tmp3_ = desktop;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = desktop;
		_tmp2_ = g_strcmp0 (_tmp4_, "(null)") == 0;
	}
	if (_tmp2_) {
		const gchar* _tmp5_;
		_tmp5_ = g_getenv ("XDG_SESSION_DESKTOP");
		desktop = _tmp5_;
	}
	_tmp7_ = desktop;
	if (g_strcmp0 (_tmp7_, "plasma") == 0) {
		_tmp6_ = TRUE;
	} else {
		const gchar* _tmp8_;
		_tmp8_ = desktop;
		_tmp6_ = g_strcmp0 (_tmp8_, "KDE-wayland") == 0;
	}
	if (_tmp6_) {
		result = TRUE;
		return result;
	}
	_tmp9_ = desktop;
	if (_tmp9_ == NULL) {
		if (verbose) {
			FILE* _tmp10_;
			_tmp10_ = stderr;
			fprintf (_tmp10_, "%s", "XDG_CURRENT_DESKTOP is not exported in your " "desktop session.\n");
		}
	} else {
		if (verbose) {
			FILE* _tmp11_;
			const gchar* _tmp12_;
			_tmp11_ = stderr;
			_tmp12_ = desktop;
			fprintf (_tmp11_, "Your desktop session \"%s\" is not KDE\n.", _tmp12_);
		}
	}
	result = FALSE;
	return result;
}

IBusBus*
get_bus (void)
{
	IBusBus* bus = NULL;
	IBusBus* _tmp0_;
	IBusBus* _tmp1_;
	IBusBus* result;
	_tmp0_ = ibus_bus_new ();
	g_object_ref_sink (_tmp0_);
	bus = _tmp0_;
	_tmp1_ = bus;
	if (!ibus_bus_is_connected (_tmp1_)) {
		result = NULL;
		_g_object_unref0 (bus);
		return result;
	}
	result = bus;
	return result;
}

void
name_appeared_handler (GDBusConnection* connection,
                       const gchar* name,
                       const gchar* name_owner)
{
	GMainLoop* _tmp1_;
	g_return_if_fail (connection != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (name_owner != NULL);
	if (verbose) {
		FILE* _tmp0_;
		_tmp0_ = stderr;
		fprintf (_tmp0_, "NameAquired %s:%s\n", name, name_owner);
	}
	_tmp1_ = loop;
	g_main_loop_quit (_tmp1_);
	_g_main_loop_unref0 (loop);
	loop = NULL;
}

void
kde_virtual_keyboard_avail_cb (GDBusConnection* connection,
                               const gchar* sender_name,
                               const gchar* object_path,
                               const gchar* interface_name,
                               const gchar* signal_name,
                               GVariant* parameters)
{
	GMainLoop* _tmp1_;
	g_return_if_fail (connection != NULL);
	g_return_if_fail (object_path != NULL);
	g_return_if_fail (interface_name != NULL);
	g_return_if_fail (signal_name != NULL);
	g_return_if_fail (parameters != NULL);
	if (verbose) {
		FILE* _tmp0_;
		_tmp0_ = stderr;
		fprintf (_tmp0_, "%s.%s %s returned.\n", interface_name, signal_name, object_path);
	}
	_tmp1_ = loop;
	g_main_loop_quit (_tmp1_);
	_g_main_loop_unref0 (loop);
	loop = NULL;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->connection);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
_name_appeared_handler_gbus_name_appeared_callback (GDBusConnection* connection,
                                                    const gchar* name,
                                                    const gchar* name_owner,
                                                    gpointer self)
{
	name_appeared_handler (connection, name, name_owner);
}

static void
__lambda4_ (Block1Data* _data1_,
            GObject* obj,
            GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		GDBusConnection* _tmp0_ = NULL;
		GDBusConnection* _tmp1_;
		GDBusConnection* _tmp2_;
		_tmp1_ = g_bus_get_finish (res, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (_data1_->connection);
		_data1_->connection = _tmp2_;
		if (_data1_->verbose) {
			FILE* _tmp3_;
			_tmp3_ = stderr;
			fprintf (_tmp3_, "The session bus is generated.\n");
		}
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		GMainLoop* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		if (_data1_->verbose) {
			FILE* _tmp4_;
			GError* _tmp5_;
			const gchar* _tmp6_;
			_tmp4_ = stderr;
			_tmp5_ = e;
			_tmp6_ = _tmp5_->message;
			fprintf (_tmp4_, "The session bus error: %s\n", _tmp6_);
		}
		_tmp7_ = loop;
		if (_tmp7_ != NULL) {
			GMainLoop* _tmp8_;
			_tmp8_ = loop;
			g_main_loop_quit (_tmp8_);
			_g_main_loop_unref0 (loop);
			loop = NULL;
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda4__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda4_ (self, source_object, res);
	block1_data_unref (self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GDBusConnection*
get_session_bus (gboolean verbose)
{
	Block1Data* _data1_;
	GMainLoop* _tmp0_;
	GMainLoop* _tmp1_;
	GMainLoop* _tmp2_;
	GDBusConnection* _tmp3_;
	GDBusConnection* _tmp5_;
	GDBusConnection* _tmp6_;
	GDBusConnection* result;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->verbose = verbose;
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (loop);
	loop = _tmp0_;
	_tmp1_ = loop;
	_vala_assert (_tmp1_ != NULL, "loop != null");
	g_bus_watch_name_with_closures (G_BUS_TYPE_SESSION, DBUS_SERVICE_DBUS, G_BUS_NAME_WATCHER_FLAGS_NONE, (GClosure*) g_cclosure_new ((GCallback) _name_appeared_handler_gbus_name_appeared_callback, NULL, (GClosureNotify) NULL), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_data1_->connection = NULL;
	g_bus_get (G_BUS_TYPE_SESSION, NULL, ___lambda4__gasync_ready_callback, block1_data_ref (_data1_));
	_tmp2_ = loop;
	g_main_loop_run (_tmp2_);
	_tmp3_ = _data1_->connection;
	if (g_dbus_connection_is_closed (_tmp3_)) {
		if (_data1_->verbose) {
			FILE* _tmp4_;
			_tmp4_ = stderr;
			fprintf (_tmp4_, "The session bus is closed.\n");
		}
		result = NULL;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	_tmp5_ = _data1_->connection;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	result = _tmp6_;
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

gchar*
get_ibus_systemd_object_path (GDBusConnection* connection,
                              gboolean verbose)
{
	gchar* object_path = NULL;
	const gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (connection != NULL, NULL);
	object_path = NULL;
	_tmp0_ = systemd_service_file;
	_vala_assert (_tmp0_ != NULL, "systemd_service_file != null");
	{
		GVariant* variant = NULL;
		const gchar* _tmp1_;
		GVariant* _tmp2_;
		GVariant* _tmp3_;
		GVariantType* _tmp4_;
		GVariantType* _tmp5_;
		GVariant* _tmp6_;
		GVariant* _tmp7_;
		_tmp1_ = systemd_service_file;
		_tmp2_ = g_variant_new ("(s)", _tmp1_, NULL);
		g_variant_ref_sink (_tmp2_);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_variant_type_new ("(o)");
		_tmp5_ = _tmp4_;
		_tmp6_ = g_dbus_connection_call_sync (connection, "org.freedesktop.systemd1", "/org/freedesktop/systemd1", "org.freedesktop.systemd1.Manager", "GetUnit", _tmp3_, _tmp5_, G_DBUS_CALL_FLAGS_NONE, -1, NULL, &_inner_error0_);
		_tmp7_ = _tmp6_;
		_g_variant_type_free0 (_tmp5_);
		_g_variant_unref0 (_tmp3_);
		variant = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		g_variant_get (variant, "(o)", &object_path, NULL);
		if (verbose) {
			FILE* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_tmp8_ = stderr;
			_tmp9_ = object_path;
			_tmp10_ = systemd_service_file;
			fprintf (_tmp8_, "Succeed to get an object path \"%s\" for IBus " "systemd service file \"%s\".\n", _tmp9_, _tmp10_);
		}
		result = object_path;
		_g_variant_unref0 (variant);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		if (verbose) {
			FILE* _tmp11_;
			const gchar* _tmp12_;
			GError* _tmp13_;
			const gchar* _tmp14_;
			_tmp11_ = stderr;
			_tmp12_ = systemd_service_file;
			_tmp13_ = e;
			_tmp14_ = _tmp13_->message;
			fprintf (_tmp11_, "IBus systemd service file \"%s\" is not installed " "in your system: %s\n", _tmp12_, _tmp14_);
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (object_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = NULL;
	_g_free0 (object_path);
	return result;
}

gboolean
is_running_daemon_via_systemd (GDBusConnection* connection,
                               const gchar* object_path,
                               gboolean verbose)
{
	gchar* state = NULL;
	const gchar* _tmp16_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (connection != NULL, FALSE);
	g_return_val_if_fail (object_path != NULL, FALSE);
	state = NULL;
	{
		while (TRUE) {
			GVariant* variant = NULL;
			GVariant* _tmp0_;
			GVariant* _tmp1_;
			GVariantType* _tmp2_;
			GVariantType* _tmp3_;
			GVariant* _tmp4_;
			GVariant* _tmp5_;
			GVariant* child = NULL;
			GVariant* _tmp6_;
			GVariant* _tmp7_;
			gchar* _tmp8_;
			const gchar* _tmp11_;
			_tmp0_ = g_variant_new ("(ss)", "org.freedesktop.systemd1.Unit", "ActiveState", NULL);
			g_variant_ref_sink (_tmp0_);
			_tmp1_ = _tmp0_;
			_tmp2_ = g_variant_type_new ("(v)");
			_tmp3_ = _tmp2_;
			_tmp4_ = g_dbus_connection_call_sync (connection, "org.freedesktop.systemd1", object_path, "org.freedesktop.DBus.Properties", "Get", _tmp1_, _tmp3_, G_DBUS_CALL_FLAGS_NONE, -1, NULL, &_inner_error0_);
			_tmp5_ = _tmp4_;
			_g_variant_type_free0 (_tmp3_);
			_g_variant_unref0 (_tmp1_);
			variant = _tmp5_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			child = NULL;
			_tmp6_ = variant;
			g_variant_get (_tmp6_, "(v)", &child, NULL);
			_tmp7_ = child;
			_tmp8_ = g_variant_dup_string (_tmp7_, NULL);
			_g_free0 (state);
			state = _tmp8_;
			if (verbose) {
				FILE* _tmp9_;
				const gchar* _tmp10_;
				_tmp9_ = stderr;
				_tmp10_ = state;
				fprintf (_tmp9_, "systemd state is \"%s\" for an object " "path \"%s\".\n", _tmp10_, object_path);
			}
			_tmp11_ = state;
			if (g_strcmp0 (_tmp11_, "activating") != 0) {
				_g_variant_unref0 (child);
				_g_variant_unref0 (variant);
				break;
			}
			sleep ((guint) 1);
			_g_variant_unref0 (child);
			_g_variant_unref0 (variant);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		if (verbose) {
			FILE* _tmp12_;
			GError* _tmp13_;
			const gchar* _tmp14_;
			_tmp12_ = stderr;
			_tmp13_ = e;
			_tmp14_ = _tmp13_->message;
			fprintf (_tmp12_, "%s\n", _tmp14_);
		}
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (state);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp15_ = FALSE;
		_g_free0 (state);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp15_;
	}
	_tmp16_ = state;
	if (g_strcmp0 (_tmp16_, "active") == 0) {
		result = TRUE;
		_g_free0 (state);
		return result;
	}
	result = FALSE;
	_g_free0 (state);
	return result;
}

void
registry_global_cb (void* data,
                    struct wl_registry* wl_registry,
                    guint32 name,
                    const gchar* interface,
                    guint32 version)
{
	g_return_if_fail (wl_registry != NULL);
	g_return_if_fail (interface != NULL);
	if (verbose) {
		FILE* _tmp0_;
		_tmp0_ = stderr;
		fprintf (_tmp0_, "Wl.RegistryListenerGlobal name: %3u interface: %s " "version: %u.\n", name, interface, version);
	}
	if (g_strcmp0 (interface, "zwp_input_method_manager_v2") == 0) {
		is_wayland_session = TRUE;
	} else {
		if (g_strcmp0 (interface, "zwp_input_method_v1") == 0) {
			FILE* _tmp1_;
			_tmp1_ = stderr;
			fprintf (_tmp1_, "%s", "Wayland input-method protocol version 1 does not " "work with the forked application.\n");
			is_wayland_session = TRUE;
		}
	}
}

void
registry_global_remove_cb (void* data,
                           struct wl_registry* wl_registry,
                           guint32 name)
{
	g_return_if_fail (wl_registry != NULL);
}

static void
_registry_global_cb_wl_registrylistenerglobal (void* data,
                                               struct wl_registry* wl_registry,
                                               guint32 name,
                                               const gchar* interface,
                                               guint32 version)
{
	registry_global_cb (data, wl_registry, name, interface, version);
}

static void
_registry_global_remove_cb_wl_registrylistenerglobalremove (void* data,
                                                            struct wl_registry* wl_registry,
                                                            guint32 name)
{
	registry_global_remove_cb (data, wl_registry, name);
}

gboolean
check_wayland_protocols (void)
{
	struct wl_display* display = NULL;
	struct wl_display* _tmp0_;
	struct wl_display* _tmp1_;
	struct wl_registry* registry = NULL;
	struct wl_display* _tmp2_;
	struct wl_registry* _tmp3_;
	struct wl_registry_listener listener = {0};
	struct wl_registry_listener _tmp4_ = {0};
	struct wl_registry* _tmp5_;
	struct wl_registry_listener _tmp6_;
	struct wl_display* _tmp7_;
	gboolean result;
	_tmp0_ = wl_display_connect (NULL);
	display = _tmp0_;
	_tmp1_ = display;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_wl_display_disconnect0 (display);
		return result;
	}
	_tmp2_ = display;
	_tmp3_ = wl_display_get_registry (_tmp2_);
	registry = _tmp3_;
	memset (&_tmp4_, 0, sizeof (struct wl_registry_listener));
	_tmp4_.global = _registry_global_cb_wl_registrylistenerglobal;
	_tmp4_.global_remove = _registry_global_remove_cb_wl_registrylistenerglobalremove;
	listener = _tmp4_;
	_tmp5_ = registry;
	_tmp6_ = listener;
	wl_registry_add_listener (_tmp5_, &_tmp6_, NULL);
	_tmp7_ = display;
	wl_display_roundtrip (_tmp7_);
	result = TRUE;
	_wl_registry_destroy0 (registry);
	_wl_display_disconnect0 (display);
	return result;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add4 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add5 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add6 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

gboolean
start_daemon_in_wayland (gboolean restart,
                         gchar** _argv,
                         gint _argv_length1)
{
	IBusBus* bus = NULL;
	IBusBus* _tmp1_;
	gchar* cmd = NULL;
	gchar* _tmp10_;
	GFile* file = NULL;
	const gchar* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	gchar* daemon_args = NULL;
	gchar* _tmp15_;
	gchar** argv = NULL;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar** _tmp19_;
	gint argv_length1;
	gint _argv_size_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar** env = NULL;
	gchar** _tmp26_;
	gchar** _tmp27_;
	gint env_length1;
	gint _env_size_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	check_wayland_protocols ();
	if (!is_wayland_session) {
		if (verbose) {
			FILE* _tmp0_;
			_tmp0_ = stderr;
			fprintf (_tmp0_, "Cannot find the Wayland input-method protocol.\n");
		}
		result = FALSE;
		return result;
	}
	_tmp1_ = get_bus ();
	bus = _tmp1_;
	if (restart) {
		IBusBus* _tmp2_;
		IBusBus* _tmp4_;
		_tmp2_ = bus;
		if (_tmp2_ == NULL) {
			FILE* _tmp3_;
			_tmp3_ = stderr;
			fprintf (_tmp3_, "%s", _ ("Can't connect to IBus.\n"));
			result = FALSE;
			_g_object_unref0 (bus);
			return result;
		}
		_tmp4_ = bus;
		ibus_bus_exit (_tmp4_, FALSE);
		if (verbose) {
			FILE* _tmp5_;
			_tmp5_ = stderr;
			fprintf (_tmp5_, "%s", "Succeed to exit ibus-daemon with an IBus API " "directly.\n");
		}
		_g_object_unref0 (bus);
		bus = NULL;
	} else {
		IBusBus* _tmp6_;
		_tmp6_ = bus;
		if (_tmp6_ != NULL) {
			FILE* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp7_ = stderr;
			_tmp8_ = g_strdup_printf ("%s\n", _ ("IBus is running."));
			_tmp9_ = _tmp8_;
			fprintf (_tmp7_, "%s", _tmp9_);
			_g_free0 (_tmp9_);
			exit (EXIT_FAILURE);
			result = TRUE;
			_g_object_unref0 (bus);
			return result;
		}
	}
	_tmp10_ = g_strdup (LIBEXECDIR "/ibus-ui-gtk3");
	cmd = _tmp10_;
	_tmp11_ = cmd;
	_tmp12_ = g_file_new_for_path (_tmp11_);
	file = _tmp12_;
	_tmp13_ = file;
	if (!g_file_query_exists (_tmp13_, NULL)) {
		gchar* _tmp14_;
		_tmp14_ = g_strdup ("../ui/gtk3/ibus-ui-gtk3");
		_g_free0 (cmd);
		cmd = _tmp14_;
	}
	_tmp15_ = g_strdup ("--xim --panel disable");
	daemon_args = _tmp15_;
	if (_argv_length1 > 1) {
		gchar* _tmp16_;
		_tmp16_ = _vala_g_strjoinv (" ", _argv + 1, (gint) (_argv_length1 - 1));
		_g_free0 (daemon_args);
		daemon_args = _tmp16_;
	}
	_tmp17_ = cmd;
	_tmp18_ = g_strdup (_tmp17_);
	_tmp19_ = g_new0 (gchar*, 1 + 1);
	_tmp19_[0] = _tmp18_;
	argv = _tmp19_;
	argv_length1 = 1;
	_argv_size_ = argv_length1;
	_tmp20_ = g_strdup ("--enable-wayland-im");
	_vala_array_add2 (&argv, &argv_length1, &_argv_size_, _tmp20_);
	_tmp21_ = g_strdup ("--exec-daemon");
	_vala_array_add3 (&argv, &argv_length1, &_argv_size_, _tmp21_);
	_tmp22_ = g_strdup ("--daemon-args");
	_vala_array_add4 (&argv, &argv_length1, &_argv_size_, _tmp22_);
	_tmp23_ = daemon_args;
	_tmp24_ = g_strdup_printf ("%s", _tmp23_);
	_vala_array_add5 (&argv, &argv_length1, &_argv_size_, _tmp24_);
	if (verbose) {
		gchar* _tmp25_;
		_tmp25_ = g_strdup ("--verbose");
		_vala_array_add6 (&argv, &argv_length1, &_argv_size_, _tmp25_);
	}
	_tmp27_ = _tmp26_ = g_get_environ ();
	env = _tmp27_;
	env_length1 = _vala_array_length (_tmp26_);
	_env_size_ = env_length1;
	{
		gchar** _tmp28_;
		gint _tmp28__length1;
		gchar** _tmp29_;
		gint _tmp29__length1;
		_tmp28_ = argv;
		_tmp28__length1 = argv_length1;
		_tmp29_ = env;
		_tmp29__length1 = env_length1;
		g_spawn_async (NULL, _tmp28_, _tmp29_, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp30_ = FALSE;
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			env = (_vala_array_free (env, env_length1, (GDestroyNotify) g_free), NULL);
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (daemon_args);
			_g_object_unref0 (file);
			_g_free0 (cmd);
			_g_object_unref0 (bus);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp30_;
		}
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp31_;
		GError* _tmp32_;
		const gchar* _tmp33_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp31_ = stderr;
		_tmp32_ = e;
		_tmp33_ = _tmp32_->message;
		fprintf (_tmp31_, "%s\n", _tmp33_);
		exit (EXIT_FAILURE);
		result = TRUE;
		_g_error_free0 (e);
		env = (_vala_array_free (env, env_length1, (GDestroyNotify) g_free), NULL);
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (daemon_args);
		_g_object_unref0 (file);
		_g_free0 (cmd);
		_g_object_unref0 (bus);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp34_ = FALSE;
		env = (_vala_array_free (env, env_length1, (GDestroyNotify) g_free), NULL);
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (daemon_args);
		_g_object_unref0 (file);
		_g_free0 (cmd);
		_g_object_unref0 (bus);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp34_;
	}
	if (verbose) {
		const gchar* _tmp35_ = NULL;
		FILE* _tmp36_;
		if (restart) {
			_tmp35_ = "restart";
		} else {
			_tmp35_ = "start";
		}
		_tmp36_ = stderr;
		fprintf (_tmp36_, "Succeed to %s ibus-daemon with a Wayland " "input-method version 2.\n", _tmp35_);
	}
	result = TRUE;
	env = (_vala_array_free (env, env_length1, (GDestroyNotify) g_free), NULL);
	argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (daemon_args);
	_g_object_unref0 (file);
	_g_free0 (cmd);
	_g_object_unref0 (bus);
	return result;
}

gboolean
start_daemon_with_dbus_systemd (GDBusConnection* connection,
                                gboolean restart,
                                gboolean verbose)
{
	gchar* object_path = NULL;
	gchar* method = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (connection != NULL, FALSE);
	object_path = NULL;
	_tmp0_ = g_strdup ("StartUnit");
	method = _tmp0_;
	_tmp1_ = systemd_service_file;
	_vala_assert (_tmp1_ != NULL, "systemd_service_file != null");
	if (restart) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("RestartUnit");
		_g_free0 (method);
		method = _tmp2_;
	}
	{
		GVariant* variant = NULL;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		GVariant* _tmp5_;
		GVariant* _tmp6_;
		GVariantType* _tmp7_;
		GVariantType* _tmp8_;
		GVariant* _tmp9_;
		GVariant* _tmp10_;
		_tmp3_ = method;
		_tmp4_ = systemd_service_file;
		_tmp5_ = g_variant_new ("(ss)", _tmp4_, "fail", NULL);
		g_variant_ref_sink (_tmp5_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_variant_type_new ("(o)");
		_tmp8_ = _tmp7_;
		_tmp9_ = g_dbus_connection_call_sync (connection, "org.freedesktop.systemd1", "/org/freedesktop/systemd1", "org.freedesktop.systemd1.Manager", _tmp3_, _tmp6_, _tmp8_, G_DBUS_CALL_FLAGS_NONE, -1, NULL, &_inner_error0_);
		_tmp10_ = _tmp9_;
		_g_variant_type_free0 (_tmp8_);
		_g_variant_unref0 (_tmp6_);
		variant = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		g_variant_get (variant, "(o)", &object_path, NULL);
		if (verbose) {
			FILE* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			_tmp11_ = stderr;
			_tmp12_ = systemd_service_file;
			_tmp13_ = object_path;
			fprintf (_tmp11_, "Succeed to restart IBus daemon via IBus systemd " "service file \"%s\": \"%s\"\n", _tmp12_, _tmp13_);
		}
		result = TRUE;
		_g_variant_unref0 (variant);
		_g_free0 (method);
		_g_free0 (object_path);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		if (verbose) {
			const gchar* _tmp14_ = NULL;
			FILE* _tmp15_;
			const gchar* _tmp16_;
			GError* _tmp17_;
			const gchar* _tmp18_;
			if (restart) {
				_tmp14_ = "restart";
			} else {
				_tmp14_ = "start";
			}
			_tmp15_ = stderr;
			_tmp16_ = systemd_service_file;
			_tmp17_ = e;
			_tmp18_ = _tmp17_->message;
			fprintf (_tmp15_, "Failed to %s IBus daemon via IBus systemd " "service file \"%s\": %s\n", _tmp14_, _tmp16_, _tmp18_);
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp19_ = FALSE;
		_g_free0 (method);
		_g_free0 (object_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp19_;
	}
	result = FALSE;
	_g_free0 (method);
	_g_free0 (object_path);
	return result;
}

static void
_kde_virtual_keyboard_avail_cb_gd_bus_signal_callback (GDBusConnection* connection,
                                                       const gchar* sender_name,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* signal_name,
                                                       GVariant* parameters,
                                                       gpointer self)
{
	kde_virtual_keyboard_avail_cb (connection, sender_name, object_path, interface_name, signal_name, parameters);
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

gboolean
operate_daemon_with_dbus_kde_real (GDBusConnection* connection,
                                   gboolean verbose)
{
	GMainLoop* _tmp0_;
	GMainLoop* _tmp1_;
	guint subscripion_id = 0U;
	gchar* wayland_values = NULL;
	gchar* _tmp2_;
	GVariantBuilder* bytes = NULL;
	GVariantType* _tmp3_;
	GVariantType* _tmp4_;
	GVariantBuilder* _tmp5_;
	GVariantBuilder* _tmp6_;
	GVariantBuilder* bytes2 = NULL;
	GVariantType* _tmp14_;
	GVariantType* _tmp15_;
	GVariantBuilder* _tmp16_;
	GVariantBuilder* _tmp17_;
	GVariantBuilder* _tmp18_;
	GVariantBuilder* array = NULL;
	GVariantType* _tmp19_;
	GVariantType* _tmp20_;
	GVariantBuilder* _tmp21_;
	GVariantBuilder* _tmp22_;
	GMainLoop* _tmp36_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (connection != NULL, FALSE);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (loop);
	loop = _tmp0_;
	_tmp1_ = loop;
	_vala_assert (_tmp1_ != NULL, "loop != null");
	subscripion_id = g_dbus_connection_signal_subscribe (connection, NULL, "org.kde.kwin.VirtualKeyboard", "availableChanged", "/VirtualKeyboard", NULL, G_DBUS_SIGNAL_FLAGS_NONE, _kde_virtual_keyboard_avail_cb_gd_bus_signal_callback, NULL, NULL);
	_tmp2_ = g_strdup ("InputMethod");
	wayland_values = _tmp2_;
	_tmp3_ = g_variant_type_new ("ay");
	_tmp4_ = _tmp3_;
	_tmp5_ = g_variant_builder_new (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_variant_type_free0 (_tmp4_);
	bytes = _tmp6_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				const gchar* _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				GVariantBuilder* _tmp12_;
				const gchar* _tmp13_;
				if (!_tmp7_) {
					gint _tmp8_;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = wayland_values;
				_tmp10_ = strlen (_tmp9_);
				_tmp11_ = _tmp10_;
				if (!(i < _tmp11_)) {
					break;
				}
				_tmp12_ = bytes;
				_tmp13_ = wayland_values;
				g_variant_builder_add (_tmp12_, "y", string_get (_tmp13_, (glong) i), NULL);
			}
		}
	}
	_tmp14_ = g_variant_type_new ("aay");
	_tmp15_ = _tmp14_;
	_tmp16_ = g_variant_builder_new (_tmp15_);
	_tmp17_ = _tmp16_;
	_g_variant_type_free0 (_tmp15_);
	bytes2 = _tmp17_;
	_tmp18_ = bytes;
	g_variant_builder_add (bytes2, "ay", _tmp18_, NULL);
	_tmp19_ = g_variant_type_new ("a{saay}");
	_tmp20_ = _tmp19_;
	_tmp21_ = g_variant_builder_new (_tmp20_);
	_tmp22_ = _tmp21_;
	_g_variant_type_free0 (_tmp20_);
	array = _tmp22_;
	g_variant_builder_add (array, "{saay}", "Wayland", bytes2, NULL);
	{
		gboolean _tmp23_ = FALSE;
		GVariant* _tmp24_;
		GVariant* _tmp25_;
		gboolean _tmp26_;
		_tmp24_ = g_variant_new ("(a{saay})", array, NULL);
		g_variant_ref_sink (_tmp24_);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_dbus_connection_emit_signal (connection, NULL, "/kwinrc", "org.kde.kconfig.notify", "ConfigChanged", _tmp25_, &_inner_error0_);
		_g_variant_unref0 (_tmp25_);
		_tmp23_ = _tmp26_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (!_tmp23_) {
			GMainLoop* _tmp28_;
			if (verbose) {
				FILE* _tmp27_;
				_tmp27_ = stderr;
				fprintf (_tmp27_, "Failed to emit a KDE D-Bus signal.\n");
			}
			g_dbus_connection_signal_unsubscribe (connection, subscripion_id);
			_tmp28_ = loop;
			if (_tmp28_ != NULL) {
				GMainLoop* _tmp29_;
				_tmp29_ = loop;
				g_main_loop_quit (_tmp29_);
				_g_main_loop_unref0 (loop);
				loop = NULL;
			}
			result = FALSE;
			_g_variant_builder_unref0 (array);
			_g_variant_builder_unref0 (bytes2);
			_g_variant_builder_unref0 (bytes);
			_g_free0 (wayland_values);
			return result;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp30_;
		GError* _tmp31_;
		const gchar* _tmp32_;
		GMainLoop* _tmp33_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp30_ = stderr;
		_tmp31_ = e;
		_tmp32_ = _tmp31_->message;
		fprintf (_tmp30_, "%s\n", _tmp32_);
		g_dbus_connection_signal_unsubscribe (connection, subscripion_id);
		_tmp33_ = loop;
		if (_tmp33_ != NULL) {
			GMainLoop* _tmp34_;
			_tmp34_ = loop;
			g_main_loop_quit (_tmp34_);
			_g_main_loop_unref0 (loop);
			loop = NULL;
		}
		result = FALSE;
		_g_error_free0 (e);
		_g_variant_builder_unref0 (array);
		_g_variant_builder_unref0 (bytes2);
		_g_variant_builder_unref0 (bytes);
		_g_free0 (wayland_values);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp35_ = FALSE;
		_g_variant_builder_unref0 (array);
		_g_variant_builder_unref0 (bytes2);
		_g_variant_builder_unref0 (bytes);
		_g_free0 (wayland_values);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp35_;
	}
	_tmp36_ = loop;
	g_main_loop_run (_tmp36_);
	g_dbus_connection_signal_unsubscribe (connection, subscripion_id);
	result = TRUE;
	_g_variant_builder_unref0 (array);
	_g_variant_builder_unref0 (bytes2);
	_g_variant_builder_unref0 (bytes);
	_g_free0 (wayland_values);
	return result;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->connection);
		g_slice_free (Block2Data, _data2_);
	}
}

static gboolean
__lambda5_ (Block2Data* _data2_)
{
	gboolean result;
	_data2_->retval = operate_daemon_with_dbus_kde_real (_data2_->connection, _data2_->verbose);
	_data2_->id = (guint) 0;
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda5__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda5_ (self);
	return result;
}

gboolean
operate_daemon_with_dbus_kde (GDBusConnection* connection,
                              gboolean start,
                              gboolean verbose)
{
	Block2Data* _data2_;
	GDBusConnection* _tmp0_;
	GSource* source = NULL;
	GSource* _tmp1_;
	GSource* _tmp2_;
	GSource* _tmp3_;
	GSource* _tmp4_;
	gboolean result;
	g_return_val_if_fail (connection != NULL, FALSE);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (connection);
	_g_object_unref0 (_data2_->connection);
	_data2_->connection = _tmp0_;
	_data2_->verbose = verbose;
	if (start) {
		result = operate_daemon_with_dbus_kde_real (_data2_->connection, _data2_->verbose);
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return result;
	}
	_tmp1_ = g_timeout_source_new_seconds ((guint) 1);
	source = _tmp1_;
	_tmp2_ = source;
	g_source_attach (_tmp2_, NULL);
	_tmp3_ = source;
	_data2_->id = g_source_get_id (_tmp3_);
	_data2_->retval = FALSE;
	_tmp4_ = source;
	g_source_set_callback (_tmp4_, ___lambda5__gsource_func, block2_data_ref (_data2_), block2_data_unref);
	while (TRUE) {
		GMainContext* _tmp5_;
		if (!(_data2_->id > ((guint) 0))) {
			break;
		}
		_tmp5_ = g_main_context_default ();
		g_main_context_iteration (_tmp5_, TRUE);
	}
	result = _data2_->retval;
	_g_source_unref0 (source);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_engine_list_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (engine_list_unref (var), NULL));
}

static gpointer
_engine_list_ref0 (gpointer self)
{
	return self ? engine_list_ref (self) : NULL;
}

static void
_vala_array_add7 (IBusEngineDesc** * array,
                  gint* length,
                  gint* size,
                  IBusEngineDesc* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (IBusEngineDesc*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

gint
list_engine (gchar** argv,
             gint argv_length1)
{
	static const GOptionEntry options[2] = {{"name-only", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &name_only, N_ ("List engine name only"), NULL}, {NULL}};
	GOptionContext* option = NULL;
	GOptionContext* _tmp0_;
	GOptionContext* _tmp1_;
	IBusBus* bus = NULL;
	IBusBus* _tmp8_;
	IBusBus* _tmp9_;
	GList* engines = NULL;
	IBusBus* _tmp11_;
	GList* _tmp12_;
	GHashTable* map = NULL;
	GHashFunc _tmp17_;
	GEqualFunc _tmp18_;
	GHashTable* _tmp19_;
	GList* _tmp20_;
	GHashTable* _tmp39_;
	GList* _tmp40_;
	GError* _inner_error0_ = NULL;
	gint result;
	_tmp0_ = g_option_context_new (NULL);
	option = _tmp0_;
	_tmp1_ = option;
	g_option_context_add_main_entries (_tmp1_, options, GETTEXT_PACKAGE);
	{
		GOptionContext* _tmp2_;
		_tmp2_ = option;
		g_option_context_parse (_tmp2_, (gint*) (&argv_length1), &argv, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp3_ = -1;
			if (_inner_error0_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_g_option_context_free0 (option);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp3_;
		}
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = stderr;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		fprintf (_tmp4_, "%s\n", _tmp6_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (option);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp7_ = -1;
		_g_option_context_free0 (option);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp7_;
	}
	_tmp8_ = get_bus ();
	bus = _tmp8_;
	_tmp9_ = bus;
	if (_tmp9_ == NULL) {
		FILE* _tmp10_;
		_tmp10_ = stderr;
		fprintf (_tmp10_, "%s", _ ("Can't connect to IBus.\n"));
		result = EXIT_FAILURE;
		_g_object_unref0 (bus);
		_g_option_context_free0 (option);
		return result;
	}
	_tmp11_ = bus;
	_tmp12_ = ibus_bus_list_engines (_tmp11_);
	engines = _tmp12_;
	if (name_only) {
		GList* _tmp13_;
		_tmp13_ = engines;
		{
			GList* engine_collection = NULL;
			GList* engine_it = NULL;
			engine_collection = _tmp13_;
			for (engine_it = engine_collection; engine_it != NULL; engine_it = engine_it->next) {
				IBusEngineDesc* _tmp14_;
				IBusEngineDesc* engine = NULL;
				_tmp14_ = _g_object_ref0 ((IBusEngineDesc*) engine_it->data);
				engine = _tmp14_;
				{
					IBusEngineDesc* _tmp15_;
					const gchar* _tmp16_;
					_tmp15_ = engine;
					_tmp16_ = ibus_engine_desc_get_name (_tmp15_);
					g_print ("%s\n", _tmp16_);
					_g_object_unref0 (engine);
				}
			}
		}
		result = EXIT_SUCCESS;
		(engines == NULL) ? NULL : (engines = (_g_list_free__g_object_unref0_ (engines), NULL));
		_g_object_unref0 (bus);
		_g_option_context_free0 (option);
		return result;
	}
	_tmp17_ = g_str_hash;
	_tmp18_ = g_str_equal;
	_tmp19_ = g_hash_table_new_full (_tmp17_, _tmp18_, _g_free0_, _engine_list_unref0_);
	map = _tmp19_;
	_tmp20_ = engines;
	{
		GList* engine_collection = NULL;
		GList* engine_it = NULL;
		engine_collection = _tmp20_;
		for (engine_it = engine_collection; engine_it != NULL; engine_it = engine_it->next) {
			IBusEngineDesc* _tmp21_;
			IBusEngineDesc* engine = NULL;
			_tmp21_ = _g_object_ref0 ((IBusEngineDesc*) engine_it->data);
			engine = _tmp21_;
			{
				EngineList* list = NULL;
				GHashTable* _tmp22_;
				IBusEngineDesc* _tmp23_;
				const gchar* _tmp24_;
				gconstpointer _tmp25_;
				EngineList* _tmp26_;
				EngineList* _tmp27_;
				EngineList* _tmp35_;
				EngineList* _tmp36_;
				IBusEngineDesc* _tmp37_;
				IBusEngineDesc* _tmp38_;
				_tmp22_ = map;
				_tmp23_ = engine;
				_tmp24_ = ibus_engine_desc_get_language (_tmp23_);
				_tmp25_ = g_hash_table_lookup (_tmp22_, _tmp24_);
				_tmp26_ = _engine_list_ref0 ((EngineList*) _tmp25_);
				list = _tmp26_;
				_tmp27_ = list;
				if (_tmp27_ == NULL) {
					EngineList* _tmp28_;
					GHashTable* _tmp29_;
					IBusEngineDesc* _tmp30_;
					const gchar* _tmp31_;
					gchar* _tmp32_;
					EngineList* _tmp33_;
					EngineList* _tmp34_;
					_tmp28_ = engine_list_new ();
					_engine_list_unref0 (list);
					list = _tmp28_;
					_tmp29_ = map;
					_tmp30_ = engine;
					_tmp31_ = ibus_engine_desc_get_language (_tmp30_);
					_tmp32_ = g_strdup (_tmp31_);
					_tmp33_ = list;
					_tmp34_ = _engine_list_ref0 (_tmp33_);
					g_hash_table_insert (_tmp29_, _tmp32_, _tmp34_);
				}
				_tmp35_ = list;
				_tmp36_ = list;
				_tmp37_ = engine;
				_tmp38_ = _g_object_ref0 (_tmp37_);
				_vala_array_add7 (&_tmp35_->data, &_tmp35_->data_length1, &_tmp35_->_data_size_, _tmp38_);
				_engine_list_unref0 (list);
				_g_object_unref0 (engine);
			}
		}
	}
	_tmp39_ = map;
	_tmp40_ = g_hash_table_get_keys (_tmp39_);
	{
		GList* language_collection = NULL;
		GList* language_it = NULL;
		language_collection = _tmp40_;
		for (language_it = language_collection; language_it != NULL; language_it = language_it->next) {
			const gchar* language = NULL;
			language = (const gchar*) language_it->data;
			{
				EngineList* list = NULL;
				GHashTable* _tmp41_;
				const gchar* _tmp42_;
				gconstpointer _tmp43_;
				EngineList* _tmp44_;
				const gchar* _tmp45_;
				gchar* _tmp46_;
				gchar* _tmp47_;
				EngineList* _tmp48_;
				IBusEngineDesc** _tmp49_;
				gint _tmp49__length1;
				_tmp41_ = map;
				_tmp42_ = language;
				_tmp43_ = g_hash_table_lookup (_tmp41_, _tmp42_);
				_tmp44_ = _engine_list_ref0 ((EngineList*) _tmp43_);
				list = _tmp44_;
				_tmp45_ = language;
				_tmp46_ = ibus_get_language_name (_tmp45_);
				_tmp47_ = _tmp46_;
				g_print (_ ("language: %s\n"), _tmp47_);
				_g_free0 (_tmp47_);
				_tmp48_ = list;
				_tmp49_ = _tmp48_->data;
				_tmp49__length1 = _tmp48_->data_length1;
				{
					IBusEngineDesc** engine_collection = NULL;
					gint engine_collection_length1 = 0;
					gint _engine_collection_size_ = 0;
					gint engine_it = 0;
					engine_collection = _tmp49_;
					engine_collection_length1 = _tmp49__length1;
					for (engine_it = 0; engine_it < engine_collection_length1; engine_it = engine_it + 1) {
						IBusEngineDesc* _tmp50_;
						IBusEngineDesc* engine = NULL;
						_tmp50_ = _g_object_ref0 (engine_collection[engine_it]);
						engine = _tmp50_;
						{
							IBusEngineDesc* _tmp51_;
							const gchar* _tmp52_;
							IBusEngineDesc* _tmp53_;
							const gchar* _tmp54_;
							_tmp51_ = engine;
							_tmp52_ = ibus_engine_desc_get_name (_tmp51_);
							_tmp53_ = engine;
							_tmp54_ = ibus_engine_desc_get_longname (_tmp53_);
							g_print ("  %s - %s\n", _tmp52_, _tmp54_);
							_g_object_unref0 (engine);
						}
					}
				}
				_engine_list_unref0 (list);
			}
		}
		(language_collection == NULL) ? NULL : (language_collection = (g_list_free (language_collection), NULL));
	}
	result = EXIT_SUCCESS;
	_g_hash_table_unref0 (map);
	(engines == NULL) ? NULL : (engines = (_g_list_free__g_object_unref0_ (engines), NULL));
	_g_object_unref0 (bus);
	_g_option_context_free0 (option);
	return result;
}

static void
_vala_array_add8 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add9 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add10 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add11 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add12 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add13 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add14 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

gint
exec_setxkbmap (IBusEngineDesc* engine)
{
	gchar* layout = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* variant = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* option = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* standard_error = NULL;
	gint exit_status = 0;
	gchar** args = NULL;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gint args_length1;
	gint _args_size_;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp10_;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	const gchar* _tmp18_;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	const gchar* _tmp26_;
	gchar** _tmp33_;
	gint _tmp33__length1;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (engine != NULL, 0);
	_tmp0_ = ibus_engine_desc_get_layout (engine);
	_tmp1_ = g_strdup (_tmp0_);
	layout = _tmp1_;
	_tmp2_ = ibus_engine_desc_get_layout_variant (engine);
	_tmp3_ = g_strdup (_tmp2_);
	variant = _tmp3_;
	_tmp4_ = ibus_engine_desc_get_layout_option (engine);
	_tmp5_ = g_strdup (_tmp4_);
	option = _tmp5_;
	standard_error = NULL;
	exit_status = 0;
	_tmp6_ = g_strdup ("setxkbmap");
	_tmp7_ = g_new0 (gchar*, 1 + 1);
	_tmp7_[0] = _tmp6_;
	args = _tmp7_;
	args_length1 = 1;
	_args_size_ = args_length1;
	_tmp10_ = layout;
	if (_tmp10_ != NULL) {
		const gchar* _tmp11_;
		_tmp11_ = layout;
		_tmp9_ = g_strcmp0 (_tmp11_, "") != 0;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		const gchar* _tmp12_;
		_tmp12_ = layout;
		_tmp8_ = g_strcmp0 (_tmp12_, "default") != 0;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp13_ = g_strdup ("-layout");
		_vala_array_add8 (&args, &args_length1, &_args_size_, _tmp13_);
		_tmp14_ = layout;
		_tmp15_ = g_strdup (_tmp14_);
		_vala_array_add9 (&args, &args_length1, &_args_size_, _tmp15_);
	}
	_tmp18_ = variant;
	if (_tmp18_ != NULL) {
		const gchar* _tmp19_;
		_tmp19_ = variant;
		_tmp17_ = g_strcmp0 (_tmp19_, "") != 0;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		const gchar* _tmp20_;
		_tmp20_ = variant;
		_tmp16_ = g_strcmp0 (_tmp20_, "default") != 0;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		gchar* _tmp21_;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp21_ = g_strdup ("-variant");
		_vala_array_add10 (&args, &args_length1, &_args_size_, _tmp21_);
		_tmp22_ = variant;
		_tmp23_ = g_strdup (_tmp22_);
		_vala_array_add11 (&args, &args_length1, &_args_size_, _tmp23_);
	}
	_tmp26_ = option;
	if (_tmp26_ != NULL) {
		const gchar* _tmp27_;
		_tmp27_ = option;
		_tmp25_ = g_strcmp0 (_tmp27_, "") != 0;
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		const gchar* _tmp28_;
		_tmp28_ = option;
		_tmp24_ = g_strcmp0 (_tmp28_, "default") != 0;
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		gchar* _tmp29_;
		gchar* _tmp30_;
		const gchar* _tmp31_;
		gchar* _tmp32_;
		_tmp29_ = g_strdup ("-option");
		_vala_array_add12 (&args, &args_length1, &_args_size_, _tmp29_);
		_tmp30_ = g_strdup ("-option");
		_vala_array_add13 (&args, &args_length1, &_args_size_, _tmp30_);
		_tmp31_ = option;
		_tmp32_ = g_strdup (_tmp31_);
		_vala_array_add14 (&args, &args_length1, &_args_size_, _tmp32_);
	}
	_tmp33_ = args;
	_tmp33__length1 = args_length1;
	if (_tmp33__length1 == 1) {
		result = EXIT_FAILURE;
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (standard_error);
		_g_free0 (option);
		_g_free0 (variant);
		_g_free0 (layout);
		return result;
	}
	{
		gboolean _tmp34_ = FALSE;
		gchar** _tmp35_;
		gint _tmp35__length1;
		gchar* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		gboolean _tmp38_;
		_tmp35_ = args;
		_tmp35__length1 = args_length1;
		_tmp38_ = g_spawn_sync (NULL, _tmp35_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, &_tmp36_, &_tmp37_, &_inner_error0_);
		_g_free0 (standard_error);
		standard_error = _tmp36_;
		exit_status = _tmp37_;
		_tmp34_ = _tmp38_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp39_ = -1;
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (standard_error);
			_g_free0 (option);
			_g_free0 (variant);
			_g_free0 (layout);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp39_;
		}
		if (!_tmp34_) {
			const gchar* _tmp40_;
			_tmp40_ = ibus_engine_desc_get_layout (engine);
			g_warning ("main.vala:530: Switch xkb layout to %s failed.", _tmp40_);
			result = EXIT_FAILURE;
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (standard_error);
			_g_free0 (option);
			_g_free0 (variant);
			_g_free0 (layout);
			return result;
		}
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp41_;
		const gchar* _tmp42_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp41_ = e;
		_tmp42_ = _tmp41_->message;
		g_warning ("main.vala:535: Execute setxkbmap failed: %s", _tmp42_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (standard_error);
		_g_free0 (option);
		_g_free0 (variant);
		_g_free0 (layout);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp43_ = -1;
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (standard_error);
		_g_free0 (option);
		_g_free0 (variant);
		_g_free0 (layout);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp43_;
	}
	if (exit_status != 0) {
		const gchar* _tmp44_ = NULL;
		const gchar* _tmp45_;
		_tmp45_ = standard_error;
		_tmp44_ = _tmp45_;
		if (_tmp44_ == NULL) {
			_tmp44_ = "(null)";
		}
		g_warning ("main.vala:540: Execute setxkbmap failed: %s", _tmp44_);
		result = EXIT_FAILURE;
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (standard_error);
		_g_free0 (option);
		_g_free0 (variant);
		_g_free0 (layout);
		return result;
	}
	result = EXIT_SUCCESS;
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (standard_error);
	_g_free0 (option);
	_g_free0 (variant);
	_g_free0 (layout);
	return result;
}

gint
get_set_engine (gchar** argv,
                gint argv_length1)
{
	IBusBus* bus = NULL;
	IBusBus* _tmp0_;
	gchar* engine = NULL;
	const gchar* _tmp3_;
	IBusBus* _tmp10_;
	const gchar* _tmp11_;
	IBusEngineDesc* desc = NULL;
	IBusBus* _tmp13_;
	IBusEngineDesc* _tmp14_;
	IBusEngineDesc* _tmp15_;
	GSettings* settings = NULL;
	GSettings* _tmp17_;
	GSettings* _tmp18_;
	gint result;
	_tmp0_ = get_bus ();
	bus = _tmp0_;
	engine = NULL;
	if (argv_length1 > 1) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = argv[1];
		_tmp2_ = g_strdup (_tmp1_);
		_g_free0 (engine);
		engine = _tmp2_;
	}
	_tmp3_ = engine;
	if (_tmp3_ == NULL) {
		IBusEngineDesc* desc = NULL;
		IBusBus* _tmp4_;
		IBusEngineDesc* _tmp5_;
		IBusEngineDesc* _tmp6_;
		IBusEngineDesc* _tmp8_;
		const gchar* _tmp9_;
		_tmp4_ = bus;
		_tmp5_ = ibus_bus_get_global_engine (_tmp4_);
		desc = _tmp5_;
		_tmp6_ = desc;
		if (_tmp6_ == NULL) {
			FILE* _tmp7_;
			_tmp7_ = stderr;
			fprintf (_tmp7_, "%s", _ ("No engine is set.\n"));
			result = EXIT_FAILURE;
			_g_object_unref0 (desc);
			_g_free0 (engine);
			_g_object_unref0 (bus);
			return result;
		}
		_tmp8_ = desc;
		_tmp9_ = ibus_engine_desc_get_name (_tmp8_);
		g_print ("%s\n", _tmp9_);
		result = EXIT_SUCCESS;
		_g_object_unref0 (desc);
		_g_free0 (engine);
		_g_object_unref0 (bus);
		return result;
	}
	_tmp10_ = bus;
	_tmp11_ = engine;
	if (!ibus_bus_set_global_engine (_tmp10_, _tmp11_)) {
		FILE* _tmp12_;
		_tmp12_ = stderr;
		fprintf (_tmp12_, "%s", _ ("Set global engine failed.\n"));
		result = EXIT_FAILURE;
		_g_free0 (engine);
		_g_object_unref0 (bus);
		return result;
	}
	_tmp13_ = bus;
	_tmp14_ = ibus_bus_get_global_engine (_tmp13_);
	desc = _tmp14_;
	_tmp15_ = desc;
	if (_tmp15_ == NULL) {
		FILE* _tmp16_;
		_tmp16_ = stderr;
		fprintf (_tmp16_, "%s", _ ("Get global engine failed.\n"));
		result = EXIT_FAILURE;
		_g_object_unref0 (desc);
		_g_free0 (engine);
		_g_object_unref0 (bus);
		return result;
	}
	_tmp17_ = g_settings_new (IBUS_SCHEMAS_GENERAL);
	settings = _tmp17_;
	_tmp18_ = settings;
	if (!g_settings_get_boolean (_tmp18_, "use-system-keyboard-layout")) {
		IBusEngineDesc* _tmp19_;
		_tmp19_ = desc;
		result = exec_setxkbmap (_tmp19_);
		_g_object_unref0 (settings);
		_g_object_unref0 (desc);
		_g_free0 (engine);
		_g_object_unref0 (bus);
		return result;
	}
	result = EXIT_SUCCESS;
	_g_object_unref0 (settings);
	_g_object_unref0 (desc);
	_g_free0 (engine);
	_g_object_unref0 (bus);
	return result;
}

gint
message_watch (gchar** argv,
               gint argv_length1)
{
	gint result;
	result = EXIT_SUCCESS;
	return result;
}

gboolean
operate_daemon_in_kde_wayland (GDBusConnection* connection,
                               gboolean start,
                               gboolean verbose)
{
	const gchar* _tmp0_;
	gchar* kwinrc = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	KRcFile* key_file = NULL;
	KRcFile* _tmp4_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (connection != NULL, FALSE);
	if (!is_kde (verbose)) {
		result = FALSE;
		return result;
	}
	_tmp0_ = g_getenv ("WAYLAND_DISPLAY");
	if (_tmp0_ == NULL) {
		if (verbose) {
			FILE* _tmp1_;
			_tmp1_ = stderr;
			fprintf (_tmp1_, "Your KDE session is not Wayland\n.");
		}
		result = FALSE;
		return result;
	}
	_tmp2_ = g_get_user_config_dir ();
	_tmp3_ = g_build_filename (_tmp2_, "kwinrc", NULL);
	kwinrc = _tmp3_;
	_tmp4_ = krc_file_new ();
	key_file = _tmp4_;
	{
		KRcFile* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = key_file;
		_tmp6_ = kwinrc;
		krc_file_load_from_file (_tmp5_, _tmp6_, G_KEY_FILE_KEEP_COMMENTS, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp7_ = FALSE;
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_krc_file_unref0 (key_file);
			_g_free0 (kwinrc);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp7_;
		}
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* e = NULL;
		FILE* _tmp8_;
		const gchar* _tmp9_;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = stderr;
		_tmp9_ = kwinrc;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		fprintf (_tmp8_, "Error in %s: %s\n", _tmp9_, _tmp11_);
		result = FALSE;
		_g_error_free0 (e);
		_krc_file_unref0 (key_file);
		_g_free0 (kwinrc);
		return result;
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		FILE* _tmp12_;
		const gchar* _tmp13_;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = stderr;
		_tmp13_ = kwinrc;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		fprintf (_tmp12_, "Error in %s: %s\n", _tmp13_, _tmp15_);
		result = FALSE;
		_g_error_free0 (e);
		_krc_file_unref0 (key_file);
		_g_free0 (kwinrc);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp16_ = FALSE;
		_krc_file_unref0 (key_file);
		_g_free0 (kwinrc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp16_;
	}
	{
		gboolean is_updated = FALSE;
		is_updated = FALSE;
		if (start) {
			gchar* ibus_value = NULL;
			gchar* _tmp17_;
			gchar* value = NULL;
			gboolean _tmp18_ = FALSE;
			KRcFile* _tmp19_;
			const gchar* _tmp28_;
			const gchar* _tmp29_;
			_tmp17_ = g_build_filename (DATADIR, "applications", UI_WAYLAND_DESKTOP, NULL);
			ibus_value = _tmp17_;
			value = NULL;
			_tmp19_ = key_file;
			if (krc_file_has_group (_tmp19_, "Wayland")) {
				gboolean _tmp20_ = FALSE;
				KRcFile* _tmp21_;
				_tmp21_ = key_file;
				_tmp20_ = krc_file_has_key (_tmp21_, "Wayland", "InputMethod[$e]", &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gboolean _tmp22_ = FALSE;
					_g_free0 (value);
					_g_free0 (ibus_value);
					if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
						goto __catch1_g_key_file_error;
					}
					if (_inner_error0_->domain == G_FILE_ERROR) {
						goto __catch1_g_file_error;
					}
					_krc_file_unref0 (key_file);
					_g_free0 (kwinrc);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp22_;
				}
				_tmp18_ = _tmp20_;
			} else {
				_tmp18_ = FALSE;
			}
			if (_tmp18_) {
				gchar* _tmp23_ = NULL;
				KRcFile* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp27_;
				_tmp24_ = key_file;
				_tmp25_ = krc_file_get_value (_tmp24_, "Wayland", "InputMethod[$e]", &_inner_error0_);
				_tmp23_ = _tmp25_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gboolean _tmp26_ = FALSE;
					_g_free0 (value);
					_g_free0 (ibus_value);
					if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
						goto __catch1_g_key_file_error;
					}
					if (_inner_error0_->domain == G_FILE_ERROR) {
						goto __catch1_g_file_error;
					}
					_krc_file_unref0 (key_file);
					_g_free0 (kwinrc);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp26_;
				}
				_tmp27_ = _tmp23_;
				_tmp23_ = NULL;
				_g_free0 (value);
				value = _tmp27_;
				_g_free0 (_tmp23_);
			}
			_tmp28_ = value;
			_tmp29_ = ibus_value;
			if (g_strcmp0 (_tmp28_, _tmp29_) != 0) {
				KRcFile* _tmp30_;
				const gchar* _tmp31_;
				KRcFile* _tmp32_;
				const gchar* _tmp33_;
				_tmp30_ = key_file;
				_tmp31_ = ibus_value;
				krc_file_set_value (_tmp30_, "Wayland", "InputMethod[$e]", _tmp31_);
				_tmp32_ = key_file;
				_tmp33_ = kwinrc;
				krc_file_save_to_file (_tmp32_, _tmp33_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gboolean _tmp34_ = FALSE;
					_g_free0 (value);
					_g_free0 (ibus_value);
					if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
						goto __catch1_g_key_file_error;
					}
					if (_inner_error0_->domain == G_FILE_ERROR) {
						goto __catch1_g_file_error;
					}
					_krc_file_unref0 (key_file);
					_g_free0 (kwinrc);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp34_;
				}
				is_updated = TRUE;
			}
			_g_free0 (value);
			_g_free0 (ibus_value);
		} else {
			KRcFile* _tmp35_;
			_tmp35_ = key_file;
			if (krc_file_has_group (_tmp35_, "Wayland")) {
				gchar** keys = NULL;
				KRcFile* _tmp36_;
				gint _tmp37_ = 0;
				gchar** _tmp38_;
				gint keys_length1;
				gint _keys_size_;
				gboolean _tmp40_ = FALSE;
				KRcFile* _tmp41_;
				_tmp36_ = key_file;
				_tmp38_ = krc_file_get_keys (_tmp36_, "Wayland", &_tmp37_, &_inner_error0_);
				keys = _tmp38_;
				keys_length1 = _tmp37_;
				_keys_size_ = keys_length1;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gboolean _tmp39_ = FALSE;
					if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
						goto __catch1_g_key_file_error;
					}
					if (_inner_error0_->domain == G_FILE_ERROR) {
						goto __catch1_g_file_error;
					}
					_krc_file_unref0 (key_file);
					_g_free0 (kwinrc);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp39_;
				}
				_tmp41_ = key_file;
				_tmp40_ = krc_file_has_key (_tmp41_, "Wayland", "InputMethod[$e]", &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gboolean _tmp42_ = FALSE;
					keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
					if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
						goto __catch1_g_key_file_error;
					}
					if (_inner_error0_->domain == G_FILE_ERROR) {
						goto __catch1_g_file_error;
					}
					_krc_file_unref0 (key_file);
					_g_free0 (kwinrc);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp42_;
				}
				if (_tmp40_) {
					gchar** _tmp43_;
					gint _tmp43__length1;
					KRcFile* _tmp48_;
					const gchar* _tmp49_;
					_tmp43_ = keys;
					_tmp43__length1 = keys_length1;
					if (_tmp43__length1 == 1) {
						KRcFile* _tmp44_;
						_tmp44_ = key_file;
						krc_file_remove_group (_tmp44_, "Wayland", &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							gboolean _tmp45_ = FALSE;
							keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
							if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
								goto __catch1_g_key_file_error;
							}
							if (_inner_error0_->domain == G_FILE_ERROR) {
								goto __catch1_g_file_error;
							}
							_krc_file_unref0 (key_file);
							_g_free0 (kwinrc);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return _tmp45_;
						}
					} else {
						KRcFile* _tmp46_;
						_tmp46_ = key_file;
						krc_file_remove_key (_tmp46_, "Wayland", "InputMethod[$e]", &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							gboolean _tmp47_ = FALSE;
							keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
							if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
								goto __catch1_g_key_file_error;
							}
							if (_inner_error0_->domain == G_FILE_ERROR) {
								goto __catch1_g_file_error;
							}
							_krc_file_unref0 (key_file);
							_g_free0 (kwinrc);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return _tmp47_;
						}
					}
					_tmp48_ = key_file;
					_tmp49_ = kwinrc;
					krc_file_save_to_file (_tmp48_, _tmp49_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						gboolean _tmp50_ = FALSE;
						keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
						if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
							goto __catch1_g_key_file_error;
						}
						if (_inner_error0_->domain == G_FILE_ERROR) {
							goto __catch1_g_file_error;
						}
						_krc_file_unref0 (key_file);
						_g_free0 (kwinrc);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return _tmp50_;
					}
					is_updated = TRUE;
				}
				keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
			}
		}
		if (verbose) {
			if (is_updated) {
				const gchar* _tmp51_ = NULL;
				const gchar* _tmp52_ = NULL;
				FILE* _tmp53_;
				if (start) {
					_tmp51_ = "added";
				} else {
					_tmp51_ = "deleted";
				}
				if (start) {
					_tmp52_ = "start";
				} else {
					_tmp52_ = "exit";
				}
				_tmp53_ = stderr;
				fprintf (_tmp53_, "\"InputMethod\" was %s in kwinrc for %s.\n", _tmp51_, _tmp52_);
			} else {
				if (start) {
					FILE* _tmp54_;
					_tmp54_ = stderr;
					fprintf (_tmp54_, "%s", "kwinrc is not updated for start. \"ibus exit\" " "command may be needed in case kwin_wayland " "restarted.\n");
				} else {
					FILE* _tmp55_;
					_tmp55_ = stderr;
					fprintf (_tmp55_, "kwinrc is not updated for exit.\n");
					result = TRUE;
					_krc_file_unref0 (key_file);
					_g_free0 (kwinrc);
					return result;
				}
			}
		}
	}
	goto __finally1;
	__catch1_g_key_file_error:
	{
		GError* e = NULL;
		FILE* _tmp56_;
		GError* _tmp57_;
		const gchar* _tmp58_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp56_ = stderr;
		_tmp57_ = e;
		_tmp58_ = _tmp57_->message;
		fprintf (_tmp56_, "%s\n", _tmp58_);
		result = FALSE;
		_g_error_free0 (e);
		_krc_file_unref0 (key_file);
		_g_free0 (kwinrc);
		return result;
	}
	goto __finally1;
	__catch1_g_file_error:
	{
		GError* e = NULL;
		FILE* _tmp59_;
		GError* _tmp60_;
		const gchar* _tmp61_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp59_ = stderr;
		_tmp60_ = e;
		_tmp61_ = _tmp60_->message;
		fprintf (_tmp59_, "%s\n", _tmp61_);
		result = FALSE;
		_g_error_free0 (e);
		_krc_file_unref0 (key_file);
		_g_free0 (kwinrc);
		return result;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp62_ = FALSE;
		_krc_file_unref0 (key_file);
		_g_free0 (kwinrc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp62_;
	}
	if (!operate_daemon_with_dbus_kde (connection, start, verbose)) {
		result = FALSE;
		_krc_file_unref0 (key_file);
		_g_free0 (kwinrc);
		return result;
	}
	if (verbose) {
		const gchar* _tmp63_ = NULL;
		FILE* _tmp64_;
		if (start) {
			_tmp63_ = "start";
		} else {
			_tmp63_ = "exit";
		}
		_tmp64_ = stderr;
		fprintf (_tmp64_, "Succeed to %s ibus-daemon with a " "KDE Wayland method.\n", _tmp63_);
	}
	result = TRUE;
	_krc_file_unref0 (key_file);
	_g_free0 (kwinrc);
	return result;
}

gboolean
start_daemon_with_systemd (gboolean restart,
                           gboolean verbose)
{
	GDBusConnection* connection = NULL;
	GDBusConnection* _tmp0_;
	GDBusConnection* _tmp1_;
	gchar* object_path = NULL;
	GDBusConnection* _tmp7_;
	GDBusConnection* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	GDBusConnection* _tmp11_;
	const gchar* _tmp12_;
	gboolean result;
	_tmp0_ = get_session_bus (verbose);
	connection = _tmp0_;
	_tmp1_ = connection;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_g_object_unref0 (connection);
		return result;
	}
	object_path = NULL;
	if (restart) {
		GDBusConnection* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		GDBusConnection* _tmp5_;
		const gchar* _tmp6_;
		_tmp2_ = connection;
		_tmp3_ = get_ibus_systemd_object_path (_tmp2_, verbose);
		_g_free0 (object_path);
		object_path = _tmp3_;
		_tmp4_ = object_path;
		if (_tmp4_ == NULL) {
			result = FALSE;
			_g_free0 (object_path);
			_g_object_unref0 (connection);
			return result;
		}
		_tmp5_ = connection;
		_tmp6_ = object_path;
		if (!is_running_daemon_via_systemd (_tmp5_, _tmp6_, verbose)) {
			result = FALSE;
			_g_free0 (object_path);
			_g_object_unref0 (connection);
			return result;
		}
	}
	_tmp7_ = connection;
	if (!start_daemon_with_dbus_systemd (_tmp7_, restart, verbose)) {
		result = FALSE;
		_g_free0 (object_path);
		_g_object_unref0 (connection);
		return result;
	}
	if (restart) {
		result = TRUE;
		_g_free0 (object_path);
		_g_object_unref0 (connection);
		return result;
	}
	_tmp8_ = connection;
	_tmp9_ = get_ibus_systemd_object_path (_tmp8_, verbose);
	_g_free0 (object_path);
	object_path = _tmp9_;
	_tmp10_ = object_path;
	if (_tmp10_ == NULL) {
		result = FALSE;
		_g_free0 (object_path);
		_g_object_unref0 (connection);
		return result;
	}
	_tmp11_ = connection;
	_tmp12_ = object_path;
	if (!is_running_daemon_via_systemd (_tmp11_, _tmp12_, verbose)) {
		result = FALSE;
		_g_free0 (object_path);
		_g_object_unref0 (connection);
		return result;
	}
	result = TRUE;
	_g_free0 (object_path);
	_g_object_unref0 (connection);
	return result;
}

gint
start_daemon_real (gchar** argv,
                   gint argv_length1,
                   gboolean restart)
{
	static const GOptionEntry options[4] = {{"type", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &daemon_type, N_ ("Start or restart daemon with \"direct\", \"systemd\", " "\"kde-wayland\" or \"wayland\" TYPE."), "TYPE"}, {"service-file", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &systemd_service_file, N_ ("Start or restart daemon with SYSTEMD_SERVICE file."), "SYSTEMD_SERVICE"}, {"verbose", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &verbose, N_ ("Show debug messages."), NULL}, {NULL}};
	GOptionContext* option = NULL;
	GOptionContext* _tmp0_;
	GOptionContext* _tmp1_;
	GOptionContext* _tmp2_;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	const gchar* _tmp13_;
	const gchar* _tmp19_;
	gboolean _tmp21_ = FALSE;
	const gchar* _tmp22_;
	gboolean _tmp24_ = FALSE;
	const gchar* _tmp25_;
	gboolean _tmp32_ = FALSE;
	const gchar* _tmp33_;
	gboolean _tmp35_ = FALSE;
	const gchar* _tmp36_;
	IBusBus* bus = NULL;
	IBusBus* _tmp38_;
	GError* _inner_error0_ = NULL;
	gint result;
	_tmp0_ = g_option_context_new (NULL);
	option = _tmp0_;
	_tmp1_ = option;
	g_option_context_add_main_entries (_tmp1_, options, GETTEXT_PACKAGE);
	_tmp2_ = option;
	g_option_context_set_ignore_unknown_options (_tmp2_, TRUE);
	{
		GOptionContext* _tmp3_;
		_tmp3_ = option;
		g_option_context_parse (_tmp3_, (gint*) (&argv_length1), &argv, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp4_ = -1;
			if (_inner_error0_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_g_option_context_free0 (option);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = stderr;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		fprintf (_tmp5_, "%s\n", _tmp7_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (option);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp8_ = -1;
		_g_option_context_free0 (option);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp8_;
	}
	_tmp13_ = daemon_type;
	if (_tmp13_ != NULL) {
		const gchar* _tmp14_;
		_tmp14_ = daemon_type;
		_tmp12_ = g_strcmp0 (_tmp14_, "direct") != 0;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		const gchar* _tmp15_;
		_tmp15_ = daemon_type;
		_tmp11_ = g_strcmp0 (_tmp15_, "systemd") != 0;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		const gchar* _tmp16_;
		_tmp16_ = daemon_type;
		_tmp10_ = g_strcmp0 (_tmp16_, "kde-wayland") != 0;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		const gchar* _tmp17_;
		_tmp17_ = daemon_type;
		_tmp9_ = g_strcmp0 (_tmp17_, "wayland") != 0;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		FILE* _tmp18_;
		_tmp18_ = stderr;
		fprintf (_tmp18_, "%s", "type argument must be \"direct\" or \"systemd\" " "or \"kde-wayland\" or \"wayland\"\n");
		result = EXIT_FAILURE;
		_g_option_context_free0 (option);
		return result;
	}
	_tmp19_ = systemd_service_file;
	if (_tmp19_ == NULL) {
		gchar* _tmp20_;
		_tmp20_ = g_strdup (SYSTEMD_SESSION_GNOME_FILE);
		_g_free0 (systemd_service_file);
		systemd_service_file = _tmp20_;
	}
	_tmp22_ = daemon_type;
	if (_tmp22_ == NULL) {
		_tmp21_ = TRUE;
	} else {
		const gchar* _tmp23_;
		_tmp23_ = daemon_type;
		_tmp21_ = g_strcmp0 (_tmp23_, "wayland") == 0;
	}
	if (_tmp21_) {
		if (start_daemon_in_wayland (restart, argv, (gint) argv_length1)) {
			result = EXIT_SUCCESS;
			_g_option_context_free0 (option);
			return result;
		}
	}
	_tmp25_ = daemon_type;
	if (_tmp25_ == NULL) {
		_tmp24_ = TRUE;
	} else {
		const gchar* _tmp26_;
		_tmp26_ = daemon_type;
		_tmp24_ = g_strcmp0 (_tmp26_, "kde-wayland") == 0;
	}
	if (_tmp24_) {
		{
			gboolean _tmp27_ = FALSE;
			_tmp27_ = TRUE;
			while (TRUE) {
				GDBusConnection* connection = NULL;
				GDBusConnection* _tmp28_;
				GDBusConnection* _tmp29_;
				GDBusConnection* _tmp31_;
				if (!_tmp27_) {
					if (!FALSE) {
						break;
					}
				}
				_tmp27_ = FALSE;
				_tmp28_ = get_session_bus (verbose);
				connection = _tmp28_;
				_tmp29_ = connection;
				if (_tmp29_ == NULL) {
					_g_object_unref0 (connection);
					break;
				}
				if (restart) {
					GDBusConnection* _tmp30_;
					_tmp30_ = connection;
					if (operate_daemon_in_kde_wayland (_tmp30_, FALSE, verbose)) {
						sleep ((guint) 3);
					} else {
						_g_object_unref0 (connection);
						break;
					}
				}
				_tmp31_ = connection;
				if (operate_daemon_in_kde_wayland (_tmp31_, TRUE, verbose)) {
					result = EXIT_SUCCESS;
					_g_object_unref0 (connection);
					_g_option_context_free0 (option);
					return result;
				}
				_g_object_unref0 (connection);
			}
		}
	}
	_tmp33_ = daemon_type;
	if (_tmp33_ == NULL) {
		_tmp32_ = TRUE;
	} else {
		const gchar* _tmp34_;
		_tmp34_ = daemon_type;
		_tmp32_ = g_strcmp0 (_tmp34_, "systemd") == 0;
	}
	if (_tmp32_) {
		if (start_daemon_with_systemd (restart, verbose)) {
			result = EXIT_SUCCESS;
			_g_option_context_free0 (option);
			return result;
		}
	}
	_tmp36_ = daemon_type;
	if (g_strcmp0 (_tmp36_, "systemd") == 0) {
		_tmp35_ = TRUE;
	} else {
		const gchar* _tmp37_;
		_tmp37_ = daemon_type;
		_tmp35_ = g_strcmp0 (_tmp37_, "kde-wayland") == 0;
	}
	if (_tmp35_) {
		result = EXIT_FAILURE;
		_g_option_context_free0 (option);
		return result;
	}
	_tmp38_ = get_bus ();
	bus = _tmp38_;
	if (restart) {
		IBusBus* _tmp39_;
		IBusBus* _tmp41_;
		_tmp39_ = bus;
		if (_tmp39_ == NULL) {
			FILE* _tmp40_;
			_tmp40_ = stderr;
			fprintf (_tmp40_, "%s", _ ("Can't connect to IBus.\n"));
			result = EXIT_FAILURE;
			_g_object_unref0 (bus);
			_g_option_context_free0 (option);
			return result;
		}
		_tmp41_ = bus;
		ibus_bus_exit (_tmp41_, TRUE);
		if (verbose) {
			FILE* _tmp42_;
			_tmp42_ = stderr;
			fprintf (_tmp42_, "%s", "Succeed to restart ibus-daemon with an IBus API " "directly.\n");
		}
	} else {
		IBusBus* _tmp43_;
		_tmp43_ = bus;
		if (_tmp43_ != NULL) {
			FILE* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			_tmp44_ = stderr;
			_tmp45_ = g_strdup_printf ("%s\n", _ ("IBus is running."));
			_tmp46_ = _tmp45_;
			fprintf (_tmp44_, "%s", _tmp46_);
			_g_free0 (_tmp46_);
			result = EXIT_FAILURE;
			_g_object_unref0 (bus);
			_g_option_context_free0 (option);
			return result;
		} else {
			gchar* startarg = NULL;
			gchar* _tmp47_;
			const gchar* _tmp48_;
			gchar* _tmp49_;
			gchar** paths = NULL;
			const gchar* _tmp50_;
			gchar** _tmp51_;
			gchar** _tmp52_;
			gint paths_length1;
			gint _paths_size_;
			gchar** _tmp53_;
			gint _tmp53__length1;
			const gchar* _tmp62_;
			_tmp47_ = g_strdup ("ibus-daemon");
			startarg = _tmp47_;
			_tmp48_ = startarg;
			_tmp49_ = g_strdup (_tmp48_);
			_g_free0 (argv[0]);
			argv[0] = _tmp49_;
			_tmp50_ = g_getenv ("PATH");
			_tmp52_ = _tmp51_ = g_strsplit (_tmp50_, ":", 0);
			paths = _tmp52_;
			paths_length1 = _vala_array_length (_tmp51_);
			_paths_size_ = paths_length1;
			_tmp53_ = paths;
			_tmp53__length1 = paths_length1;
			{
				gchar** path_collection = NULL;
				gint path_collection_length1 = 0;
				gint _path_collection_size_ = 0;
				gint path_it = 0;
				path_collection = _tmp53_;
				path_collection_length1 = _tmp53__length1;
				for (path_it = 0; path_it < path_collection_length1; path_it = path_it + 1) {
					const gchar* path = NULL;
					path = path_collection[path_it];
					{
						gchar* full_path = NULL;
						const gchar* _tmp54_;
						const gchar* _tmp55_;
						gchar* _tmp56_;
						const gchar* _tmp57_;
						_tmp54_ = path;
						_tmp55_ = startarg;
						_tmp56_ = g_strdup_printf ("%s/%s", _tmp54_, _tmp55_);
						full_path = _tmp56_;
						_tmp57_ = full_path;
						if (g_file_test (_tmp57_, G_FILE_TEST_IS_EXECUTABLE)) {
							const gchar* _tmp58_;
							gchar* _tmp59_;
							_tmp58_ = full_path;
							_tmp59_ = g_strdup (_tmp58_);
							_g_free0 (startarg);
							startarg = _tmp59_;
							_g_free0 (full_path);
							break;
						}
						_g_free0 (full_path);
					}
				}
			}
			if (verbose) {
				FILE* _tmp60_;
				const gchar* _tmp61_;
				_tmp60_ = stderr;
				_tmp61_ = startarg;
				fprintf (_tmp60_, "Running \"%s\" directly as a foreground " "process.\n", _tmp61_);
			}
			_tmp62_ = startarg;
			execv (_tmp62_, argv);
			paths = (_vala_array_free (paths, paths_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (startarg);
		}
	}
	result = EXIT_SUCCESS;
	_g_object_unref0 (bus);
	_g_option_context_free0 (option);
	return result;
}

gint
restart_daemon (gchar** argv,
                gint argv_length1)
{
	gint result;
	result = start_daemon_real (argv, (gint) argv_length1, TRUE);
	return result;
}

gint
start_daemon (gchar** argv,
              gint argv_length1)
{
	gint result;
	result = start_daemon_real (argv, (gint) argv_length1, FALSE);
	return result;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->bus);
		g_slice_free (Block3Data, _data3_);
	}
}

static gboolean
__lambda6_ (Block3Data* _data3_)
{
	gboolean result;
	ibus_bus_exit (_data3_->bus, FALSE);
	_data3_->id = (guint) 0;
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda6__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda6_ (self);
	return result;
}

gboolean
exit_daemon_with_systemd (IBusBus* bus,
                          gboolean verbose)
{
	Block3Data* _data3_;
	IBusBus* _tmp0_;
	const gchar* _tmp1_;
	GDBusConnection* connection = NULL;
	GDBusConnection* _tmp3_;
	GDBusConnection* _tmp4_;
	gchar* object_path = NULL;
	GDBusConnection* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	GDBusConnection* _tmp8_;
	const gchar* _tmp9_;
	GSource* source = NULL;
	GSource* _tmp10_;
	GSource* _tmp11_;
	GSource* _tmp12_;
	GSource* _tmp13_;
	gboolean result;
	g_return_val_if_fail (bus != NULL, FALSE);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (bus);
	_g_object_unref0 (_data3_->bus);
	_data3_->bus = _tmp0_;
	_tmp1_ = systemd_service_file;
	if (_tmp1_ == NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (SYSTEMD_SESSION_GNOME_FILE);
		_g_free0 (systemd_service_file);
		systemd_service_file = _tmp2_;
	}
	_tmp3_ = get_session_bus (verbose);
	connection = _tmp3_;
	_tmp4_ = connection;
	if (_tmp4_ == NULL) {
		result = FALSE;
		_g_object_unref0 (connection);
		block3_data_unref (_data3_);
		_data3_ = NULL;
		return result;
	}
	_tmp5_ = connection;
	_tmp6_ = get_ibus_systemd_object_path (_tmp5_, verbose);
	object_path = _tmp6_;
	_tmp7_ = object_path;
	if (_tmp7_ == NULL) {
		result = FALSE;
		_g_free0 (object_path);
		_g_object_unref0 (connection);
		block3_data_unref (_data3_);
		_data3_ = NULL;
		return result;
	}
	_tmp8_ = connection;
	_tmp9_ = object_path;
	if (!is_running_daemon_via_systemd (_tmp8_, _tmp9_, verbose)) {
		result = FALSE;
		_g_free0 (object_path);
		_g_object_unref0 (connection);
		block3_data_unref (_data3_);
		_data3_ = NULL;
		return result;
	}
	_tmp10_ = g_timeout_source_new_seconds ((guint) 1);
	source = _tmp10_;
	_tmp11_ = source;
	g_source_attach (_tmp11_, NULL);
	_tmp12_ = source;
	_data3_->id = g_source_get_id (_tmp12_);
	_tmp13_ = source;
	g_source_set_callback (_tmp13_, ___lambda6__gsource_func, block3_data_ref (_data3_), block3_data_unref);
	while (TRUE) {
		GMainContext* _tmp14_;
		if (!(_data3_->id > ((guint) 0))) {
			break;
		}
		_tmp14_ = g_main_context_default ();
		g_main_context_iteration (_tmp14_, TRUE);
	}
	result = TRUE;
	_g_source_unref0 (source);
	_g_free0 (object_path);
	_g_object_unref0 (connection);
	block3_data_unref (_data3_);
	_data3_ = NULL;
	return result;
}

gint
exit_daemon (gchar** argv,
             gint argv_length1)
{
	static const GOptionEntry options[3] = {{"type", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &daemon_type, N_ ("Exit daemon with \"direct\" or \"kde-wayland\" " "TYPE."), "TYPE"}, {"verbose", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &verbose, N_ ("Show debug messages."), NULL}, {NULL}};
	GOptionContext* option = NULL;
	GOptionContext* _tmp0_;
	GOptionContext* _tmp1_;
	GOptionContext* _tmp2_;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	const gchar* _tmp11_;
	gboolean _tmp15_ = FALSE;
	const gchar* _tmp16_;
	const gchar* _tmp22_;
	IBusBus* bus = NULL;
	IBusBus* _tmp23_;
	IBusBus* _tmp24_;
	IBusBus* _tmp26_;
	const gchar* _tmp27_;
	IBusBus* _tmp28_;
	GError* _inner_error0_ = NULL;
	gint result;
	_tmp0_ = g_option_context_new (NULL);
	option = _tmp0_;
	_tmp1_ = option;
	g_option_context_add_main_entries (_tmp1_, options, GETTEXT_PACKAGE);
	_tmp2_ = option;
	g_option_context_set_ignore_unknown_options (_tmp2_, TRUE);
	{
		GOptionContext* _tmp3_;
		_tmp3_ = option;
		g_option_context_parse (_tmp3_, (gint*) (&argv_length1), &argv, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp4_ = -1;
			if (_inner_error0_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_g_option_context_free0 (option);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = stderr;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		fprintf (_tmp5_, "%s\n", _tmp7_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (option);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp8_ = -1;
		_g_option_context_free0 (option);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp8_;
	}
	_tmp11_ = daemon_type;
	if (_tmp11_ != NULL) {
		const gchar* _tmp12_;
		_tmp12_ = daemon_type;
		_tmp10_ = g_strcmp0 (_tmp12_, "direct") != 0;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		const gchar* _tmp13_;
		_tmp13_ = daemon_type;
		_tmp9_ = g_strcmp0 (_tmp13_, "kde-wayland") != 0;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		FILE* _tmp14_;
		_tmp14_ = stderr;
		fprintf (_tmp14_, "type argument must be \"direct\" or \"kde-wayland\"\n");
		result = EXIT_FAILURE;
		_g_option_context_free0 (option);
		return result;
	}
	_tmp16_ = daemon_type;
	if (_tmp16_ == NULL) {
		_tmp15_ = TRUE;
	} else {
		const gchar* _tmp17_;
		_tmp17_ = daemon_type;
		_tmp15_ = g_strcmp0 (_tmp17_, "kde-wayland") == 0;
	}
	if (_tmp15_) {
		GDBusConnection* connection = NULL;
		GDBusConnection* _tmp18_;
		gboolean _tmp19_ = FALSE;
		GDBusConnection* _tmp20_;
		_tmp18_ = get_session_bus (verbose);
		connection = _tmp18_;
		_tmp20_ = connection;
		if (_tmp20_ != NULL) {
			GDBusConnection* _tmp21_;
			_tmp21_ = connection;
			_tmp19_ = operate_daemon_in_kde_wayland (_tmp21_, FALSE, verbose);
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			result = EXIT_SUCCESS;
			_g_object_unref0 (connection);
			_g_option_context_free0 (option);
			return result;
		}
		_g_object_unref0 (connection);
	}
	_tmp22_ = daemon_type;
	if (g_strcmp0 (_tmp22_, "kde-wayland") == 0) {
		result = EXIT_FAILURE;
		_g_option_context_free0 (option);
		return result;
	}
	_tmp23_ = get_bus ();
	bus = _tmp23_;
	_tmp24_ = bus;
	if (_tmp24_ == NULL) {
		FILE* _tmp25_;
		_tmp25_ = stderr;
		fprintf (_tmp25_, "%s", _ ("Can't connect to IBus.\n"));
		result = EXIT_FAILURE;
		_g_object_unref0 (bus);
		_g_option_context_free0 (option);
		return result;
	}
	_tmp26_ = bus;
	if (exit_daemon_with_systemd (_tmp26_, verbose)) {
		result = EXIT_SUCCESS;
		_g_object_unref0 (bus);
		_g_option_context_free0 (option);
		return result;
	}
	_tmp27_ = daemon_type;
	if (g_strcmp0 (_tmp27_, "systemd") == 0) {
		result = EXIT_FAILURE;
		_g_object_unref0 (bus);
		_g_option_context_free0 (option);
		return result;
	}
	_tmp28_ = bus;
	ibus_bus_exit (_tmp28_, FALSE);
	result = EXIT_SUCCESS;
	_g_object_unref0 (bus);
	_g_option_context_free0 (option);
	return result;
}

gint
print_version (gchar** argv,
               gint argv_length1)
{
	gint result;
	g_print ("IBus %s\n", PACKAGE_VERSION);
	result = EXIT_SUCCESS;
	return result;
}

gint
read_cache (gchar** argv,
            gint argv_length1)
{
	static const GOptionEntry options[3] = {{"system", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &is_system, N_ ("Read the system registry cache."), NULL}, {"file", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &cache_file, N_ ("Read the registry cache FILE."), "FILE"}, {NULL}};
	GOptionContext* option = NULL;
	GOptionContext* _tmp0_;
	GOptionContext* _tmp1_;
	IBusRegistry* registry = NULL;
	IBusRegistry* _tmp8_;
	const gchar* _tmp9_;
	GString* output = NULL;
	GString* _tmp15_;
	IBusRegistry* _tmp16_;
	GString* _tmp17_;
	GString* _tmp18_;
	const gchar* _tmp19_;
	GError* _inner_error0_ = NULL;
	gint result;
	_tmp0_ = g_option_context_new (NULL);
	option = _tmp0_;
	_tmp1_ = option;
	g_option_context_add_main_entries (_tmp1_, options, GETTEXT_PACKAGE);
	{
		GOptionContext* _tmp2_;
		_tmp2_ = option;
		g_option_context_parse (_tmp2_, (gint*) (&argv_length1), &argv, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp3_ = -1;
			if (_inner_error0_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_g_option_context_free0 (option);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp3_;
		}
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = stderr;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		fprintf (_tmp4_, "%s\n", _tmp6_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (option);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp7_ = -1;
		_g_option_context_free0 (option);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp7_;
	}
	_tmp8_ = ibus_registry_new ();
	g_object_ref_sink (_tmp8_);
	registry = _tmp8_;
	_tmp9_ = cache_file;
	if (_tmp9_ != NULL) {
		IBusRegistry* _tmp10_;
		const gchar* _tmp11_;
		_tmp10_ = registry;
		_tmp11_ = cache_file;
		if (!ibus_registry_load_cache_file (_tmp10_, _tmp11_)) {
			FILE* _tmp12_;
			_tmp12_ = stderr;
			fprintf (_tmp12_, "%s", _ ("The registry cache is invalid.\n"));
			result = EXIT_FAILURE;
			_g_object_unref0 (registry);
			_g_option_context_free0 (option);
			return result;
		}
	} else {
		IBusRegistry* _tmp13_;
		_tmp13_ = registry;
		if (!ibus_registry_load_cache (_tmp13_, !is_system)) {
			FILE* _tmp14_;
			_tmp14_ = stderr;
			fprintf (_tmp14_, "%s", _ ("The registry cache is invalid.\n"));
			result = EXIT_FAILURE;
			_g_object_unref0 (registry);
			_g_option_context_free0 (option);
			return result;
		}
	}
	_tmp15_ = g_string_new ("");
	output = _tmp15_;
	_tmp16_ = registry;
	_tmp17_ = output;
	ibus_registry_output (_tmp16_, _tmp17_, 1);
	_tmp18_ = output;
	_tmp19_ = _tmp18_->str;
	g_print ("%s\n", _tmp19_);
	result = EXIT_SUCCESS;
	_g_string_free0 (output);
	_g_object_unref0 (registry);
	_g_option_context_free0 (option);
	return result;
}

gint
write_cache (gchar** argv,
             gint argv_length1)
{
	static const GOptionEntry options[3] = {{"system", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &is_system, N_ ("Write the system registry cache."), NULL}, {"file", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &cache_file, N_ ("Write the registry cache FILE."), "FILE"}, {NULL}};
	GOptionContext* option = NULL;
	GOptionContext* _tmp0_;
	GOptionContext* _tmp1_;
	IBusRegistry* registry = NULL;
	IBusRegistry* _tmp8_;
	IBusRegistry* _tmp9_;
	const gchar* _tmp10_;
	gint _tmp14_ = 0;
	IBusRegistry* _tmp15_;
	GError* _inner_error0_ = NULL;
	gint result;
	_tmp0_ = g_option_context_new (NULL);
	option = _tmp0_;
	_tmp1_ = option;
	g_option_context_add_main_entries (_tmp1_, options, GETTEXT_PACKAGE);
	{
		GOptionContext* _tmp2_;
		_tmp2_ = option;
		g_option_context_parse (_tmp2_, (gint*) (&argv_length1), &argv, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp3_ = -1;
			if (_inner_error0_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_g_option_context_free0 (option);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp3_;
		}
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = stderr;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		fprintf (_tmp4_, "%s\n", _tmp6_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (option);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp7_ = -1;
		_g_option_context_free0 (option);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp7_;
	}
	_tmp8_ = ibus_registry_new ();
	g_object_ref_sink (_tmp8_);
	registry = _tmp8_;
	_tmp9_ = registry;
	ibus_registry_load (_tmp9_);
	_tmp10_ = cache_file;
	if (_tmp10_ != NULL) {
		gint _tmp11_ = 0;
		IBusRegistry* _tmp12_;
		const gchar* _tmp13_;
		_tmp12_ = registry;
		_tmp13_ = cache_file;
		if (ibus_registry_save_cache_file (_tmp12_, _tmp13_)) {
			_tmp11_ = EXIT_SUCCESS;
		} else {
			_tmp11_ = EXIT_FAILURE;
		}
		result = _tmp11_;
		_g_object_unref0 (registry);
		_g_option_context_free0 (option);
		return result;
	}
	_tmp15_ = registry;
	if (ibus_registry_save_cache (_tmp15_, !is_system)) {
		_tmp14_ = EXIT_SUCCESS;
	} else {
		_tmp14_ = EXIT_FAILURE;
	}
	result = _tmp14_;
	_g_object_unref0 (registry);
	_g_option_context_free0 (option);
	return result;
}

gint
print_address (gchar** argv,
               gint argv_length1)
{
	gchar* address = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_;
	gint result;
	_tmp0_ = ibus_get_address ();
	_tmp1_ = g_strdup (_tmp0_);
	address = _tmp1_;
	_tmp3_ = address;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = address;
		_tmp2_ = _tmp4_;
	} else {
		_tmp2_ = "(null)";
	}
	g_print ("%s\n", _tmp2_);
	result = EXIT_SUCCESS;
	_g_free0 (address);
	return result;
}

gint
read_config_options (gchar** argv,
                     gint argv_length1)
{
	static const GOptionEntry options[2] = {{"engine-id", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &engine_id, N_ ("Use engine schema paths instead of ibus core, " "which can be comma-separated values."), "ENGINE_ID"}, {NULL}};
	GOptionContext* option = NULL;
	GOptionContext* _tmp0_;
	GOptionContext* _tmp1_;
	GError* _inner_error0_ = NULL;
	gint result;
	_tmp0_ = g_option_context_new (NULL);
	option = _tmp0_;
	_tmp1_ = option;
	g_option_context_add_main_entries (_tmp1_, options, GETTEXT_PACKAGE);
	{
		GOptionContext* _tmp2_;
		_tmp2_ = option;
		g_option_context_parse (_tmp2_, (gint*) (&argv_length1), &argv, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp3_ = -1;
			if (_inner_error0_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_g_option_context_free0 (option);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp3_;
		}
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = stderr;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		fprintf (_tmp4_, "%s\n", _tmp6_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (option);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp7_ = -1;
		_g_option_context_free0 (option);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp7_;
	}
	result = EXIT_SUCCESS;
	_g_option_context_free0 (option);
	return result;
}

static gpointer
_g_settings_schema_source_ref0 (gpointer self)
{
	return self ? g_settings_schema_source_ref (self) : NULL;
}

GSList*
get_ibus_schemas (void)
{
	gchar** ids = NULL;
	gchar** _tmp0_;
	gint ids_length1;
	gint _ids_size_;
	const gchar* _tmp1_;
	GSList* ibus_schemas = NULL;
	GSettingsSchemaSource* schema_source = NULL;
	GSettingsSchemaSource* _tmp5_;
	GSettingsSchemaSource* _tmp6_;
	gchar** list_schemas = NULL;
	gchar** _tmp7_;
	gint list_schemas_length1;
	gint _list_schemas_size_;
	GSettingsSchemaSource* _tmp8_;
	gchar** _tmp9_ = NULL;
	gchar** _tmp10_;
	gint _tmp10__length1;
	GSList* _tmp28_;
	GCompareFunc _tmp29_;
	GSList* result;
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	ids = _tmp0_;
	ids_length1 = 0;
	_ids_size_ = ids_length1;
	_tmp1_ = engine_id;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		gchar** _tmp3_;
		gchar** _tmp4_;
		_tmp2_ = engine_id;
		_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, ",", 0);
		ids = (_vala_array_free (ids, ids_length1, (GDestroyNotify) g_free), NULL);
		ids = _tmp4_;
		ids_length1 = _vala_array_length (_tmp3_);
		_ids_size_ = ids_length1;
	}
	ibus_schemas = NULL;
	_tmp5_ = g_settings_schema_source_get_default ();
	_tmp6_ = _g_settings_schema_source_ref0 (_tmp5_);
	schema_source = _tmp6_;
	_tmp7_ = g_new0 (gchar*, 0 + 1);
	list_schemas = _tmp7_;
	list_schemas_length1 = 0;
	_list_schemas_size_ = list_schemas_length1;
	_tmp8_ = schema_source;
	g_settings_schema_source_list_schemas (_tmp8_, TRUE, &_tmp9_, NULL);
	list_schemas = (_vala_array_free (list_schemas, list_schemas_length1, (GDestroyNotify) g_free), NULL);
	list_schemas = _tmp9_;
	list_schemas_length1 = -1;
	_list_schemas_size_ = list_schemas_length1;
	list_schemas_length1 = _vala_array_length (list_schemas);
	_tmp10_ = list_schemas;
	_tmp10__length1 = list_schemas_length1;
	{
		gchar** schema_collection = NULL;
		gint schema_collection_length1 = 0;
		gint _schema_collection_size_ = 0;
		gint schema_it = 0;
		schema_collection = _tmp10_;
		schema_collection_length1 = _tmp10__length1;
		for (schema_it = 0; schema_it < schema_collection_length1; schema_it = schema_it + 1) {
			gchar* _tmp11_;
			gchar* schema = NULL;
			_tmp11_ = g_strdup (schema_collection[schema_it]);
			schema = _tmp11_;
			{
				gchar** _tmp12_;
				gint _tmp12__length1;
				_tmp12_ = ids;
				_tmp12__length1 = ids_length1;
				if (_tmp12__length1 != 0) {
					gchar** _tmp13_;
					gint _tmp13__length1;
					_tmp13_ = ids;
					_tmp13__length1 = ids_length1;
					{
						gchar** id_collection = NULL;
						gint id_collection_length1 = 0;
						gint _id_collection_size_ = 0;
						gint id_it = 0;
						id_collection = _tmp13_;
						id_collection_length1 = _tmp13__length1;
						for (id_it = 0; id_it < id_collection_length1; id_it = id_it + 1) {
							const gchar* id = NULL;
							id = id_collection[id_it];
							{
								gboolean _tmp14_ = FALSE;
								const gchar* _tmp15_;
								const gchar* _tmp16_;
								_tmp15_ = id;
								_tmp16_ = schema;
								if (g_strcmp0 (_tmp15_, _tmp16_) == 0) {
									_tmp14_ = TRUE;
								} else {
									const gchar* _tmp17_;
									const gchar* _tmp18_;
									gchar* _tmp19_;
									gchar* _tmp20_;
									_tmp17_ = schema;
									_tmp18_ = id;
									_tmp19_ = g_strconcat ("org.freedesktop.ibus.engine.", _tmp18_, NULL);
									_tmp20_ = _tmp19_;
									_tmp14_ = g_str_has_prefix (_tmp17_, _tmp20_);
									_g_free0 (_tmp20_);
								}
								if (_tmp14_) {
									const gchar* _tmp21_;
									gchar* _tmp22_;
									_tmp21_ = schema;
									_tmp22_ = g_strdup (_tmp21_);
									ibus_schemas = g_slist_prepend (ibus_schemas, _tmp22_);
									break;
								}
							}
						}
					}
				} else {
					gboolean _tmp23_ = FALSE;
					const gchar* _tmp24_;
					_tmp24_ = schema;
					if (g_str_has_prefix (_tmp24_, "org.freedesktop.ibus")) {
						const gchar* _tmp25_;
						_tmp25_ = schema;
						_tmp23_ = !g_str_has_prefix (_tmp25_, "org.freedesktop.ibus.engine");
					} else {
						_tmp23_ = FALSE;
					}
					if (_tmp23_) {
						const gchar* _tmp26_;
						gchar* _tmp27_;
						_tmp26_ = schema;
						_tmp27_ = g_strdup (_tmp26_);
						ibus_schemas = g_slist_prepend (ibus_schemas, _tmp27_);
					}
				}
				_g_free0 (schema);
			}
		}
	}
	_tmp28_ = ibus_schemas;
	if (g_slist_length (_tmp28_) == ((guint) 0)) {
		g_printerr ("Not found schemas of \"org.freedesktop.ibus\"\n");
		result = ibus_schemas;
		list_schemas = (_vala_array_free (list_schemas, list_schemas_length1, (GDestroyNotify) g_free), NULL);
		_g_settings_schema_source_unref0 (schema_source);
		ids = (_vala_array_free (ids, ids_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp29_ = ((GCompareFunc) g_strcmp0);
	ibus_schemas = g_slist_sort (ibus_schemas, _tmp29_);
	result = ibus_schemas;
	list_schemas = (_vala_array_free (list_schemas, list_schemas_length1, (GDestroyNotify) g_free), NULL);
	_g_settings_schema_source_unref0 (schema_source);
	ids = (_vala_array_free (ids, ids_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static inline void
_g_slist_free__g_free0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_free0_);
}

gint
read_config (gchar** argv,
             gint argv_length1)
{
	GSList* ibus_schemas = NULL;
	GSList* _tmp0_;
	GSList* _tmp1_;
	GSettingsSchemaSource* schema_source = NULL;
	GSettingsSchemaSource* _tmp2_;
	GSettingsSchemaSource* _tmp3_;
	GString* output = NULL;
	GString* _tmp4_;
	GSList* _tmp5_;
	GString* _tmp26_;
	const gchar* _tmp27_;
	gint result;
	if (read_config_options (argv, (gint) argv_length1) == EXIT_FAILURE) {
		result = EXIT_FAILURE;
		return result;
	}
	_tmp0_ = get_ibus_schemas ();
	ibus_schemas = _tmp0_;
	_tmp1_ = ibus_schemas;
	if (g_slist_length (_tmp1_) == ((guint) 0)) {
		result = EXIT_FAILURE;
		(ibus_schemas == NULL) ? NULL : (ibus_schemas = (_g_slist_free__g_free0_ (ibus_schemas), NULL));
		return result;
	}
	_tmp2_ = g_settings_schema_source_get_default ();
	_tmp3_ = _g_settings_schema_source_ref0 (_tmp2_);
	schema_source = _tmp3_;
	_tmp4_ = g_string_new ("");
	output = _tmp4_;
	_tmp5_ = ibus_schemas;
	{
		GSList* schema_collection = NULL;
		GSList* schema_it = NULL;
		schema_collection = _tmp5_;
		for (schema_it = schema_collection; schema_it != NULL; schema_it = schema_it->next) {
			gchar* _tmp6_;
			gchar* schema = NULL;
			_tmp6_ = g_strdup ((const gchar*) schema_it->data);
			schema = _tmp6_;
			{
				GSettingsSchema* settings_schema = NULL;
				GSettingsSchemaSource* _tmp7_;
				const gchar* _tmp8_;
				GSettingsSchema* _tmp9_;
				GSettings* settings = NULL;
				const gchar* _tmp10_;
				GSettings* _tmp11_;
				GString* _tmp12_;
				const gchar* _tmp13_;
				GSettingsSchema* _tmp14_;
				gchar** _tmp15_;
				gchar** _tmp16_;
				_tmp7_ = schema_source;
				_tmp8_ = schema;
				_tmp9_ = g_settings_schema_source_lookup (_tmp7_, _tmp8_, FALSE);
				settings_schema = _tmp9_;
				_tmp10_ = schema;
				_tmp11_ = g_settings_new (_tmp10_);
				settings = _tmp11_;
				_tmp12_ = output;
				_tmp13_ = schema;
				g_string_append_printf (_tmp12_, "SCHEMA: %s\n", _tmp13_);
				_tmp14_ = settings_schema;
				_tmp16_ = _tmp15_ = g_settings_schema_list_keys (_tmp14_);
				{
					gchar** key_collection = NULL;
					gint key_collection_length1 = 0;
					gint _key_collection_size_ = 0;
					gint key_it = 0;
					key_collection = _tmp16_;
					key_collection_length1 = _vala_array_length (_tmp15_);
					for (key_it = 0; key_it < key_collection_length1; key_it = key_it + 1) {
						gchar* _tmp17_;
						gchar* key = NULL;
						_tmp17_ = g_strdup (key_collection[key_it]);
						key = _tmp17_;
						{
							GVariant* variant = NULL;
							GSettings* _tmp18_;
							const gchar* _tmp19_;
							GVariant* _tmp20_;
							GString* _tmp21_;
							const gchar* _tmp22_;
							GVariant* _tmp23_;
							gchar* _tmp24_;
							gchar* _tmp25_;
							_tmp18_ = settings;
							_tmp19_ = key;
							_tmp20_ = g_settings_get_value (_tmp18_, _tmp19_);
							variant = _tmp20_;
							_tmp21_ = output;
							_tmp22_ = key;
							_tmp23_ = variant;
							_tmp24_ = g_variant_print (_tmp23_, TRUE);
							_tmp25_ = _tmp24_;
							g_string_append_printf (_tmp21_, "  %s: %s\n", _tmp22_, _tmp25_);
							_g_free0 (_tmp25_);
							_g_variant_unref0 (variant);
							_g_free0 (key);
						}
					}
					key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
				}
				_g_object_unref0 (settings);
				_g_settings_schema_unref0 (settings_schema);
				_g_free0 (schema);
			}
		}
	}
	_tmp26_ = output;
	_tmp27_ = _tmp26_->str;
	g_print ("%s", _tmp27_);
	result = EXIT_SUCCESS;
	_g_string_free0 (output);
	_g_settings_schema_source_unref0 (schema_source);
	(ibus_schemas == NULL) ? NULL : (ibus_schemas = (_g_slist_free__g_free0_ (ibus_schemas), NULL));
	return result;
}

gint
reset_config (gchar** argv,
              gint argv_length1)
{
	GSList* ibus_schemas = NULL;
	GSList* _tmp0_;
	GSList* _tmp1_;
	GSettingsSchemaSource* schema_source = NULL;
	GSettingsSchemaSource* _tmp2_;
	GSettingsSchemaSource* _tmp3_;
	GSList* _tmp4_;
	gint result;
	if (read_config_options (argv, (gint) argv_length1) == EXIT_FAILURE) {
		result = EXIT_FAILURE;
		return result;
	}
	_tmp0_ = get_ibus_schemas ();
	ibus_schemas = _tmp0_;
	_tmp1_ = ibus_schemas;
	if (g_slist_length (_tmp1_) == ((guint) 0)) {
		result = EXIT_FAILURE;
		(ibus_schemas == NULL) ? NULL : (ibus_schemas = (_g_slist_free__g_free0_ (ibus_schemas), NULL));
		return result;
	}
	g_print ("%s\n", _ ("Resetting…"));
	_tmp2_ = g_settings_schema_source_get_default ();
	_tmp3_ = _g_settings_schema_source_ref0 (_tmp2_);
	schema_source = _tmp3_;
	_tmp4_ = ibus_schemas;
	{
		GSList* schema_collection = NULL;
		GSList* schema_it = NULL;
		schema_collection = _tmp4_;
		for (schema_it = schema_collection; schema_it != NULL; schema_it = schema_it->next) {
			gchar* _tmp5_;
			gchar* schema = NULL;
			_tmp5_ = g_strdup ((const gchar*) schema_it->data);
			schema = _tmp5_;
			{
				GSettingsSchema* settings_schema = NULL;
				GSettingsSchemaSource* _tmp6_;
				const gchar* _tmp7_;
				GSettingsSchema* _tmp8_;
				GSettings* settings = NULL;
				const gchar* _tmp9_;
				GSettings* _tmp10_;
				const gchar* _tmp11_;
				GSettingsSchema* _tmp12_;
				gchar** _tmp13_;
				gchar** _tmp14_;
				_tmp6_ = schema_source;
				_tmp7_ = schema;
				_tmp8_ = g_settings_schema_source_lookup (_tmp6_, _tmp7_, FALSE);
				settings_schema = _tmp8_;
				_tmp9_ = schema;
				_tmp10_ = g_settings_new (_tmp9_);
				settings = _tmp10_;
				_tmp11_ = schema;
				g_print ("SCHEMA: %s\n", _tmp11_);
				_tmp12_ = settings_schema;
				_tmp14_ = _tmp13_ = g_settings_schema_list_keys (_tmp12_);
				{
					gchar** key_collection = NULL;
					gint key_collection_length1 = 0;
					gint _key_collection_size_ = 0;
					gint key_it = 0;
					key_collection = _tmp14_;
					key_collection_length1 = _vala_array_length (_tmp13_);
					for (key_it = 0; key_it < key_collection_length1; key_it = key_it + 1) {
						gchar* _tmp15_;
						gchar* key = NULL;
						_tmp15_ = g_strdup (key_collection[key_it]);
						key = _tmp15_;
						{
							const gchar* _tmp16_;
							GSettings* _tmp17_;
							const gchar* _tmp18_;
							_tmp16_ = key;
							g_print ("  %s\n", _tmp16_);
							_tmp17_ = settings;
							_tmp18_ = key;
							g_settings_reset (_tmp17_, _tmp18_);
							_g_free0 (key);
						}
					}
					key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
				}
				_g_object_unref0 (settings);
				_g_settings_schema_unref0 (settings_schema);
				_g_free0 (schema);
			}
		}
	}
	g_settings_sync ();
	g_print ("%s\n", _ ("Done"));
	result = EXIT_SUCCESS;
	_g_settings_schema_source_unref0 (schema_source);
	(ibus_schemas == NULL) ? NULL : (ibus_schemas = (_g_slist_free__g_free0_ (ibus_schemas), NULL));
	return result;
}

gint
emoji_dialog (gchar** argv,
              gint argv_length1)
{
	gchar* cmd = NULL;
	gchar* _tmp0_;
	GFile* file = NULL;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar** env = NULL;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gint env_length1;
	gint _env_size_;
	GError* _inner_error0_ = NULL;
	gint result;
	_tmp0_ = g_strdup (LIBEXECDIR "/ibus-ui-emojier");
	cmd = _tmp0_;
	_tmp1_ = cmd;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	file = _tmp2_;
	_tmp3_ = file;
	if (!g_file_query_exists (_tmp3_, NULL)) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("../ui/gtk3/ibus-ui-emojier");
		_g_free0 (cmd);
		cmd = _tmp4_;
	}
	_tmp5_ = cmd;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (argv[0]);
	argv[0] = _tmp6_;
	_tmp8_ = _tmp7_ = g_get_environ ();
	env = _tmp8_;
	env_length1 = _vala_array_length (_tmp7_);
	_env_size_ = env_length1;
	{
		gchar** _tmp9_;
		gint _tmp9__length1;
		_tmp9_ = env;
		_tmp9__length1 = env_length1;
		g_spawn_async (NULL, argv, _tmp9_, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp10_ = -1;
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			env = (_vala_array_free (env, env_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (file);
			_g_free0 (cmd);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp10_;
		}
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp11_;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = stderr;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		fprintf (_tmp11_, "%s\n", _tmp13_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		env = (_vala_array_free (env, env_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (file);
		_g_free0 (cmd);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp14_ = -1;
		env = (_vala_array_free (env, env_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (file);
		_g_free0 (cmd);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp14_;
	}
	result = EXIT_SUCCESS;
	env = (_vala_array_free (env, env_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (file);
	_g_free0 (cmd);
	return result;
}

gint
read_im_module (gchar** argv,
                gint argv_length1)
{
	gchar* im_module = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gint result;
	_tmp0_ = ibus_im_module_get_id ((gint) argv_length1, argv);
	im_module = _tmp0_;
	_tmp1_ = im_module;
	if (_tmp1_ == NULL) {
		result = EXIT_FAILURE;
		_g_free0 (im_module);
		return result;
	}
	_tmp2_ = im_module;
	_tmp3_ = g_strdup_printf ("%s\n", _tmp2_);
	_tmp4_ = _tmp3_;
	g_print ("%s", _tmp4_);
	_g_free0 (_tmp4_);
	result = EXIT_SUCCESS;
	_g_free0 (im_module);
	return result;
}

gint
print_help (gchar** argv,
            gint argv_length1)
{
	FILE* _tmp0_;
	gint result;
	_tmp0_ = stdout;
	print_usage (_tmp0_);
	result = EXIT_SUCCESS;
	return result;
}

CommandEntry*
command_entry_dup (const CommandEntry* self)
{
	CommandEntry* dup;
	dup = g_new0 (CommandEntry, 1);
	memcpy (dup, self, sizeof (CommandEntry));
	return dup;
}

void
command_entry_free (CommandEntry* self)
{
	g_free (self);
}

static GType
command_entry_get_type_once (void)
{
	GType command_entry_type_id;
	command_entry_type_id = g_boxed_type_register_static ("CommandEntry", (GBoxedCopyFunc) command_entry_dup, (GBoxedFreeFunc) command_entry_free);
	return command_entry_type_id;
}

GType
command_entry_get_type (void)
{
	static volatile gsize command_entry_type_id__once = 0;
	if (g_once_init_enter (&command_entry_type_id__once)) {
		GType command_entry_type_id;
		command_entry_type_id = command_entry_get_type_once ();
		g_once_init_leave (&command_entry_type_id__once, command_entry_type_id);
	}
	return command_entry_type_id__once;
}

static gint
_get_set_engine_entry_func (gchar** argv,
                            gint argv_length1,
                            gpointer self)
{
	gint result;
	result = get_set_engine (argv, argv_length1);
	return result;
}

static gint
_exit_daemon_entry_func (gchar** argv,
                         gint argv_length1,
                         gpointer self)
{
	gint result;
	result = exit_daemon (argv, argv_length1);
	return result;
}

static gint
_list_engine_entry_func (gchar** argv,
                         gint argv_length1,
                         gpointer self)
{
	gint result;
	result = list_engine (argv, argv_length1);
	return result;
}

static gint
_message_watch_entry_func (gchar** argv,
                           gint argv_length1,
                           gpointer self)
{
	gint result;
	result = message_watch (argv, argv_length1);
	return result;
}

static gint
_restart_daemon_entry_func (gchar** argv,
                            gint argv_length1,
                            gpointer self)
{
	gint result;
	result = restart_daemon (argv, argv_length1);
	return result;
}

static gint
_start_daemon_entry_func (gchar** argv,
                          gint argv_length1,
                          gpointer self)
{
	gint result;
	result = start_daemon (argv, argv_length1);
	return result;
}

static gint
_print_version_entry_func (gchar** argv,
                           gint argv_length1,
                           gpointer self)
{
	gint result;
	result = print_version (argv, argv_length1);
	return result;
}

static gint
_read_cache_entry_func (gchar** argv,
                        gint argv_length1,
                        gpointer self)
{
	gint result;
	result = read_cache (argv, argv_length1);
	return result;
}

static gint
_write_cache_entry_func (gchar** argv,
                         gint argv_length1,
                         gpointer self)
{
	gint result;
	result = write_cache (argv, argv_length1);
	return result;
}

static gint
_print_address_entry_func (gchar** argv,
                           gint argv_length1,
                           gpointer self)
{
	gint result;
	result = print_address (argv, argv_length1);
	return result;
}

static gint
_read_config_entry_func (gchar** argv,
                         gint argv_length1,
                         gpointer self)
{
	gint result;
	result = read_config (argv, argv_length1);
	return result;
}

static gint
_reset_config_entry_func (gchar** argv,
                          gint argv_length1,
                          gpointer self)
{
	gint result;
	result = reset_config (argv, argv_length1);
	return result;
}

static gint
_emoji_dialog_entry_func (gchar** argv,
                          gint argv_length1,
                          gpointer self)
{
	gint result;
	result = emoji_dialog (argv, argv_length1);
	return result;
}

static gint
_read_im_module_entry_func (gchar** argv,
                            gint argv_length1,
                            gpointer self)
{
	gint result;
	result = read_im_module (argv, argv_length1);
	return result;
}

static gint
_print_help_entry_func (gchar** argv,
                        gint argv_length1,
                        gpointer self)
{
	gint result;
	result = print_help (argv, argv_length1);
	return result;
}

void
print_usage (FILE* stream)
{
	const gchar* _tmp0_;
	g_return_if_fail (stream != NULL);
	_tmp0_ = program_name;
	fprintf (stream, _ ("Usage: %s COMMAND [OPTION...]\n\n"), _tmp0_);
	fprintf (stream, "%s", _ ("Commands:\n"));
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				CommandEntry _tmp3_;
				const gchar* _tmp4_;
				CommandEntry _tmp5_;
				const gchar* _tmp6_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < G_N_ELEMENTS (commands))) {
					break;
				}
				_tmp3_ = commands[i];
				_tmp4_ = _tmp3_.name;
				_tmp5_ = commands[i];
				_tmp6_ = _tmp5_.description;
				fprintf (stream, "  %-12s    %s\n", _tmp4_, g_dgettext (NULL, _tmp6_));
			}
		}
	}
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gint
_vala_main (gchar** argv,
            gint argv_length1)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** new_argv = NULL;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gint new_argv_length1;
	gint _new_argv_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	FILE* _tmp17_;
	const gchar* _tmp18_;
	FILE* _tmp19_;
	gint result;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	ibus_init ();
	_tmp0_ = argv[0];
	_tmp1_ = g_path_get_basename (_tmp0_);
	_g_free0 (program_name);
	program_name = _tmp1_;
	if (argv_length1 < 2) {
		FILE* _tmp2_;
		_tmp2_ = stderr;
		print_usage (_tmp2_);
		result = EXIT_FAILURE;
		return result;
	}
	_tmp3_ = (argv != NULL) ? _vala_array_dup1 (argv + 1, argv_length1 - 1) : argv;
	_tmp3__length1 = argv_length1 - 1;
	new_argv = _tmp3_;
	new_argv_length1 = _tmp3__length1;
	_new_argv_size_ = new_argv_length1;
	_tmp4_ = new_argv;
	_tmp4__length1 = new_argv_length1;
	_tmp5_ = program_name;
	_tmp6_ = new_argv;
	_tmp6__length1 = new_argv_length1;
	_tmp7_ = _tmp6_[0];
	_tmp8_ = g_strdup_printf ("%s %s", _tmp5_, _tmp7_);
	_g_free0 (_tmp4_[0]);
	_tmp4_[0] = _tmp8_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				CommandEntry _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				if (!(i < G_N_ELEMENTS (commands))) {
					break;
				}
				_tmp11_ = commands[i];
				_tmp12_ = _tmp11_.name;
				_tmp13_ = argv[1];
				if (g_strcmp0 (_tmp12_, _tmp13_) == 0) {
					CommandEntry _tmp14_;
					EntryFunc _tmp15_;
					gpointer _tmp15__target;
					gchar** _tmp16_;
					gint _tmp16__length1;
					_tmp14_ = commands[i];
					_tmp15_ = _tmp14_.entry;
					_tmp15__target = _tmp14_.entry_target;
					_tmp16_ = new_argv;
					_tmp16__length1 = new_argv_length1;
					result = _tmp15_ (_tmp16_, (gint) _tmp16__length1, _tmp15__target);
					new_argv = (_vala_array_free (new_argv, new_argv_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
			}
		}
	}
	_tmp17_ = stderr;
	_tmp18_ = argv[1];
	fprintf (_tmp17_, _ ("%s is unknown command!\n"), _tmp18_);
	_tmp19_ = stderr;
	print_usage (_tmp19_);
	result = EXIT_FAILURE;
	new_argv = (_vala_array_free (new_argv, new_argv_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return _vala_main (argv, argc);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

