/* SPDX-License-Identifier: LGPL-2.1-or-later */
/*
 * Copyright (C) 2015 Red Hat, Inc.
 */

#ifndef __NM_NETWORKMANAGER_COMPILATION_H__
#define __NM_NETWORKMANAGER_COMPILATION_H__

#define NM_NETWORKMANAGER_COMPILATION_WITH_GLIB                (1 << 0)
#define NM_NETWORKMANAGER_COMPILATION_WITH_GLIB_I18N_LIB       (1 << 1)
#define NM_NETWORKMANAGER_COMPILATION_WITH_GLIB_I18N_PROG      (1 << 2)
#define NM_NETWORKMANAGER_COMPILATION_WITH_LIBNM               (1 << 3)
#define NM_NETWORKMANAGER_COMPILATION_WITH_LIBNM_PRIVATE       (1 << 4)
#define NM_NETWORKMANAGER_COMPILATION_WITH_LIBNM_CORE          (1 << 5)
#define NM_NETWORKMANAGER_COMPILATION_WITH_LIBNM_CORE_INTERNAL (1 << 6)
#define NM_NETWORKMANAGER_COMPILATION_WITH_LIBNM_CORE_PRIVATE  (1 << 7)
#define NM_NETWORKMANAGER_COMPILATION_WITH_DAEMON              (1 << 10)
#define NM_NETWORKMANAGER_COMPILATION_WITH_SYSTEMD             (1 << 11)

#define NM_NETWORKMANAGER_COMPILATION_LIBNM_CORE             \
    (0 | NM_NETWORKMANAGER_COMPILATION_WITH_GLIB             \
     | NM_NETWORKMANAGER_COMPILATION_WITH_GLIB_I18N_LIB      \
     | NM_NETWORKMANAGER_COMPILATION_WITH_LIBNM_CORE         \
     | NM_NETWORKMANAGER_COMPILATION_WITH_LIBNM_CORE_PRIVATE \
     | NM_NETWORKMANAGER_COMPILATION_WITH_LIBNM_CORE_INTERNAL)

#define NM_NETWORKMANAGER_COMPILATION_LIBNM                                                        \
    (0 | NM_NETWORKMANAGER_COMPILATION_WITH_GLIB                                                   \
     | NM_NETWORKMANAGER_COMPILATION_WITH_GLIB_I18N_LIB | NM_NETWORKMANAGER_COMPILATION_WITH_LIBNM \
     | NM_NETWORKMANAGER_COMPILATION_WITH_LIBNM_PRIVATE                                            \
     | NM_NETWORKMANAGER_COMPILATION_WITH_LIBNM_CORE                                               \
     | NM_NETWORKMANAGER_COMPILATION_WITH_LIBNM_CORE_INTERNAL)

#define NM_NETWORKMANAGER_COMPILATION_CLIENT             \
    (0 | NM_NETWORKMANAGER_COMPILATION_WITH_GLIB         \
     | NM_NETWORKMANAGER_COMPILATION_WITH_GLIB_I18N_PROG \
     | NM_NETWORKMANAGER_COMPILATION_WITH_LIBNM | NM_NETWORKMANAGER_COMPILATION_WITH_LIBNM_CORE)

#define NM_NETWORKMANAGER_COMPILATION_DAEMON                  \
    (0 | NM_NETWORKMANAGER_COMPILATION_WITH_GLIB              \
     | NM_NETWORKMANAGER_COMPILATION_WITH_GLIB_I18N_PROG      \
     | NM_NETWORKMANAGER_COMPILATION_WITH_LIBNM_CORE          \
     | NM_NETWORKMANAGER_COMPILATION_WITH_LIBNM_CORE_INTERNAL \
     | NM_NETWORKMANAGER_COMPILATION_WITH_DAEMON)

#define NM_NETWORKMANAGER_COMPILATION_SYSTEMD_SHARED \
    (0 | NM_NETWORKMANAGER_COMPILATION_WITH_GLIB | NM_NETWORKMANAGER_COMPILATION_WITH_SYSTEMD)

#define NM_NETWORKMANAGER_COMPILATION_SYSTEMD \
    (0 | NM_NETWORKMANAGER_COMPILATION_DAEMON | NM_NETWORKMANAGER_COMPILATION_SYSTEMD_SHARED)

#define NM_NETWORKMANAGER_COMPILATION_GLIB (0 | NM_NETWORKMANAGER_COMPILATION_WITH_GLIB)

#endif /* __NM_NETWORKMANAGER_COMPILATION_H__ */
