.\" *********************************** start of \input{common.tex}
.\" *********************************** end of \input{common.tex}
'\" t
.\" Manual page created with latex2man on Tue Aug 29 11:45:59 2023
.\" NOTE: This file is generated, DO NOT EDIT.
.de Vb
.ft CW
.nf
..
.de Ve
.ft R

.fi
..
.TH "UNW\\_GET\\_PROC\\_INFO\\_IN\\_RANGE" "3libunwind" "29 August 2023" "Programming Library " "Programming Library "
.SH NAME
unw_get_proc_info_in_range
\-\- get procedure info in IP range and a frame index table 
.PP
.SH SYNOPSIS

.PP
#include <libunwind.h>
.br
.PP
int
unw_get_proc_info_in_range(unw_word_t start_ip,
unw_word_t end_ip,
unw_word_t eh_frame_table,
unw_word_t eh_frame_table_len,
unw_word_t exidx_frame_table,
unw_word_t exidx_frame_table_len,,
unw_addr_space_t *as,
void *arg);
.br
.PP
.SH DESCRIPTION

.PP
The unw_get_proc_info_in_range()
routine returns the same 
kind of auxiliary information about a procedure as 
unw_get_proc_info_by_ip(),
except that the info is looked up in 
instruction pointer (IP) range and frame table instead of just at IP. This 
is equally flexible because it is possible to look up the info for an arbitrary 
procedure, even if it is not part of the current call chain. However, since it 
is more flexible, it also tends to run slower (and often much slower) 
than unw_get_proc_info().
.PP
.SH RETURN VALUE

.PP
On successful completion, unw_get_proc_info_in_range()
returns 0. Otherwise the negative value of one of the error\-codes 
below is returned. 
.PP
.SH THREAD AND SIGNAL SAFETY

.PP
unw_get_proc_info_in_range()
is thread safe. If the local 
address space is passed in argument as,
this routine is also 
safe to use from a signal handler. 
.PP
.SH ERRORS

.PP
.TP
UNW_EUNSPEC
 An unspecified error occurred. 
.TP
UNW_ENOINFO
 Libunwind
was unable to locate 
unwind\-info for the procedure. 
.TP
UNW_EBADVERSION
 The unwind\-info for the procedure has 
version or format that is not understood by libunwind\&.
.TP
UNW_EINVAL
 An unsupported table encoding was specified. 
.PP
In addition, unw_get_proc_info_by_ip()
may return any 
error returned by the access_mem()
callback (see 
unw_create_addr_space(3libunwind)).
.PP
.SH SEE ALSO

.PP
libunwind(3libunwind),
unw_get_proc_info_in_range(3libunwind),
unw_create_addr_space(3libunwind),
unw_get_proc_name(3libunwind),
unw_get_proc_info(3libunwind)
.PP
.SH AUTHOR

.PP
David Mosberger\-Tang
.br
Email: \fBdmosberger@gmail.com\fP
.br
WWW: \fBhttp://www.nongnu.org/libunwind/\fP\&.
.\" NOTE: This file is generated, DO NOT EDIT.
