.\" *********************************** start of \input{common.tex}
.\" *********************************** end of \input{common.tex}
'\" t
.\" Manual page created with latex2man on Fri Sep 15 20:49:35 2023
.\" NOTE: This file is generated, DO NOT EDIT.
.de Vb
.ft CW
.nf
..
.de Ve
.ft R

.fi
..
.TH "UNW\\_GET\\_ELF\\_FILENAME\\_BY\\_IP" "3libunwind" "15 September 2023" "Programming Library " "Programming Library "
.SH NAME
unw_get_elf_filename_by_ip
\-\- get backing elf filename by instruction pointer 
.PP
.SH SYNOPSIS

.PP
#include <libunwind.h>
.br
.PP
int
unw_get_elf_filename_by_ip(unw_addr_space_t as,
unw_word_t ip,
char *bufp,
size_t
len,
unw_word_t *offp,
void *arg);
.br
.PP
.SH DESCRIPTION

.PP
The unw_get_elf_filename_by_ip()
routine returns the backing 
elf filename of a instruction pointer just like unw_get_elf_filename(),
except that the name is looked up by instruction pointer (IP) instead 
of a cursor. 
.PP
The routine expects the following arguments: as
is the 
address\-space in which the instruction pointer should be looked up. 
For a look\-up in the local address\-space, 
unw_local_addr_space
can be passed for this argument. 
Argument ip
is the instruction\-pointer for which the elf filename 
should be looked up. The bufp
argument is a pointer to 
a character buffer that is at least len
bytes long. This buffer 
is used to return the elf filename. The offp
argument 
is a pointer to a word that is used to return the byte offset of the 
instruction\-pointer relative to the start of the elf filename. 
Lastly, arg
is the address space argument that should be used 
when accessing the address space. It has the same purpose as the 
argument of the same name for unw_init_remote().
When 
accessing the local address space (first argument is 
unw_local_addr_space),
NULL
must be passed for this 
argument. 
.PP
.SH RETURN VALUE

.PP
On successful completion, unw_get_elf_filename_by_ip()
returns 0. Otherwise the negative value of one of the error codes 
below is returned. 
.PP
.SH THREAD AND SIGNAL SAFETY

.PP
unw_get_elf_filename_by_ip()
is thread safe. If the local 
address\-space is passed in argument as,
this routine is also 
safe to use from a signal handler. 
.PP
.SH ERRORS

.PP
.TP
UNW_EUNSPEC
 An unspecified error occurred. 
.TP
UNW_ENOINFO
 Libunwind
was unable to determine 
the elf filename of the instruction pointer. 
.TP
UNW_ENOMEM
 The elf filename is too long to fit 
in the buffer provided. A truncated version of the name has been 
returned. 
.PP
.SH SEE ALSO

.PP
libunwind(3libunwind),
unw_get_elf_filename(3libunwind),
unw_create_addr_space(3libunwind),
unw_init_remote(3libunwind)
.PP
.SH AUTHOR

.PP
Xiang Lin
.br
Email: \fBmyd.xia@gmail.com\fP
.br
.\" NOTE: This file is generated, DO NOT EDIT.
