// Generated by gmmproc 2.84.0 -- DO NOT MODIFY!
#ifndef _GTKMM_WINDOW_H
#define _GTKMM_WINDOW_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 1998-2013 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <https://www.gnu.org/licenses/>.
 */

#include <vector>

#include <glibmm/object.h>
#include <gdkmm/surface.h>
#include <gdkmm/texture.h>
#include <gtkmm/widget.h>
#include <gtkmm/native.h>
#include <gtkmm/root.h>
#include <gtkmm/shortcutmanager.h>
#include <gtkmm/windowgroup.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GtkWindow = struct _GtkWindow;
using GtkWindowClass = struct _GtkWindowClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class GTKMM_API Window_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gio
{
class GTKMM_API ListModel;
}

namespace Gtk
{

class GTKMM_API Application;
class GTKMM_API WindowGroup;

/** @addtogroup gtkmmEnums gtkmm Enums and Flags */

/** 
 *  @var WindowGravity::TOP_LEFT
 * The top left corner.
 * 
 *  @var WindowGravity::TOP
 * The top edge.
 * 
 *  @var WindowGravity::TOP_RIGHT
 * The top right corner.
 * 
 *  @var WindowGravity::LEFT
 * The left edge.
 * 
 *  @var WindowGravity::CENTER
 * The center pointer.
 * 
 *  @var WindowGravity::RIGHT
 * The right edge.
 * 
 *  @var WindowGravity::BOTTOM_LEFT
 * The bottom left corner.
 * 
 *  @var WindowGravity::BOTTOM
 * The bottom edge.
 * 
 *  @var WindowGravity::BOTTOM_RIGHT
 * The bottom right corner.
 * 
 *  @var WindowGravity::TOP_START
 * The top left or top right corner,
 * depending on the text direction.
 * 
 *  @var WindowGravity::TOP_END
 * The top right or top left corner,
 * depending on the text direction.
 * 
 *  @var WindowGravity::START
 * The left or right edge,
 * depending on the text direction.
 * 
 *  @var WindowGravity::END
 * The right or left edge,
 * depending on the text direction.
 * 
 *  @var WindowGravity::BOTTOM_START
 * The bottom left or top right corner,
 * depending on the text direction.
 * 
 *  @var WindowGravity::BOTTOM_END
 * The bottom right or top left corner,
 * depending on the text direction.
 */
 /** Determines which point or edge of a window is meant to remain fixed
 * when a window changes size.
 * 
 * @newin{4,20}
 *
 * @ingroup gtkmmEnums
 */
enum class WindowGravity
{
  TOP_LEFT,
  TOP,
  TOP_RIGHT,
  LEFT,
  CENTER,
  RIGHT,
  BOTTOM_LEFT,
  BOTTOM,
  BOTTOM_RIGHT,
  TOP_START,
  TOP_END,
  START,
  END,
  BOTTOM_START,
  BOTTOM_END
};


} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class GTKMM_API Value<Gtk::WindowGravity> : public Glib::Value_Enum<Gtk::WindowGravity>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{


/** Toplevel %Window.
 * This represents all widgets which are physical windows controlled
 * by the window manager.
 *
 * The window will be destroyed when the window manager's close button is clicked.
 * Call set_hide_on_close() if you want it to be hidden instead.
 *
 * When a window is closed (hidden), it's removed from its application.
 * This can cause Application::run() to return, if it is the last window.
 *
 * @ingroup Widgets
 */

class GTKMM_API Window : public Widget, public Native, public ShortcutManager, public Root
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Window CppObjectType;
  typedef Window_Class CppClassType;
  typedef GtkWindow BaseObjectType;
  typedef GtkWindowClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  // noncopyable
  Window(const Window&) = delete;
  Window& operator=(const Window&) = delete;

  ~Window() noexcept override;

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend GTKMM_API class Window_Class;
  static CppClassType window_class_;

protected:
  explicit Window(const Glib::ConstructParams& construct_params);
  explicit Window(GtkWindow* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  /// Provides access to the underlying C GObject.
  GtkWindow*       gobj()       { return reinterpret_cast<GtkWindow*>(gobject_); }

  /// Provides access to the underlying C GObject.
  const GtkWindow* gobj() const { return reinterpret_cast<GtkWindow*>(gobject_); }

private:

  
public:
  // Disambiguate calls to get_display(). Use Root::get_display(), not Widget::get_display().
  // gtk_widget_get_display() calls gtk_root_get_display(). There is no reason
  // to call gtk_widget_get_display() from a class that implements GtkRoot.
  using Root::get_display;

  // All constructors are hand-coded, because they connect a signal handler.
  
  
  Window(Window&& src) noexcept;
  Window& operator=(Window&& src) noexcept;

  explicit Window();
  

  /** The title of the window.
   *
   * Default value: ""
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_title() ;

/** The title of the window.
   *
   * Default value: ""
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_title() const;

  /** A write-only property for setting window's startup notification identifier.
   *
   * Default value: ""
   *
   * @return A PropertyProxy_WriteOnly that allows you to set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_WriteOnly< Glib::ustring > property_startup_id() ;


  /** If true, users can resize the window.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_resizable() ;

/** If true, users can resize the window.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_resizable() const;

  /** If true, the window is modal.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_modal() ;

/** If true, the window is modal.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_modal() const;

  /** The default width of the window.
   *
   * Default value: 0
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_default_width() ;

/** The default width of the window.
   *
   * Default value: 0
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_default_width() const;

  /** The default height of the window.
   *
   * Default value: 0
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_default_height() ;

/** The default height of the window.
   *
   * Default value: 0
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_default_height() const;

  /** If this window should be destroyed when the parent is destroyed.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_destroy_with_parent() ;

/** If this window should be destroyed when the parent is destroyed.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_destroy_with_parent() const;

  /** If this window should be hidden instead of destroyed when the user clicks
   * the close button.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_hide_on_close() ;

/** If this window should be hidden instead of destroyed when the user clicks
   * the close button.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_hide_on_close() const;

  /** Whether mnemonics are currently visible in this window.
   * 
   * This property is maintained by GTK based on user input,
   * and should not be set by applications.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_mnemonics_visible() ;

/** Whether mnemonics are currently visible in this window.
   * 
   * This property is maintained by GTK based on user input,
   * and should not be set by applications.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_mnemonics_visible() const;

  /** Specifies the name of the themed icon to use as the window icon.
   * 
   * See Gtk::IconTheme for more details.
   *
   * Default value: ""
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_icon_name() ;

/** Specifies the name of the themed icon to use as the window icon.
   * 
   * See Gtk::IconTheme for more details.
   *
   * Default value: ""
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_icon_name() const;

  /** The display that will display this window.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gdk::Display> > property_display() ;

/** The display that will display this window.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gdk::Display> > property_display() const;

  /** Whether the toplevel is the currently active window.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_is_active() const;


  /** Whether the window should have a frame (also known as *decorations*).
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_decorated() ;

/** Whether the window should have a frame (also known as *decorations*).
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_decorated() const;

  /** The transient parent of the window.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Window* > property_transient_for() ;

/** The transient parent of the window.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Window* > property_transient_for() const;


  /** Whether the window frame should have a close button.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_deletable() ;

/** Whether the window frame should have a close button.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_deletable() const;

  /** The `Gtk::Application` associated with the window.
   * 
   * The application will be kept alive for at least as long as it
   * has any windows associated with it (see Glib::application_hold()
   * for a way to keep it alive without windows).
   * 
   * Normally, the connection between the application and the window
   * will remain until the window is destroyed, but you can explicitly
   * remove it by setting the this property to <tt>nullptr</tt>.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Application> > property_application() ;

/** The `Gtk::Application` associated with the window.
   * 
   * The application will be kept alive for at least as long as it
   * has any windows associated with it (see Glib::application_hold()
   * for a way to keep it alive without windows).
   * 
   * Normally, the connection between the application and the window
   * will remain until the window is destroyed, but you can explicitly
   * remove it by setting the this property to <tt>nullptr</tt>.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Application> > property_application() const;

  /** Whether 'focus rectangles' are currently visible in this window.
   * 
   * This property is maintained by GTK based on user input
   * and should not be set by applications.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_focus_visible() ;

/** Whether 'focus rectangles' are currently visible in this window.
   * 
   * This property is maintained by GTK based on user input
   * and should not be set by applications.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_focus_visible() const;

  /** Whether the window is maximized.
   * 
   * Setting this property is the equivalent of calling
   * Gtk::Window::maximize() or Gtk::Window::unmaximize();
   * either operation is asynchronous, which means you will need to
   * connect to the signal_notify() signal in order to know whether the
   * operation was successful.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_maximized() ;

/** Whether the window is maximized.
   * 
   * Setting this property is the equivalent of calling
   * Gtk::Window::maximize() or Gtk::Window::unmaximize();
   * either operation is asynchronous, which means you will need to
   * connect to the signal_notify() signal in order to know whether the
   * operation was successful.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_maximized() const;

  /** Whether the window is fullscreen.
   * 
   * Setting this property is the equivalent of calling
   * Gtk::Window::fullscreen() or Gtk::Window::unfullscreen();
   * either operation is asynchronous, which means you will need to
   * connect to the signal_notify() signal in order to know whether the
   * operation was successful.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_fullscreened() ;

/** Whether the window is fullscreen.
   * 
   * Setting this property is the equivalent of calling
   * Gtk::Window::fullscreen() or Gtk::Window::unfullscreen();
   * either operation is asynchronous, which means you will need to
   * connect to the signal_notify() signal in order to know whether the
   * operation was successful.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_fullscreened() const;

  /** Whether the window is suspended.
   * 
   * See Gtk::Window::is_suspended() for details about what suspended means.
   * 
   * @newin{4,12}
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_suspended() const;


  /** The default widget.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Widget* > property_default_widget() ;

/** The default widget.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Widget* > property_default_widget() const;

  /** The focus widget.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Widget* > property_focus_widget() ;

/** The focus widget.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Widget* > property_focus_widget() const;

  /** The child widget.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Widget* > property_child() ;

/** The child widget.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Widget* > property_child() const;

  /** The titlebar widget.
   * 
   * @newin{4,6}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Widget* > property_titlebar() ;

/** The titlebar widget.
   * 
   * @newin{4,6}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Widget* > property_titlebar() const;

  /** Whether the window frame should handle <kbd>F10</kbd> for activating
   * menubars.
   * 
   * @newin{4,2}
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_handle_menubar_accel() ;

/** Whether the window frame should handle <kbd>F10</kbd> for activating
   * menubars.
   * 
   * @newin{4,2}
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_handle_menubar_accel() const;

  /** The gravity to use when resizing the window programmatically.
   * 
   * Gravity describes which point of the window we want to keep
   * fixed (meaning that the window will grow in the opposite direction).
   * For example, a gravity of `Gtk::WindowGravity::TOP_RIGHT` means that we
   * want the to fix top right corner of the window.
   * 
   * @newin{4,20}
   *
   * Default value: Gtk::WindowGravity::TOP_START
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< WindowGravity > property_gravity() ;

/** The gravity to use when resizing the window programmatically.
   * 
   * Gravity describes which point of the window we want to keep
   * fixed (meaning that the window will grow in the opposite direction).
   * For example, a gravity of `Gtk::WindowGravity::TOP_RIGHT` means that we
   * want the to fix top right corner of the window.
   * 
   * @newin{4,20}
   *
   * Default value: Gtk::WindowGravity::TOP_START
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< WindowGravity > property_gravity() const;


#ifndef GTKMM_DISABLE_DEPRECATED

  /**
   * @par Slot Prototype:
   * <tt>void on_my_%keys_changed()</tt>
   *
   * Flags: Run First
   *
   * Emitted when the set of accelerators or mnemonics that
   * are associated with the window changes.
   * 
   * Deprecated: 4.10: Use Gtk::Shortcut and Gtk::EventController
   * to implement keyboard shortcuts
   * 
   * @deprecated Use Gtk::Shortcut and Gtk::EventController to implement keyboard shortcuts.
   */

  Glib::SignalProxy<void()> signal_keys_changed();
#endif // GTKMM_DISABLE_DEPRECATED


  /**
   * @par Slot Prototype:
   * <tt>bool on_my_%close_request()</tt>
   *
   * Flags: Run Last
   *
   * Emitted when the user clicks on the close button of the window.
   * 
   * Return: true to stop other handlers from being invoked for the signal
   */

  Glib::SignalProxy<bool()> signal_close_request();


  //Keybinding signals:
  
  
  /** Sets the title of the window.
   * 
   * The title of a window will be displayed in its title bar; on the
   * X&nbsp;%Window System, the title bar is rendered by the window manager
   * so exactly how the title appears to users may vary according to a
   * user’s exact configuration. The title should help a user distinguish
   * this window from other windows they may have open. A good title might
   * include the application name and current document filename, for example.
   * 
   * Passing <tt>nullptr</tt> does the same as setting the title to an empty string.
   * 
   * @param title Title of the window.
   */
  void set_title(const Glib::ustring& title);

  
  /** Retrieves the title of the window.
   * 
   * @return The title.
   */
  Glib::ustring get_title() const;

  
  /** Sets the startup notification ID.
   * 
   * Startup notification identifiers are used by desktop environment
   * to track application startup, to provide user feedback and other
   * features. This function changes the corresponding property on the
   * underlying `Gdk::Surface`.
   * 
   * Normally, startup identifier is managed automatically and you should
   * only use this function in special cases like transferring focus from
   * other processes. You should use this function before calling
   * present() or any equivalent function generating
   * a window map event.
   * 
   * This function is only useful on Wayland or X11, not with other GDK
   * backends.
   * 
   * @param startup_id A string with startup-notification identifier.
   */
  void set_startup_id(const Glib::ustring& startup_id);

  
  /** If @a focus is not the current focus widget, and is focusable, sets
   * it as the focus widget for the window. To set the focus to a particular
   * widget in the toplevel, it is usually more convenient to use
   * Gtk::Widget::grab_focus() instead of this function.
   * 
   * @param focus Widget to be the new focus widget.
   */
  void set_focus(Gtk::Widget& focus);
  void unset_focus();

  
  /** Retrieves the current focused widget within the window.
   * 
   * Note that this is the widget that would have the focus
   * if the toplevel window focused; if the toplevel window
   * is not focused then `gtk_widget_has_focus (widget)` will
   * not be false for the widget.
   * 
   * @return The currently focused widget.
   */
  Widget* get_focus();
  
  /** Retrieves the current focused widget within the window.
   * 
   * Note that this is the widget that would have the focus
   * if the toplevel window focused; if the toplevel window
   * is not focused then `gtk_widget_has_focus (widget)` will
   * not be false for the widget.
   * 
   * @return The currently focused widget.
   */
  const Widget* get_focus() const;
  
  /** Sets the default widget.
   * 
   * The default widget is the widget that is activated
   * when the user presses <kbd>Enter</kbd> in a dialog
   * (for example).
   * 
   * @param default_widget Widget to be the default.
   */
  void set_default_widget(Gtk::Widget& default_widget);
  void unset_default_widget();

  
  /** Returns the default widget for @a window.
   * 
   * @return The default widget.
   */
  Widget* get_default_widget();
  
  /** Returns the default widget for @a window.
   * 
   * @return The default widget.
   */
  const Widget* get_default_widget() const;

  
  /** Sets a transient parent for the window.
   * 
   * Dialog windows should be set transient for the main application
   * window they were spawned from. This allows window managers to e.g.
   * keep the dialog on top of the main window, or center the dialog
   * over the main window. Gtk::Dialog::new_with_buttons() and other
   * convenience functions in GTK will sometimes call this function on
   * your behalf.
   * 
   * Passing <tt>nullptr</tt> for @a parent unsets the current transient window.
   * 
   * On Windows, this function puts the child window on top of the parent,
   * much as the window manager would have done on X.
   * 
   * @param parent Parent window.
   */
  void set_transient_for(Window& parent);

  /** Unsets the current transient window.
   * @see set_transient_for().
   */
  void unset_transient_for();

  
  /** Fetches the transient parent for this window.
   * 
   * @return The transient parent.
   */
  Window* get_transient_for();
  
  /** Fetches the transient parent for this window.
   * 
   * @return The transient parent.
   */
  const Window* get_transient_for() const;

  
  /** Sets whether to destroy the window when the transient parent is destroyed.
   * 
   * This is useful for dialogs that shouldn’t persist beyond the lifetime
   * of the main window they are associated with, for example.
   * 
   * @newin{4,8}
   * 
   * @param setting Whether to destroy the window with its transient parent.
   */
  void set_destroy_with_parent(bool setting =  true);
  
  /** Returns whether the window will be destroyed with its transient parent.
   * 
   * @return True if the window will be destroyed with its transient parent.
   */
  bool get_destroy_with_parent() const;

  /** Drop the internal reference GTK holds on toplevel windows.
   *
   * If this window is managed, this C++ wrapper will be deleted when the
   * underlying C instance is destroyed.
   *
   * After a call to %destroy(), don't call any method that accesses the
   * underlying C instance.
   *
   * If the C++ wrapper is deleted, the underlying C instance will be destroyed.
   * If the C instance is destroyed and the C++ wrapper is managed, the wrapper
   * will be deleted. The difference is in the order in which actions are taken.
   * That may or may not be important. If the C instance is destroyed before
   * the wrapper is deleted, C++ signal handlers can be called during the destruction.
   * For instance, if you connect to Gtk::Widget::signal_unrealize() or override
   * Gtk::Widget::on_unrealize(), those signal handlers can be called only if
   * the wrapper still exists when the signal is emitted.
   *
   * @newin{4,8}
   */
  void destroy();
  

  /** Sets whether clicking the close button will hide the window instead
   * of destroying it.
   * 
   * @param setting Whether to hide the window when it is closed.
   */
  void set_hide_on_close(bool setting =  true);
  
  /** Returns whether the window will be hidden instead of destroyed when the close
   * button is clicked.
   * 
   * @return True if the window will be hidden.
   */
  bool get_hide_on_close() const;

  
  /** Sets whether mnemonics are supposed to be visible.
   * 
   * This property is maintained by GTK based on user input,
   * and should not be set by applications.
   * 
   * @param setting The new value.
   */
  void set_mnemonics_visible(bool setting =  true);
  
  /** Gets whether mnemonics are supposed to be visible.
   * 
   * @return True if mnemonics are supposed to be visible
   * in this window.
   */
  bool get_mnemonics_visible() const;

  
  /** Sets whether “focus rectangles” are supposed to be visible.
   * 
   * This property is maintained by GTK based on user input,
   * and should not be set by applications.
   * 
   * @param setting The new value.
   */
  void set_focus_visible(bool setting =  true);
  
  /** Gets whether “focus rectangles” are supposed to be visible.
   * 
   * @return True if “focus rectangles” are supposed to be visible
   * in this window.
   */
  bool get_focus_visible() const;

  
  /** Sets whether the user can resize a window.
   * 
   * Windows are user resizable by default.
   * 
   * @param resizable True if the user can resize this window.
   */
  void set_resizable(bool resizable =  true);

  
  /** Gets whether the user can resize the window.
   * 
   * @return True if the user can resize the window.
   */
  bool get_resizable() const;

  
  /** Sets the display where the window is displayed.
   * 
   * If the window is already mapped, it will be unmapped,
   * and then remapped on the new display.
   * 
   * @param display A display.
   */
  void set_display(const Glib::RefPtr<Gdk::Display>& display);

  
  /** Returns whether the window is part of the current active toplevel.
   * 
   * The active toplevel is the window receiving keystrokes.
   * 
   * The return value is <tt>true</tt> if the window is active toplevel itself.
   * You might use this function if you wanted to draw a widget
   * differently in an active window from a widget in an inactive window.
   * 
   * @return True if the window part of the current active window.
   */
  bool is_active() const;

  
  /** Sets whether the window should be decorated.
   * 
   * By default, windows are decorated with a title bar, resize
   * controls, etc. Some window managers allow GTK to disable these
   * decorations, creating a borderless window. If you set the decorated
   * property to false using this function, GTK will do its best to
   * convince the window manager not to decorate the window. Depending on
   * the system, this function may not have any effect when called on a
   * window that is already visible, so you should call it before calling
   * Gtk::Widget::show().
   * 
   * On Windows, this function always works, since there’s no window manager
   * policy involved.
   * 
   * @param setting True to decorate the window.
   */
  void set_decorated(bool setting =  true);
  
  /** Returns whether the window has been set to have decorations.
   * 
   * @return True if the window has been set to have decorations.
   */
  bool get_decorated() const;

  
  /** Sets whether the window should be deletable.
   * 
   * By default, windows have a close button in the window frame.
   * Some  window managers allow GTK to disable this button. If you
   * set the deletable property to false using this function, GTK
   * will do its best to convince the window manager not to show a
   * close button. Depending on the system, this function may not
   * have any effect when called on a window that is already visible,
   * so you should call it before calling Gtk::Widget::show().
   * 
   * On Windows, this function always works, since there’s no window
   * manager policy involved.
   * 
   * @param setting True to decorate the window as deletable.
   */
  void set_deletable(bool setting =  true);
  
  /** Returns whether the window has been set to have a close button.
   * 
   * @return True if the window has been set to have a close button.
   */
  bool get_deletable() const;

  
  /** Sets the icon for the window from a named themed icon.
   * 
   * See the docs for Gtk::IconTheme for more details.
   * On some platforms, the window icon is not used at all.
   * 
   * Note that this has nothing to do with the WM_ICON_NAME
   * property which is mentioned in the ICCCM.
   * 
   * @param name The name of the themed icon.
   */
  void set_icon_name(const Glib::ustring& name);
  
  /** Returns the name of the themed icon for the window.
   * 
   * @return The icon name.
   */
  Glib::ustring get_icon_name() const;

  
  /** Sets an icon to be used as fallback.
   * 
   * The fallback icon is used for windows that
   * haven't had set_icon_name()
   * called on them.
   * 
   * @param name The name of the themed icon.
   */
  static void set_default_icon_name(const Glib::ustring& name);
  
  /** Returns the fallback icon name for windows.
   * 
   * The returned string is owned by GTK and should not
   * be modified. It is only valid until the next call to
   * set_default_icon_name().
   * 
   * @return The fallback icon name for windows.
   */
  static Glib::ustring get_default_icon_name();
  
  /** Sets whether the window should request startup notification.
   * 
   * By default, after showing the first window, GTK calls
   * Gdk::Toplevel::set_startup_id(). Call this function
   * to disable the automatic startup notification. You might do this
   * if your first window is a splash screen, and you want to delay
   * notification until after your real main window has been shown,
   * for example.
   * 
   * In that example, you would disable startup notification
   * temporarily, show your splash screen, then re-enable it so that
   * showing the main window would automatically result in notification.
   * 
   * @param setting True to automatically do startup notification.
   */
  static void set_auto_startup_notification(bool setting =  true);

  
  /** Sets a window modal or non-modal.
   * 
   * Modal windows prevent interaction with other windows in the same
   * application. To keep modal dialogs on top of main application windows,
   * use set_transient_for() to make the dialog transient
   * for the parent; most window managers will then disallow lowering the
   * dialog below the parent.
   * 
   * @param modal Whether the window is modal.
   */
  void set_modal(bool modal =  true);
  
  /** Returns whether the window is modal.
   * 
   * @return True if the window is set to be modal and
   * establishes a grab when shown.
   */
  bool get_modal() const;

  
  /** Returns the list of all existing toplevel windows.
   * 
   * If you want to iterate through the list and perform actions involving
   * callbacks that might destroy the widgets or add new ones, be aware that
   * the list of toplevels will change and emit the "items-changed" signal.
   * 
   * @return The list
   * of toplevel widgets.
   */
  static Glib::RefPtr<Gio::ListModel> get_toplevels();
 

  /** Returns the list of all existing toplevel windows.
   * 
   * The widgets in the list are not individually referenced.
   * If you want to iterate through the list and perform actions
   * involving callbacks that might destroy the widgets, you must
   * call `g_list_foreach (result, (GFunc)g_object_ref, <tt>nullptr</tt>)` first,
   * and then unref all the widgets afterwards.
   * 
   * @return List of
   * toplevel widgets.
   */
  static std::vector<Window*> list_toplevels();

  
  /** Presents a window to the user.
   * 
   * This may mean raising the window in the stacking order,
   * unminimizing it, moving it to the current desktop and/or
   * giving it the keyboard focus (possibly dependent on the user’s
   * platform, window manager and preferences).
   * 
   * If @a window is hidden, this function also makes it visible.
   */
  void present();
  
#ifndef GTKMM_DISABLE_DEPRECATED

  /** Presents a window to the user in response to an user interaction.
   * 
   * See present() for more details.
   * 
   * The timestamp should be gathered when the window was requested
   * to be shown (when clicking a link for example), rather than once
   * the window is ready to be shown.
   * 
   * Deprecated: 4.14: Use present()
   * 
   * @deprecated Use the present() overload without a parameter.
   * 
   * @param timestamp The timestamp of the user interaction (typically a
   * button or key press event) which triggered this call.
   */
  void present(guint32 timestamp);
#endif // GTKMM_DISABLE_DEPRECATED


  /** Asks to minimize the window.
   * 
   * Note that you shouldn’t assume the window is definitely minimized
   * afterward, because the windowing system might not support this
   * functionality; other entities (e.g. the user or the window manager)
   * could unminimize it again, or there may not be a window manager in
   * which case minimization isn’t possible, etc.
   * 
   * It’s permitted to call this function before showing a window,
   * in which case the window will be minimized before it ever appears
   * onscreen.
   * 
   * You can track result of this operation via the
   * Gdk::Toplevel::property_state() property.
   */
  void minimize();
  
  /** Asks to unminimize the window.
   * 
   * Note that you shouldn’t assume the window is definitely unminimized
   * afterward, because the windowing system might not support this
   * functionality; other entities (e.g. the user or the window manager)
   * could minimize it again, or there may not be a window manager in
   * which case minimization isn’t possible, etc.
   * 
   * You can track result of this operation via the
   * Gdk::Toplevel::property_state() property.
   */
  void unminimize();

  
  /** Asks to maximize the window, so that it fills the screen.
   * 
   * Note that you shouldn’t assume the window is definitely maximized
   * afterward, because other entities (e.g. the user or window manager)
   * could unmaximize it again, and not all window managers support
   * maximization.
   * 
   * It’s permitted to call this function before showing a window,
   * in which case the window will be maximized when it appears onscreen
   * initially.
   * 
   * If a window is not explicitly maximized or unmaximized before it is
   * shown, the initial state is at the window managers discretion. For
   * example, it might decide to maximize a window that almost fills the
   * screen.
   * 
   * You can track the result of this operation via the
   * Gdk::Toplevel::property_state() property, or by listening to
   * notifications on the property_maximized()
   * property.
   */
  void maximize();
  
  /** Asks to unmaximize the window.
   * 
   * Note that you shouldn’t assume the window is definitely unmaximized
   * afterward, because other entities (e.g. the user or window manager)
   * maximize it again, and not all window managers honor requests to
   * unmaximize.
   * 
   * If a window is not explicitly maximized or unmaximized before it is
   * shown, the initial state is at the window managers discretion. For
   * example, it might decide to maximize a window that almost fills the
   * screen.
   * 
   * You can track the result of this operation via the
   * Gdk::Toplevel::property_state() property, or by listening to
   * notifications on the property_maximized() property.
   */
  void unmaximize();

  
  /** Asks to place the window in the fullscreen state.
   * 
   * Note that you shouldn’t assume the window is definitely fullscreen
   * afterward, because other entities (e.g. the user or window manager)
   * unfullscreen it again, and not all window managers honor requests
   * to fullscreen windows.
   * 
   * If a window is not explicitly fullscreened or unfullscreened before
   * it is shown, the initial state is at the window managers discretion.
   * 
   * You can track the result of this operation via the
   * Gdk::Toplevel::property_state() property, or by listening to
   * notifications of the property_fullscreened() property.
   */
  void fullscreen();
  
  /** Asks to remove the fullscreen state for the window, and return to
   * its previous state.
   * 
   * Note that you shouldn’t assume the window is definitely not
   * fullscreen afterward, because other entities (e.g. the user or
   * window manager) could fullscreen it again, and not all window
   * managers honor requests to unfullscreen windows; normally the
   * window will end up restored to its normal state. Just don’t
   * write code that crashes if not.
   * 
   * If a window is not explicitly fullscreened or unfullscreened before
   * it is shown, the initial state is at the window managers discretion.
   * 
   * You can track the result of this operation via the
   * Gdk::Toplevel::property_state() property, or by listening to
   * notifications of the property_fullscreened() property.
   */
  void unfullscreen();
  
  /** Asks to place the window in the fullscreen state on the given monitor.
   * 
   * Note that you shouldn't assume the window is definitely fullscreen
   * afterward, or that the windowing system allows fullscreen windows on
   * any given monitor.
   * 
   * You can track the result of this operation via the
   * Gdk::Toplevel::property_state() property, or by listening to
   * notifications of the property_fullscreened() property.
   * 
   * @param monitor Which monitor to go fullscreen on.
   */
  void fullscreen_on_monitor(const Glib::RefPtr<Gdk::Monitor>& monitor);
  
  /** Requests that the window is closed.
   * 
   * This is similar to what happens when a window manager
   * close button is clicked.
   * 
   * This function can be used with close buttons in custom
   * titlebars.
   */
  void close();

  
  /** Sets the default size of a window.
   * 
   * The default size of a window is the size that will be used
   * if no other constraints apply.
   * 
   * The default size will be updated whenever the window is resized
   * to reflect the new size, unless the window is forced to a size,
   * like when it is maximized or fullscreened.
   * 
   * If the window’s minimum size request is larger than
   * the default, the default will be ignored.
   * 
   * Setting the default size to a value <= 0 will cause it to be
   * ignored and the natural size request will be used instead. It
   * is possible to do this while the window is showing to "reset"
   * it to its initial size.
   * 
   * Unlike Gtk::Widget::set_size_request(), which sets a size
   * request for a widget and thus would keep users from shrinking
   * the window, this function only sets the initial size, just as
   * if the user had resized the window themselves. Users can still
   * shrink the window again as they normally would. Setting a default
   * size of -1 means to use the “natural” default size (the size request
   * of the window).
   * 
   * If you use this function to reestablish a previously saved window size,
   * note that the appropriate size to save is the one returned by
   * get_default_size(). Using the window allocation
   * directly will not work in all circumstances and can lead to growing
   * or shrinking windows.
   * 
   * @param width Width in pixels, or -1 to unset the default width.
   * @param height Height in pixels, or -1 to unset the default height.
   */
  void set_default_size(int width, int height);

  
  /** Gets the default size of the window.
   * 
   * A value of 0 for the width or height indicates that a default
   * size has not been explicitly set for that dimension, so the
   * “natural” size of the window will be used.
   * 
   * This function is the recommended way for [saving window state
   * across restarts of applications](https://developer.gnome.org/documentation/tutorials/save-state.html).
   * 
   * @param width Location to store the default width.
   * @param height Location to store the default height.
   */
  void get_default_size(int& width, int& height) const;

  
  /** Returns the group for the window.
   * 
   * If the window has no group, then the default group is returned.
   * 
   * @return The window group for @a window
   * or the default group.
   */
  Glib::RefPtr<WindowGroup> get_group();
  
  /** Returns the group for the window.
   * 
   * If the window has no group, then the default group is returned.
   * 
   * @return The window group for @a window
   * or the default group.
   */
  Glib::RefPtr<const WindowGroup> get_group() const;

  
  /** Returns whether the window has an explicit window group.
   * 
   * @return True if @a window has an explicit window group.
   */
  bool has_group() const;

  
  /** Gets the application object associated with the window.
   * 
   * @return The application.
   */
  Glib::RefPtr<Application> get_application();
  
  /** Gets the application object associated with the window.
   * 
   * @return The application.
   */
  Glib::RefPtr<const Application> get_application() const;

  // Concerning the removal of a hidden window from the application, see
  // https://bugzilla.gnome.org/show_bug.cgi?id=639931 and Gtk::Widget_Class::hide_callback().
  
  /** Sets the Gtk::Application associated with the window.
   *
   * The application will be kept alive for at least as long as it has any windows
   * associated with it. (See Gio::Application::hold() for a way to keep it alive
   * without windows.)
   *
   * Normally, the connection between the application and the window will remain
   * until the window is closed (hidden), but you can explicitly remove it by
   * calling unset_application().
   *
   * This is equivalent to calling Gtk::Application::remove_window() and/or
   * Gtk::Application::add_window() on the old/new applications as relevant.
   *
   * @param application A Gtk::Application.
   */
  void set_application(const Glib::RefPtr<Application>& application);

  /** Unsets the Application associated with the window.
   * This could cause the application to exit if it is the application's last window.
   */
  void unset_application();

  
  /** Sets the child widget of the window.
   * 
   * @param child The child widget.
   */
  void set_child(Widget& child);
  void unset_child();
  
  /** Gets the child widget of the window.
   * 
   * @return The child widget of @a window.
   */
  Widget* get_child();
  
  /** Gets the child widget of the window.
   * 
   * @return The child widget of @a window.
   */
  const Widget* get_child() const;

  
  /** Sets a custom titlebar for the window.
   * 
   * A typical widget used here is Gtk::HeaderBar, as it
   * provides various features expected of a titlebar while allowing
   * the addition of child widgets to it.
   * 
   * If you set a custom titlebar, GTK will do its best to convince
   * the window manager not to put its own titlebar on the window.
   * Depending on the system, this function may not work for a window
   * that is already visible, so you set the titlebar before calling
   * Gtk::Widget::show().
   * 
   * @param titlebar The widget to use as titlebar.
   */
  void set_titlebar(Widget& titlebar);

  /** Unsets the titlebar.
   * @see set_titlebar()
   */
  void unset_titlebar();

  
  /** Returns the titlebar that has been set with
   * set_titlebar().
   * 
   * @return The titlebar.
   */
  Widget* get_titlebar();
  
  /** Returns the titlebar that has been set with
   * set_titlebar().
   * 
   * @return The titlebar.
   */
  const Widget* get_titlebar() const;

  
  /** Retrieves the current maximized state of the window.
   * 
   * Note that since maximization is ultimately handled by the window
   * manager and happens asynchronously to an application request, you
   * shouldn’t assume the return value of this function changing
   * immediately (or at all), as an effect of calling
   * maximize() or unmaximize().
   * 
   * If the window isn't yet mapped, the value returned will whether the
   * initial requested state is maximized.
   * 
   * @return Whether the window is maximized.
   */
  bool is_maximized() const;
  
  /** Retrieves the current fullscreen state of the window.
   * 
   * Note that since fullscreening is ultimately handled by the window
   * manager and happens asynchronously to an application request, you
   * shouldn’t assume the return value of this function changing
   * immediately (or at all), as an effect of calling
   * fullscreen() or unfullscreen().
   * 
   * If the window isn't yet mapped, the value returned will whether the
   * initial requested state is fullscreen.
   * 
   * @return Whether the window is fullscreen.
   */
  bool is_fullscreen() const;
  
  /** Retrieves the current suspended state of the window.
   * 
   * A window being suspended means it's currently not visible
   * to the user, for example by being on a inactive workspace,
   * minimized, obstructed.
   * 
   * @newin{4,12}
   * 
   * @return Whether the window is suspended.
   */
  bool is_suspended() const;

  
  /** Opens or closes the [interactive debugger](https://docs.gtk.org/gtk4/running.html#interactive-debugging).
   *
   * The debugger offers access to the widget hierarchy of the application
   * and to useful debugging tools.
   *
   * This function allows applications that already use
   * <kbd>Ctrl</kbd>+<kbd>Shift</kbd>+<kbd>I</kbd> or
   * <kbd>Ctrl</kbd>+<kbd>Shift</kbd>+<kbd>D</kbd> for their own key shortcuts
   * to add a different shortcut to open the Inspector.
   *
   * If you are not overriding the default key shortcuts for the Inspector,
   * you should not use this function.
   *
   * @newin{4,16}
   *
   * @param enable <tt>true</tt> to enable interactive debugging.
   */
  static void set_interactive_debugging(bool enable =  true);

  
  /** Sets whether this window should react to <kbd>F10</kbd>
   * presses by activating a menubar it contains.
   * 
   * @newin{4,2}
   * 
   * @param handle_menubar_accel True to make @a window handle <kbd>F10</kbd>.
   */
  void set_handle_menubar_accel(bool handle_menubar_accel);
  
  /** Returns whether this window reacts to <kbd>F10</kbd>
   * presses by activating a menubar it contains.
   * 
   * @newin{4,2}
   * 
   * @return True if the window handles <kbd>F10</kbd>.
   */
  bool get_handle_menubar_accel() const;

  
  /** Returns the gravity that is used when changing the window size programmatically.
   * 
   * @newin{4,20}
   * 
   * @return The gravity.
   */
  WindowGravity get_gravity() const;
  
  /** Sets the gravity that is used when changing the window size programmatically.
   * 
   * @newin{4,20}
   * 
   * @param gravity The new gravity.
   */
  void set_gravity(WindowGravity gravity);

  /** Used by Gtk::manage() and Gtk::make_managed(). You should not need to use this directly.
   * Overridden because a %Gtk::Window is not managed by a container.
   * Beginning with gtkmm 4.8, a %Gtk::Window can be managed. If managed, it's
   * deleted when its underlying C instance is destroyed.
   */
  void set_manage() override;

protected:
  void on_window_hide();

  //See comments in the implementations:
  void destroy_();
  void _release_c_instance();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_keys_changed().
  virtual void on_keys_changed();
  /// This is a default handler for the signal signal_close_request().
  virtual bool on_close_request();


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::Window
   */
  GTKMM_API
  Gtk::Window* wrap(GtkWindow* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_WINDOW_H */

