/* valaobjectcreationexpression.c generated by valac, the Vala compiler
 * generated from valaobjectcreationexpression.vala, do not modify */

/* valaobjectcreationexpression.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaObjectCreationExpressionPrivate {
	gboolean _is_yield_expression;
	gboolean _is_chainup;
	gboolean _struct_creation;
	ValaList* argument_list;
	ValaList* object_initializer;
	ValaDataType* _data_type;
	ValaMemberAccess* _member_name;
};

static gint ValaObjectCreationExpression_private_offset;
static gpointer vala_object_creation_expression_parent_class = NULL;
static ValaCallableExpressionIface * vala_object_creation_expression_vala_callable_expression_parent_iface = NULL;

static void vala_object_creation_expression_set_type_reference (ValaObjectCreationExpression* self,
                                                         ValaDataType* value);
static void vala_object_creation_expression_set_member_name (ValaObjectCreationExpression* self,
                                                      ValaMemberAccess* value);
static void vala_object_creation_expression_real_add_argument (ValaCallableExpression* base,
                                                        ValaExpression* arg);
static ValaList* vala_object_creation_expression_real_get_argument_list (ValaCallableExpression* base);
static void vala_object_creation_expression_real_accept (ValaCodeNode* base,
                                                  ValaCodeVisitor* visitor);
static void vala_object_creation_expression_real_accept_children (ValaCodeNode* base,
                                                           ValaCodeVisitor* visitor);
static void vala_object_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                              ValaExpression* old_node,
                                                              ValaExpression* new_node);
static gboolean vala_object_creation_expression_real_is_pure (ValaExpression* base);
static gboolean vala_object_creation_expression_real_is_accessible (ValaExpression* base,
                                                             ValaSymbol* sym);
static void vala_object_creation_expression_real_replace_type (ValaCodeNode* base,
                                                        ValaDataType* old_type,
                                                        ValaDataType* new_type);
static gboolean vala_object_creation_expression_real_check (ValaCodeNode* base,
                                                     ValaCodeContext* context);
static void vala_object_creation_expression_real_get_error_types (ValaCodeNode* base,
                                                           ValaCollection* collection,
                                                           ValaSourceReference* source_reference);
static void vala_object_creation_expression_real_emit (ValaCodeNode* base,
                                                ValaCodeGenerator* codegen);
static void vala_object_creation_expression_real_get_defined_variables (ValaCodeNode* base,
                                                                 ValaCollection* collection);
static void vala_object_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                              ValaCollection* collection);
static gchar* vala_object_creation_expression_real_to_string (ValaCodeNode* base);
static void vala_object_creation_expression_finalize (ValaCodeNode * obj);
static GType vala_object_creation_expression_get_type_once (void);

static inline gpointer
vala_object_creation_expression_get_instance_private (ValaObjectCreationExpression* self)
{
	return G_STRUCT_MEMBER_P (self, ValaObjectCreationExpression_private_offset);
}

ValaDataType*
vala_object_creation_expression_get_type_reference (ValaObjectCreationExpression* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_object_creation_expression_set_type_reference (ValaObjectCreationExpression* self,
                                                    ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_data_type);
	self->priv->_data_type = _tmp0_;
	_tmp1_ = self->priv->_data_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

static ValaExpression*
vala_object_creation_expression_real_get_call (ValaCallableExpression* base)
{
	ValaExpression* result;
	ValaObjectCreationExpression* self;
	ValaMemberAccess* _tmp0_;
	ValaMemberAccess* _tmp1_;
	self = (ValaObjectCreationExpression*) base;
	_tmp0_ = vala_object_creation_expression_get_member_name (self);
	_tmp1_ = _tmp0_;
	result = (ValaExpression*) _tmp1_;
	return result;
}

ValaMemberAccess*
vala_object_creation_expression_get_member_name (ValaObjectCreationExpression* self)
{
	ValaMemberAccess* result;
	ValaMemberAccess* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

static void
vala_object_creation_expression_set_member_name (ValaObjectCreationExpression* self,
                                                 ValaMemberAccess* value)
{
	ValaMemberAccess* _tmp0_;
	ValaMemberAccess* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
	_tmp1_ = self->priv->_member_name;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

static gboolean
vala_object_creation_expression_real_get_is_yield_expression (ValaCallableExpression* base)
{
	gboolean result;
	ValaObjectCreationExpression* self;
	self = (ValaObjectCreationExpression*) base;
	result = self->priv->_is_yield_expression;
	return result;
}

static void
vala_object_creation_expression_real_set_is_yield_expression (ValaCallableExpression* base,
                                                              gboolean value)
{
	ValaObjectCreationExpression* self;
	self = (ValaObjectCreationExpression*) base;
	self->priv->_is_yield_expression = value;
}

static gboolean
vala_object_creation_expression_real_get_is_chainup (ValaCallableExpression* base)
{
	gboolean result;
	ValaObjectCreationExpression* self;
	self = (ValaObjectCreationExpression*) base;
	result = self->priv->_is_chainup;
	return result;
}

static void
vala_object_creation_expression_real_set_is_chainup (ValaCallableExpression* base,
                                                     gboolean value)
{
	ValaObjectCreationExpression* self;
	self = (ValaObjectCreationExpression*) base;
	self->priv->_is_chainup = value;
}

gboolean
vala_object_creation_expression_get_struct_creation (ValaObjectCreationExpression* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_struct_creation;
	return result;
}

void
vala_object_creation_expression_set_struct_creation (ValaObjectCreationExpression* self,
                                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_struct_creation = value;
}

/**
 * Creates a new object creation expression.
 *
 * @param member_name      object type to create
 * @param source_reference reference to source code
 * @return                 newly created object creation expression
 */
ValaObjectCreationExpression*
vala_object_creation_expression_construct (GType object_type,
                                           ValaMemberAccess* member_name,
                                           ValaSourceReference* source_reference)
{
	ValaObjectCreationExpression* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaObjectCreationExpression*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_object_creation_expression_set_member_name (self, member_name);
	return self;
}

ValaObjectCreationExpression*
vala_object_creation_expression_new (ValaMemberAccess* member_name,
                                     ValaSourceReference* source_reference)
{
	return vala_object_creation_expression_construct (VALA_TYPE_OBJECT_CREATION_EXPRESSION, member_name, source_reference);
}

/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
static void
vala_object_creation_expression_real_add_argument (ValaCallableExpression* base,
                                                   ValaExpression* arg)
{
	ValaObjectCreationExpression * self;
	ValaList* _tmp0_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the argument list.
 *
 * @return argument list
 */
static ValaList*
vala_object_creation_expression_real_get_argument_list (ValaCallableExpression* base)
{
	ValaObjectCreationExpression * self;
	ValaList* _tmp0_;
	ValaList* result;
	self = (ValaObjectCreationExpression*) base;
	_tmp0_ = self->priv->argument_list;
	result = _tmp0_;
	return result;
}

/**
 * Appends the specified member initializer to the object initializer.
 *
 * @param init a member initializer
 */
void
vala_object_creation_expression_add_member_initializer (ValaObjectCreationExpression* self,
                                                        ValaMemberInitializer* init)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (init != NULL);
	_tmp0_ = self->priv->object_initializer;
	vala_collection_add ((ValaCollection*) _tmp0_, init);
	vala_code_node_set_parent_node ((ValaCodeNode*) init, (ValaCodeNode*) self);
}

/**
 * Returns the object initializer.
 *
 * @return member initializer list
 */
ValaList*
vala_object_creation_expression_get_object_initializer (ValaObjectCreationExpression* self)
{
	ValaList* _tmp0_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->object_initializer;
	result = _tmp0_;
	return result;
}

static void
vala_object_creation_expression_real_accept (ValaCodeNode* base,
                                             ValaCodeVisitor* visitor)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_object_creation_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_object_creation_expression_real_accept_children (ValaCodeNode* base,
                                                      ValaCodeVisitor* visitor)
{
	ValaObjectCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaMemberAccess* _tmp4_;
	ValaMemberAccess* _tmp5_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_object_creation_expression_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		_tmp2_ = vala_object_creation_expression_get_type_reference (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	_tmp4_ = vala_object_creation_expression_get_member_name (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaMemberAccess* _tmp6_;
		ValaMemberAccess* _tmp7_;
		_tmp6_ = vala_object_creation_expression_get_member_name (self);
		_tmp7_ = _tmp6_;
		vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp8_;
		gint _arg_size = 0;
		ValaList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _arg_index = 0;
		_tmp8_ = self->priv->argument_list;
		_arg_list = _tmp8_;
		_tmp9_ = _arg_list;
		_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_arg_size = _tmp11_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			ValaExpression* arg = NULL;
			ValaList* _tmp14_;
			gpointer _tmp15_;
			ValaExpression* _tmp16_;
			_arg_index = _arg_index + 1;
			_tmp12_ = _arg_index;
			_tmp13_ = _arg_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _arg_list;
			_tmp15_ = vala_list_get (_tmp14_, _arg_index);
			arg = (ValaExpression*) _tmp15_;
			_tmp16_ = arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp16_, visitor);
			_vala_code_node_unref0 (arg);
		}
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp17_;
		gint _init_size = 0;
		ValaList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _init_index = 0;
		_tmp17_ = self->priv->object_initializer;
		_init_list = _tmp17_;
		_tmp18_ = _init_list;
		_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_init_size = _tmp20_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp21_;
			gint _tmp22_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp23_;
			gpointer _tmp24_;
			ValaMemberInitializer* _tmp25_;
			_init_index = _init_index + 1;
			_tmp21_ = _init_index;
			_tmp22_ = _init_size;
			if (!(_tmp21_ < _tmp22_)) {
				break;
			}
			_tmp23_ = _init_list;
			_tmp24_ = vala_list_get (_tmp23_, _init_index);
			init = (ValaMemberInitializer*) _tmp24_;
			_tmp25_ = init;
			vala_code_node_accept ((ValaCodeNode*) _tmp25_, visitor);
			_vala_code_node_unref0 (init);
		}
	}
}

static void
vala_object_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                         ValaExpression* old_node,
                                                         ValaExpression* new_node)
{
	ValaObjectCreationExpression * self;
	gint index = 0;
	ValaList* _tmp0_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = self->priv->argument_list;
	index = vala_list_index_of (_tmp0_, old_node);
	if (index >= 0) {
		ValaList* _tmp1_;
		_tmp1_ = self->priv->argument_list;
		vala_list_set (_tmp1_, index, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}

static gboolean
vala_object_creation_expression_real_is_pure (ValaExpression* base)
{
	ValaObjectCreationExpression * self;
	gboolean result;
	self = (ValaObjectCreationExpression*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_object_creation_expression_real_is_accessible (ValaExpression* base,
                                                    ValaSymbol* sym)
{
	ValaObjectCreationExpression * self;
	gboolean _tmp0_ = FALSE;
	ValaMemberAccess* _tmp1_;
	ValaMemberAccess* _tmp2_;
	gboolean result;
	self = (ValaObjectCreationExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_object_creation_expression_get_member_name (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		ValaMemberAccess* _tmp3_;
		ValaMemberAccess* _tmp4_;
		_tmp3_ = vala_object_creation_expression_get_member_name (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = !vala_expression_is_accessible ((ValaExpression*) _tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp5_;
		gint _arg_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _arg_index = 0;
		_tmp5_ = self->priv->argument_list;
		_arg_list = _tmp5_;
		_tmp6_ = _arg_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_arg_size = _tmp8_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			ValaExpression* arg = NULL;
			ValaList* _tmp11_;
			gpointer _tmp12_;
			ValaExpression* _tmp13_;
			_arg_index = _arg_index + 1;
			_tmp9_ = _arg_index;
			_tmp10_ = _arg_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _arg_list;
			_tmp12_ = vala_list_get (_tmp11_, _arg_index);
			arg = (ValaExpression*) _tmp12_;
			_tmp13_ = arg;
			if (!vala_expression_is_accessible (_tmp13_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (arg);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp14_;
		gint _init_size = 0;
		ValaList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _init_index = 0;
		_tmp14_ = self->priv->object_initializer;
		_init_list = _tmp14_;
		_tmp15_ = _init_list;
		_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_init_size = _tmp17_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp18_;
			gint _tmp19_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp20_;
			gpointer _tmp21_;
			ValaMemberInitializer* _tmp22_;
			ValaExpression* _tmp23_;
			ValaExpression* _tmp24_;
			_init_index = _init_index + 1;
			_tmp18_ = _init_index;
			_tmp19_ = _init_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _init_list;
			_tmp21_ = vala_list_get (_tmp20_, _init_index);
			init = (ValaMemberInitializer*) _tmp21_;
			_tmp22_ = init;
			_tmp23_ = vala_member_initializer_get_initializer (_tmp22_);
			_tmp24_ = _tmp23_;
			if (!vala_expression_is_accessible (_tmp24_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (init);
				return result;
			}
			_vala_code_node_unref0 (init);
		}
	}
	result = TRUE;
	return result;
}

static void
vala_object_creation_expression_real_replace_type (ValaCodeNode* base,
                                                   ValaDataType* old_type,
                                                   ValaDataType* new_type)
{
	ValaObjectCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_object_creation_expression_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_object_creation_expression_set_type_reference (self, new_type);
	}
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gboolean
vala_object_creation_expression_real_check (ValaCodeNode* base,
                                            ValaCodeContext* context)
{
	ValaObjectCreationExpression * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaMemberAccess* _tmp4_;
	ValaMemberAccess* _tmp5_;
	ValaTypeSymbol* type = NULL;
	ValaMemberAccess* _tmp6_;
	ValaMemberAccess* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaSymbol* _tmp9_;
	ValaSymbol* constructor_sym = NULL;
	ValaMemberAccess* _tmp10_;
	ValaMemberAccess* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSymbol* _tmp14_;
	ValaSymbol* type_sym = NULL;
	ValaMemberAccess* _tmp15_;
	ValaMemberAccess* _tmp16_;
	ValaSymbol* _tmp17_;
	ValaSymbol* _tmp18_;
	ValaSymbol* _tmp19_;
	ValaList* type_args = NULL;
	ValaMemberAccess* _tmp20_;
	ValaMemberAccess* _tmp21_;
	ValaList* _tmp22_;
	ValaList* _tmp23_;
	ValaSymbol* _tmp24_;
	ValaSymbol* _tmp46_;
	ValaDataType* _tmp97_;
	ValaDataType* _tmp98_;
	ValaSemanticAnalyzer* _tmp99_;
	ValaSemanticAnalyzer* _tmp100_;
	ValaDataType* _tmp101_;
	ValaDataType* _tmp102_;
	ValaDataType* _tmp103_;
	ValaDataType* _tmp104_;
	ValaDataType* _tmp105_;
	ValaDataType* _tmp106_;
	ValaDataType* _tmp107_;
	ValaDataType* _tmp108_;
	ValaDataType* _tmp109_;
	ValaDataType* _tmp110_;
	ValaTypeSymbol* _tmp111_;
	gboolean _tmp214_ = FALSE;
	ValaSymbol* _tmp215_;
	ValaSymbol* _tmp216_;
	ValaSymbol* _tmp225_;
	ValaSymbol* _tmp226_;
	gboolean _tmp558_;
	gboolean _tmp559_;
	gboolean _tmp615_;
	gboolean _tmp616_;
	gboolean result;
	self = (ValaObjectCreationExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_object_creation_expression_get_member_name (self);
	_tmp5_ = _tmp4_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp5_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp6_ = vala_object_creation_expression_get_member_name (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == NULL) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp10_ = vala_object_creation_expression_get_member_name (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = _vala_code_node_ref0 (_tmp13_);
	constructor_sym = _tmp14_;
	_tmp15_ = vala_object_creation_expression_get_member_name (self);
	_tmp16_ = _tmp15_;
	_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = _vala_code_node_ref0 (_tmp18_);
	type_sym = _tmp19_;
	_tmp20_ = vala_object_creation_expression_get_member_name (self);
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_member_access_get_type_arguments (_tmp21_);
	_tmp23_ = _vala_iterable_ref0 (_tmp22_);
	type_args = _tmp23_;
	_tmp24_ = constructor_sym;
	if (VALA_IS_METHOD (_tmp24_)) {
		ValaSymbol* _tmp25_;
		ValaSymbol* _tmp26_;
		ValaSymbol* _tmp27_;
		ValaSymbol* _tmp28_;
		ValaMethod* constructor = NULL;
		ValaSymbol* _tmp29_;
		ValaMethod* _tmp30_;
		ValaSymbol* _tmp31_;
		ValaMethod* _tmp37_;
		ValaMemberAccess* ma = NULL;
		ValaMemberAccess* _tmp38_;
		ValaMemberAccess* _tmp39_;
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		ValaMemberAccess* _tmp42_;
		_tmp25_ = constructor_sym;
		_tmp26_ = vala_symbol_get_parent_symbol (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = _vala_code_node_ref0 (_tmp27_);
		_vala_code_node_unref0 (type_sym);
		type_sym = _tmp28_;
		_tmp29_ = constructor_sym;
		_tmp30_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, VALA_TYPE_METHOD, ValaMethod));
		constructor = _tmp30_;
		_tmp31_ = constructor_sym;
		if (!VALA_IS_CREATION_METHOD (_tmp31_)) {
			ValaSourceReference* _tmp32_;
			ValaSourceReference* _tmp33_;
			ValaMethod* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp33_ = _tmp32_;
			_tmp34_ = constructor;
			_tmp35_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp34_);
			_tmp36_ = _tmp35_;
			vala_report_error (_tmp33_, "`%s' is not a creation method", _tmp36_);
			_g_free0 (_tmp36_);
			result = FALSE;
			_vala_code_node_unref0 (constructor);
			_vala_iterable_unref0 (type_args);
			_vala_code_node_unref0 (type_sym);
			_vala_code_node_unref0 (constructor_sym);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp37_ = constructor;
		vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp37_);
		_tmp38_ = vala_object_creation_expression_get_member_name (self);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_member_access_get_inner (_tmp39_);
		_tmp41_ = _tmp40_;
		ma = VALA_IS_MEMBER_ACCESS (_tmp41_) ? ((ValaMemberAccess*) _tmp41_) : NULL;
		_tmp42_ = ma;
		if (_tmp42_ != NULL) {
			ValaMemberAccess* _tmp43_;
			ValaList* _tmp44_;
			ValaList* _tmp45_;
			_tmp43_ = ma;
			_tmp44_ = vala_member_access_get_type_arguments (_tmp43_);
			_tmp45_ = _vala_iterable_ref0 (_tmp44_);
			_vala_iterable_unref0 (type_args);
			type_args = _tmp45_;
		}
		_vala_code_node_unref0 (constructor);
	}
	_tmp46_ = type_sym;
	if (VALA_IS_CLASS (_tmp46_)) {
		ValaSymbol* _tmp47_;
		ValaTypeSymbol* _tmp48_;
		ValaTypeSymbol* _tmp49_;
		gboolean _tmp50_;
		gboolean _tmp51_;
		_tmp47_ = type_sym;
		_tmp48_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
		_vala_code_node_unref0 (type);
		type = _tmp48_;
		_tmp49_ = type;
		_tmp50_ = vala_class_get_is_error_base (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, VALA_TYPE_CLASS, ValaClass));
		_tmp51_ = _tmp50_;
		if (_tmp51_) {
			ValaSourceReference* _tmp52_;
			ValaSourceReference* _tmp53_;
			ValaErrorType* _tmp54_;
			ValaErrorType* _tmp55_;
			_tmp52_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_error_type_new (NULL, NULL, _tmp53_);
			_tmp55_ = _tmp54_;
			vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp55_);
			_vala_code_node_unref0 (_tmp55_);
		} else {
			ValaTypeSymbol* _tmp56_;
			ValaSourceReference* _tmp57_;
			ValaSourceReference* _tmp58_;
			ValaObjectType* _tmp59_;
			ValaObjectType* _tmp60_;
			_tmp56_ = type;
			_tmp57_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp58_ = _tmp57_;
			_tmp59_ = vala_object_type_new ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, VALA_TYPE_CLASS, ValaClass), _tmp58_);
			_tmp60_ = _tmp59_;
			vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp60_);
			_vala_code_node_unref0 (_tmp60_);
		}
	} else {
		ValaSymbol* _tmp61_;
		_tmp61_ = type_sym;
		if (VALA_IS_STRUCT (_tmp61_)) {
			ValaSymbol* _tmp62_;
			ValaTypeSymbol* _tmp63_;
			ValaTypeSymbol* _tmp64_;
			ValaSourceReference* _tmp65_;
			ValaSourceReference* _tmp66_;
			ValaStructValueType* _tmp67_;
			ValaStructValueType* _tmp68_;
			_tmp62_ = type_sym;
			_tmp63_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
			_vala_code_node_unref0 (type);
			type = _tmp63_;
			_tmp64_ = type;
			_tmp65_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp66_ = _tmp65_;
			_tmp67_ = vala_struct_value_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, VALA_TYPE_STRUCT, ValaStruct), _tmp66_);
			_tmp68_ = _tmp67_;
			vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp68_);
			_vala_code_node_unref0 (_tmp68_);
		} else {
			ValaSymbol* _tmp69_;
			_tmp69_ = type_sym;
			if (VALA_IS_ERROR_CODE (_tmp69_)) {
				ValaSymbol* _tmp70_;
				ValaTypeSymbol* _tmp71_;
				ValaSymbol* _tmp72_;
				ValaSymbol* _tmp73_;
				ValaSymbol* _tmp74_;
				ValaSymbol* _tmp75_;
				ValaSourceReference* _tmp76_;
				ValaSourceReference* _tmp77_;
				ValaErrorType* _tmp78_;
				ValaErrorType* _tmp79_;
				ValaSymbol* _tmp80_;
				_tmp70_ = type_sym;
				_tmp71_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
				_vala_code_node_unref0 (type);
				type = _tmp71_;
				_tmp72_ = type_sym;
				_tmp73_ = vala_symbol_get_parent_symbol (_tmp72_);
				_tmp74_ = _tmp73_;
				_tmp75_ = type_sym;
				_tmp76_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp77_ = _tmp76_;
				_tmp78_ = vala_error_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp74_, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain), G_TYPE_CHECK_INSTANCE_CAST (_tmp75_, VALA_TYPE_ERROR_CODE, ValaErrorCode), _tmp77_);
				_tmp79_ = _tmp78_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp79_);
				_vala_code_node_unref0 (_tmp79_);
				_tmp80_ = type_sym;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp80_);
			} else {
				ValaSourceReference* _tmp81_;
				ValaSourceReference* _tmp82_;
				ValaSymbol* _tmp83_;
				gchar* _tmp84_;
				gchar* _tmp85_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp81_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp82_ = _tmp81_;
				_tmp83_ = type_sym;
				_tmp84_ = vala_symbol_get_full_name (_tmp83_);
				_tmp85_ = _tmp84_;
				vala_report_error (_tmp82_, "`%s' is not a class, struct, or error code", _tmp85_);
				_g_free0 (_tmp85_);
				result = FALSE;
				_vala_iterable_unref0 (type_args);
				_vala_code_node_unref0 (type_sym);
				_vala_code_node_unref0 (constructor_sym);
				_vala_code_node_unref0 (type);
				return result;
			}
		}
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp86_;
		gint _type_arg_size = 0;
		ValaList* _tmp87_;
		gint _tmp88_;
		gint _tmp89_;
		gint _type_arg_index = 0;
		_tmp86_ = type_args;
		_type_arg_list = _tmp86_;
		_tmp87_ = _type_arg_list;
		_tmp88_ = vala_collection_get_size ((ValaCollection*) _tmp87_);
		_tmp89_ = _tmp88_;
		_type_arg_size = _tmp89_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp90_;
			gint _tmp91_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp92_;
			gpointer _tmp93_;
			ValaDataType* _tmp94_;
			ValaDataType* _tmp95_;
			ValaDataType* _tmp96_;
			_type_arg_index = _type_arg_index + 1;
			_tmp90_ = _type_arg_index;
			_tmp91_ = _type_arg_size;
			if (!(_tmp90_ < _tmp91_)) {
				break;
			}
			_tmp92_ = _type_arg_list;
			_tmp93_ = vala_list_get (_tmp92_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp93_;
			_tmp94_ = vala_object_creation_expression_get_type_reference (self);
			_tmp95_ = _tmp94_;
			_tmp96_ = type_arg;
			vala_data_type_add_type_argument (_tmp95_, _tmp96_);
			_vala_code_node_unref0 (type_arg);
		}
	}
	_tmp97_ = vala_object_creation_expression_get_type_reference (self);
	_tmp98_ = _tmp97_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp98_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_iterable_unref0 (type_args);
		_vala_code_node_unref0 (type_sym);
		_vala_code_node_unref0 (constructor_sym);
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp99_ = vala_code_context_get_analyzer (context);
	_tmp100_ = _tmp99_;
	_tmp101_ = vala_object_creation_expression_get_type_reference (self);
	_tmp102_ = _tmp101_;
	vala_semantic_analyzer_check_type (_tmp100_, _tmp102_);
	_tmp103_ = vala_object_creation_expression_get_type_reference (self);
	_tmp104_ = _tmp103_;
	if (!vala_data_type_check_type_arguments (_tmp104_, context, FALSE)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_iterable_unref0 (type_args);
		_vala_code_node_unref0 (type_sym);
		_vala_code_node_unref0 (constructor_sym);
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp105_ = vala_object_creation_expression_get_type_reference (self);
	_tmp106_ = _tmp105_;
	_tmp107_ = vala_data_type_copy (_tmp106_);
	_tmp108_ = _tmp107_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp108_);
	_vala_code_node_unref0 (_tmp108_);
	_tmp109_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp110_ = _tmp109_;
	vala_data_type_set_value_owned (_tmp110_, TRUE);
	_tmp111_ = type;
	if (VALA_IS_CLASS (_tmp111_)) {
		ValaClass* cl = NULL;
		ValaTypeSymbol* _tmp112_;
		ValaClass* _tmp113_;
		gboolean _tmp114_;
		ValaClass* _tmp117_;
		gboolean _tmp118_;
		gboolean _tmp119_;
		ValaSymbol* _tmp125_;
		ValaSymbol* _tmp126_;
		gboolean _tmp145_ = FALSE;
		ValaSymbol* _tmp146_;
		ValaSymbol* _tmp147_;
		_tmp112_ = type;
		_tmp113_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp112_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp113_;
		_tmp114_ = self->priv->_struct_creation;
		if (_tmp114_) {
			ValaSourceReference* _tmp115_;
			ValaSourceReference* _tmp116_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp115_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp116_ = _tmp115_;
			vala_report_error (_tmp116_, "syntax error, use `new' to create new objects");
			result = FALSE;
			_vala_code_node_unref0 (cl);
			_vala_iterable_unref0 (type_args);
			_vala_code_node_unref0 (type_sym);
			_vala_code_node_unref0 (constructor_sym);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp117_ = cl;
		_tmp118_ = vala_class_get_is_abstract (_tmp117_);
		_tmp119_ = _tmp118_;
		if (_tmp119_) {
			ValaSourceReference* _tmp120_;
			ValaSourceReference* _tmp121_;
			ValaClass* _tmp122_;
			gchar* _tmp123_;
			gchar* _tmp124_;
			vala_expression_set_value_type ((ValaExpression*) self, NULL);
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp120_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp121_ = _tmp120_;
			_tmp122_ = cl;
			_tmp123_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp122_);
			_tmp124_ = _tmp123_;
			vala_report_error (_tmp121_, "Can't create instance of abstract class `%s'", _tmp124_);
			_g_free0 (_tmp124_);
			result = FALSE;
			_vala_code_node_unref0 (cl);
			_vala_iterable_unref0 (type_args);
			_vala_code_node_unref0 (type_sym);
			_vala_code_node_unref0 (constructor_sym);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp125_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp126_ = _tmp125_;
		if (_tmp126_ == NULL) {
			ValaClass* _tmp127_;
			ValaCreationMethod* _tmp128_;
			ValaCreationMethod* _tmp129_;
			ValaSymbol* _tmp130_;
			ValaSymbol* _tmp131_;
			ValaSymbol* _tmp137_;
			ValaSymbol* _tmp138_;
			ValaSymbol* _tmp139_;
			ValaSymbol* _tmp140_;
			ValaVersionAttribute* _tmp141_;
			ValaVersionAttribute* _tmp142_;
			ValaSourceReference* _tmp143_;
			ValaSourceReference* _tmp144_;
			_tmp127_ = cl;
			_tmp128_ = vala_class_get_default_construction_method (_tmp127_);
			_tmp129_ = _tmp128_;
			vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp129_);
			_tmp130_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp131_ = _tmp130_;
			if (_tmp131_ == NULL) {
				ValaSourceReference* _tmp132_;
				ValaSourceReference* _tmp133_;
				ValaClass* _tmp134_;
				gchar* _tmp135_;
				gchar* _tmp136_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp132_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp133_ = _tmp132_;
				_tmp134_ = cl;
				_tmp135_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp134_);
				_tmp136_ = _tmp135_;
				vala_report_error (_tmp133_, "`%s' does not have a default constructor", _tmp136_);
				_g_free0 (_tmp136_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_iterable_unref0 (type_args);
				_vala_code_node_unref0 (type_sym);
				_vala_code_node_unref0 (constructor_sym);
				_vala_code_node_unref0 (type);
				return result;
			}
			_tmp137_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp138_ = _tmp137_;
			vala_symbol_set_used (_tmp138_, TRUE);
			_tmp139_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp140_ = _tmp139_;
			_tmp141_ = vala_symbol_get_version (_tmp140_);
			_tmp142_ = _tmp141_;
			_tmp143_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp144_ = _tmp143_;
			vala_version_attribute_check (_tmp142_, context, _tmp144_);
		}
		_tmp146_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp147_ = _tmp146_;
		if (_tmp147_ != NULL) {
			gboolean _tmp148_ = FALSE;
			ValaSymbol* _tmp149_;
			ValaSymbol* _tmp150_;
			ValaSymbolAccessibility _tmp151_;
			ValaSymbolAccessibility _tmp152_;
			_tmp149_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp150_ = _tmp149_;
			_tmp151_ = vala_symbol_get_access (_tmp150_);
			_tmp152_ = _tmp151_;
			if (_tmp152_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
				_tmp148_ = TRUE;
			} else {
				ValaSymbol* _tmp153_;
				ValaSymbol* _tmp154_;
				ValaSymbolAccessibility _tmp155_;
				ValaSymbolAccessibility _tmp156_;
				_tmp153_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp154_ = _tmp153_;
				_tmp155_ = vala_symbol_get_access (_tmp154_);
				_tmp156_ = _tmp155_;
				_tmp148_ = _tmp156_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED;
			}
			_tmp145_ = _tmp148_;
		} else {
			_tmp145_ = FALSE;
		}
		if (_tmp145_) {
			gboolean in_target_type = FALSE;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp157_;
				ValaSemanticAnalyzer* _tmp158_;
				ValaSymbol* _tmp159_;
				ValaSymbol* _tmp160_;
				ValaSymbol* _tmp161_;
				_tmp157_ = vala_code_context_get_analyzer (context);
				_tmp158_ = _tmp157_;
				_tmp159_ = vala_semantic_analyzer_get_current_symbol (_tmp158_);
				_tmp160_ = _tmp159_;
				_tmp161_ = _vala_code_node_ref0 (_tmp160_);
				this_symbol = _tmp161_;
				{
					gboolean _tmp162_ = FALSE;
					_tmp162_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp167_;
						ValaSymbol* _tmp168_;
						ValaClass* _tmp169_;
						if (!_tmp162_) {
							ValaSymbol* _tmp163_;
							ValaSymbol* _tmp164_;
							ValaSymbol* _tmp165_;
							ValaSymbol* _tmp166_;
							_tmp163_ = this_symbol;
							_tmp164_ = vala_symbol_get_parent_symbol (_tmp163_);
							_tmp165_ = _tmp164_;
							_tmp166_ = _vala_code_node_ref0 (_tmp165_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp166_;
						}
						_tmp162_ = FALSE;
						_tmp167_ = this_symbol;
						if (!(_tmp167_ != NULL)) {
							break;
						}
						_tmp168_ = this_symbol;
						_tmp169_ = cl;
						if (_tmp168_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp169_, VALA_TYPE_SYMBOL, ValaSymbol)) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp170_;
				ValaSourceReference* _tmp171_;
				ValaSymbol* _tmp172_;
				ValaSymbol* _tmp173_;
				gchar* _tmp174_;
				gchar* _tmp175_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp170_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp171_ = _tmp170_;
				_tmp172_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp173_ = _tmp172_;
				_tmp174_ = vala_symbol_get_full_name (_tmp173_);
				_tmp175_ = _tmp174_;
				vala_report_error (_tmp171_, "Access to non-public constructor `%s' denied", _tmp175_);
				_g_free0 (_tmp175_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_iterable_unref0 (type_args);
				_vala_code_node_unref0 (type_sym);
				_vala_code_node_unref0 (constructor_sym);
				_vala_code_node_unref0 (type);
				return result;
			}
		}
		while (TRUE) {
			ValaClass* _tmp176_;
			ValaClass* _tmp177_;
			ValaClass* _tmp180_;
			ValaClass* _tmp181_;
			ValaClass* _tmp182_;
			ValaClass* _tmp183_;
			_tmp176_ = cl;
			if (!(_tmp176_ != NULL)) {
				break;
			}
			_tmp177_ = cl;
			if (vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp177_, "CCode", "ref_sink_function")) {
				ValaDataType* _tmp178_;
				ValaDataType* _tmp179_;
				_tmp178_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp179_ = _tmp178_;
				vala_data_type_set_floating_reference (_tmp179_, TRUE);
				break;
			}
			_tmp180_ = cl;
			_tmp181_ = vala_class_get_base_class (_tmp180_);
			_tmp182_ = _tmp181_;
			_tmp183_ = _vala_code_node_ref0 (_tmp182_);
			_vala_code_node_unref0 (cl);
			cl = _tmp183_;
		}
		_vala_code_node_unref0 (cl);
	} else {
		ValaTypeSymbol* _tmp184_;
		_tmp184_ = type;
		if (VALA_IS_STRUCT (_tmp184_)) {
			ValaStruct* st = NULL;
			ValaTypeSymbol* _tmp185_;
			ValaStruct* _tmp186_;
			gboolean _tmp187_ = FALSE;
			gboolean _tmp188_;
			ValaSymbol* _tmp193_;
			ValaSymbol* _tmp194_;
			gboolean _tmp198_ = FALSE;
			gboolean _tmp199_ = FALSE;
			gboolean _tmp200_ = FALSE;
			ValaProfile _tmp201_;
			ValaProfile _tmp202_;
			_tmp185_ = type;
			_tmp186_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp185_, VALA_TYPE_STRUCT, ValaStruct));
			st = _tmp186_;
			_tmp188_ = self->priv->_struct_creation;
			if (!_tmp188_) {
				gboolean _tmp189_;
				gboolean _tmp190_;
				_tmp189_ = vala_code_context_get_deprecated (context);
				_tmp190_ = _tmp189_;
				_tmp187_ = !_tmp190_;
			} else {
				_tmp187_ = FALSE;
			}
			if (_tmp187_) {
				ValaSourceReference* _tmp191_;
				ValaSourceReference* _tmp192_;
				_tmp191_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp192_ = _tmp191_;
				vala_report_warning (_tmp192_, "deprecated syntax, don't use `new' to initialize structs");
			}
			_tmp193_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp194_ = _tmp193_;
			if (_tmp194_ == NULL) {
				ValaStruct* _tmp195_;
				ValaCreationMethod* _tmp196_;
				ValaCreationMethod* _tmp197_;
				_tmp195_ = st;
				_tmp196_ = vala_struct_get_default_construction_method (_tmp195_);
				_tmp197_ = _tmp196_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp197_);
			}
			_tmp201_ = vala_code_context_get_profile (context);
			_tmp202_ = _tmp201_;
			if (_tmp202_ == VALA_PROFILE_GOBJECT) {
				ValaStruct* _tmp203_;
				_tmp203_ = st;
				_tmp200_ = vala_struct_is_simple_type (_tmp203_);
			} else {
				_tmp200_ = FALSE;
			}
			if (_tmp200_) {
				ValaSymbol* _tmp204_;
				ValaSymbol* _tmp205_;
				_tmp204_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp205_ = _tmp204_;
				_tmp199_ = _tmp205_ == NULL;
			} else {
				_tmp199_ = FALSE;
			}
			if (_tmp199_) {
				ValaList* _tmp206_;
				gint _tmp207_;
				gint _tmp208_;
				_tmp206_ = self->priv->object_initializer;
				_tmp207_ = vala_collection_get_size ((ValaCollection*) _tmp206_);
				_tmp208_ = _tmp207_;
				_tmp198_ = _tmp208_ == 0;
			} else {
				_tmp198_ = FALSE;
			}
			if (_tmp198_) {
				ValaSourceReference* _tmp209_;
				ValaSourceReference* _tmp210_;
				ValaStruct* _tmp211_;
				gchar* _tmp212_;
				gchar* _tmp213_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp209_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp210_ = _tmp209_;
				_tmp211_ = st;
				_tmp212_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp211_);
				_tmp213_ = _tmp212_;
				vala_report_error (_tmp210_, "`%s' does not have a default constructor", _tmp213_);
				_g_free0 (_tmp213_);
				result = FALSE;
				_vala_code_node_unref0 (st);
				_vala_iterable_unref0 (type_args);
				_vala_code_node_unref0 (type_sym);
				_vala_code_node_unref0 (constructor_sym);
				_vala_code_node_unref0 (type);
				return result;
			}
			_vala_code_node_unref0 (st);
		}
	}
	_tmp215_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp216_ = _tmp215_;
	if (_tmp216_ == NULL) {
		ValaList* _tmp217_;
		gint _tmp218_;
		gint _tmp219_;
		_tmp217_ = self->priv->argument_list;
		_tmp218_ = vala_collection_get_size ((ValaCollection*) _tmp217_);
		_tmp219_ = _tmp218_;
		_tmp214_ = _tmp219_ != 0;
	} else {
		_tmp214_ = FALSE;
	}
	if (_tmp214_) {
		ValaSourceReference* _tmp220_;
		ValaSourceReference* _tmp221_;
		ValaTypeSymbol* _tmp222_;
		gchar* _tmp223_;
		gchar* _tmp224_;
		vala_expression_set_value_type ((ValaExpression*) self, NULL);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp220_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp221_ = _tmp220_;
		_tmp222_ = type;
		_tmp223_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp222_);
		_tmp224_ = _tmp223_;
		vala_report_error (_tmp221_, "No arguments allowed when constructing type `%s'", _tmp224_);
		_g_free0 (_tmp224_);
		result = FALSE;
		_vala_iterable_unref0 (type_args);
		_vala_code_node_unref0 (type_sym);
		_vala_code_node_unref0 (constructor_sym);
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp225_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp226_ = _tmp225_;
	if (VALA_IS_METHOD (_tmp226_)) {
		ValaMethod* m = NULL;
		ValaSymbol* _tmp227_;
		ValaSymbol* _tmp228_;
		ValaMethod* _tmp229_;
		gboolean _tmp230_;
		gboolean _tmp231_;
		ValaExpression* last_arg = NULL;
		ValaIterator* arg_it = NULL;
		ValaList* _tmp256_;
		ValaIterator* _tmp257_;
		ValaMethod* _tmp308_;
		gboolean _tmp309_;
		gboolean _tmp310_;
		ValaSemanticAnalyzer* _tmp373_;
		ValaSemanticAnalyzer* _tmp374_;
		ValaMethod* _tmp375_;
		ValaMethodType* _tmp376_;
		ValaMethodType* _tmp377_;
		ValaMethod* _tmp378_;
		ValaList* _tmp379_;
		ValaList* _tmp380_;
		_tmp227_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp228_ = _tmp227_;
		_tmp229_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp228_, VALA_TYPE_METHOD, ValaMethod));
		m = _tmp229_;
		_tmp230_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
		_tmp231_ = _tmp230_;
		if (_tmp231_) {
			ValaMethod* _tmp232_;
			gboolean _tmp233_;
			gboolean _tmp234_;
			gboolean _tmp237_ = FALSE;
			ValaSemanticAnalyzer* _tmp238_;
			ValaSemanticAnalyzer* _tmp239_;
			ValaMethod* _tmp240_;
			ValaMethod* _tmp241_;
			_tmp232_ = m;
			_tmp233_ = vala_method_get_coroutine (_tmp232_);
			_tmp234_ = _tmp233_;
			if (!_tmp234_) {
				ValaSourceReference* _tmp235_;
				ValaSourceReference* _tmp236_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp235_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp236_ = _tmp235_;
				vala_report_error (_tmp236_, "yield expression requires async method");
			}
			_tmp238_ = vala_code_context_get_analyzer (context);
			_tmp239_ = _tmp238_;
			_tmp240_ = vala_semantic_analyzer_get_current_method (_tmp239_);
			_tmp241_ = _tmp240_;
			if (_tmp241_ == NULL) {
				_tmp237_ = TRUE;
			} else {
				ValaSemanticAnalyzer* _tmp242_;
				ValaSemanticAnalyzer* _tmp243_;
				ValaMethod* _tmp244_;
				ValaMethod* _tmp245_;
				gboolean _tmp246_;
				gboolean _tmp247_;
				_tmp242_ = vala_code_context_get_analyzer (context);
				_tmp243_ = _tmp242_;
				_tmp244_ = vala_semantic_analyzer_get_current_method (_tmp243_);
				_tmp245_ = _tmp244_;
				_tmp246_ = vala_method_get_coroutine (_tmp245_);
				_tmp247_ = _tmp246_;
				_tmp237_ = !_tmp247_;
			}
			if (_tmp237_) {
				ValaSourceReference* _tmp248_;
				ValaSourceReference* _tmp249_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp248_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp249_ = _tmp248_;
				vala_report_error (_tmp249_, "yield expression not available outside async method");
			}
		} else {
			ValaMethod* _tmp250_;
			_tmp250_ = m;
			if (VALA_IS_CREATION_METHOD (_tmp250_)) {
				ValaMethod* _tmp251_;
				gboolean _tmp252_;
				gboolean _tmp253_;
				_tmp251_ = m;
				_tmp252_ = vala_method_get_coroutine (_tmp251_);
				_tmp253_ = _tmp252_;
				if (_tmp253_) {
					ValaSourceReference* _tmp254_;
					ValaSourceReference* _tmp255_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp254_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp255_ = _tmp254_;
					vala_report_error (_tmp255_, "missing `yield' before async creation expression");
				}
			}
		}
		last_arg = NULL;
		_tmp256_ = self->priv->argument_list;
		_tmp257_ = vala_iterable_iterator ((ValaIterable*) _tmp256_);
		arg_it = _tmp257_;
		{
			ValaList* _param_list = NULL;
			ValaMethod* _tmp258_;
			ValaList* _tmp259_;
			gint _param_size = 0;
			ValaList* _tmp260_;
			gint _tmp261_;
			gint _tmp262_;
			gint _param_index = 0;
			_tmp258_ = m;
			_tmp259_ = vala_callable_get_parameters ((ValaCallable*) _tmp258_);
			_param_list = _tmp259_;
			_tmp260_ = _param_list;
			_tmp261_ = vala_collection_get_size ((ValaCollection*) _tmp260_);
			_tmp262_ = _tmp261_;
			_param_size = _tmp262_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp263_;
				gint _tmp264_;
				ValaParameter* param = NULL;
				ValaList* _tmp265_;
				gpointer _tmp266_;
				ValaParameter* _tmp267_;
				ValaParameter* _tmp268_;
				gboolean _tmp269_;
				gboolean _tmp270_;
				ValaParameter* _tmp271_;
				gboolean _tmp272_;
				gboolean _tmp273_;
				ValaIterator* _tmp291_;
				_param_index = _param_index + 1;
				_tmp263_ = _param_index;
				_tmp264_ = _param_size;
				if (!(_tmp263_ < _tmp264_)) {
					break;
				}
				_tmp265_ = _param_list;
				_tmp266_ = vala_list_get (_tmp265_, _param_index);
				param = (ValaParameter*) _tmp266_;
				_tmp267_ = param;
				if (!vala_code_node_check ((ValaCodeNode*) _tmp267_, context)) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
				_tmp268_ = param;
				_tmp269_ = vala_parameter_get_ellipsis (_tmp268_);
				_tmp270_ = _tmp269_;
				if (_tmp270_) {
					_vala_code_node_unref0 (param);
					break;
				}
				_tmp271_ = param;
				_tmp272_ = vala_parameter_get_params_array (_tmp271_);
				_tmp273_ = _tmp272_;
				if (_tmp273_) {
					ValaArrayType* array_type = NULL;
					ValaParameter* _tmp274_;
					ValaDataType* _tmp275_;
					ValaDataType* _tmp276_;
					ValaArrayType* _tmp277_;
					_tmp274_ = param;
					_tmp275_ = vala_variable_get_variable_type ((ValaVariable*) _tmp274_);
					_tmp276_ = _tmp275_;
					_tmp277_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp276_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					array_type = _tmp277_;
					while (TRUE) {
						ValaIterator* _tmp278_;
						ValaExpression* arg = NULL;
						ValaIterator* _tmp279_;
						gpointer _tmp280_;
						ValaExpression* _tmp281_;
						ValaArrayType* _tmp282_;
						ValaDataType* _tmp283_;
						ValaDataType* _tmp284_;
						ValaExpression* _tmp285_;
						ValaDataType* _tmp286_;
						ValaDataType* _tmp287_;
						ValaArrayType* _tmp288_;
						gboolean _tmp289_;
						gboolean _tmp290_;
						_tmp278_ = arg_it;
						if (!vala_iterator_next (_tmp278_)) {
							break;
						}
						_tmp279_ = arg_it;
						_tmp280_ = vala_iterator_get (_tmp279_);
						arg = (ValaExpression*) _tmp280_;
						_tmp281_ = arg;
						_tmp282_ = array_type;
						_tmp283_ = vala_array_type_get_element_type (_tmp282_);
						_tmp284_ = _tmp283_;
						vala_expression_set_target_type (_tmp281_, _tmp284_);
						_tmp285_ = arg;
						_tmp286_ = vala_expression_get_target_type (_tmp285_);
						_tmp287_ = _tmp286_;
						_tmp288_ = array_type;
						_tmp289_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp288_);
						_tmp290_ = _tmp289_;
						vala_data_type_set_value_owned (_tmp287_, _tmp290_);
						_vala_code_node_unref0 (arg);
					}
					_vala_code_node_unref0 (array_type);
					_vala_code_node_unref0 (param);
					break;
				}
				_tmp291_ = arg_it;
				if (vala_iterator_next (_tmp291_)) {
					ValaExpression* arg = NULL;
					ValaIterator* _tmp292_;
					gpointer _tmp293_;
					ValaExpression* _tmp294_;
					ValaParameter* _tmp295_;
					ValaDataType* _tmp296_;
					ValaDataType* _tmp297_;
					ValaExpression* _tmp298_;
					ValaExpression* _tmp299_;
					ValaDataType* _tmp300_;
					ValaDataType* _tmp301_;
					ValaDataType* _tmp302_;
					ValaDataType* _tmp303_;
					ValaDataType* _tmp304_;
					ValaDataType* _tmp305_;
					ValaExpression* _tmp306_;
					ValaExpression* _tmp307_;
					_tmp292_ = arg_it;
					_tmp293_ = vala_iterator_get (_tmp292_);
					arg = (ValaExpression*) _tmp293_;
					_tmp294_ = arg;
					_tmp295_ = param;
					_tmp296_ = vala_variable_get_variable_type ((ValaVariable*) _tmp295_);
					_tmp297_ = _tmp296_;
					vala_expression_set_formal_target_type (_tmp294_, _tmp297_);
					_tmp298_ = arg;
					_tmp299_ = arg;
					_tmp300_ = vala_expression_get_formal_target_type (_tmp299_);
					_tmp301_ = _tmp300_;
					_tmp302_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp303_ = _tmp302_;
					_tmp304_ = vala_data_type_get_actual_type (_tmp301_, _tmp303_, NULL, (ValaCodeNode*) self);
					_tmp305_ = _tmp304_;
					vala_expression_set_target_type (_tmp298_, _tmp305_);
					_vala_code_node_unref0 (_tmp305_);
					_tmp306_ = arg;
					_tmp307_ = _vala_code_node_ref0 (_tmp306_);
					_vala_code_node_unref0 (last_arg);
					last_arg = _tmp307_;
					_vala_code_node_unref0 (arg);
				}
				_vala_code_node_unref0 (param);
			}
		}
		_tmp308_ = m;
		_tmp309_ = vala_method_get_printf_format (_tmp308_);
		_tmp310_ = _tmp309_;
		if (_tmp310_) {
			ValaStringLiteral* format_literal = NULL;
			ValaExpression* _tmp311_;
			ValaStringLiteral* _tmp355_;
			format_literal = NULL;
			_tmp311_ = last_arg;
			if (VALA_IS_NULL_LITERAL (_tmp311_)) {
			} else {
				ValaExpression* _tmp312_;
				_tmp312_ = last_arg;
				if (_tmp312_ != NULL) {
					ValaExpression* _tmp313_;
					ValaStringLiteral* _tmp314_;
					gboolean _tmp315_ = FALSE;
					ValaStringLiteral* _tmp316_;
					_tmp313_ = last_arg;
					_tmp314_ = vala_string_literal_get_format_literal (_tmp313_);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp314_;
					_tmp316_ = format_literal;
					if (_tmp316_ == NULL) {
						ValaList* _tmp317_;
						gint _tmp318_;
						gint _tmp319_;
						ValaMethod* _tmp320_;
						ValaList* _tmp321_;
						gint _tmp322_;
						gint _tmp323_;
						_tmp317_ = self->priv->argument_list;
						_tmp318_ = vala_collection_get_size ((ValaCollection*) _tmp317_);
						_tmp319_ = _tmp318_;
						_tmp320_ = m;
						_tmp321_ = vala_callable_get_parameters ((ValaCallable*) _tmp320_);
						_tmp322_ = vala_collection_get_size ((ValaCollection*) _tmp321_);
						_tmp323_ = _tmp322_;
						_tmp315_ = _tmp319_ == (_tmp323_ - 1);
					} else {
						_tmp315_ = FALSE;
					}
					if (_tmp315_) {
						ValaStringLiteral* _tmp324_;
						ValaStringLiteral* _tmp325_;
						ValaSemanticAnalyzer* _tmp326_;
						ValaSemanticAnalyzer* _tmp327_;
						ValaDataType* _tmp328_;
						ValaDataType* _tmp329_;
						ValaDataType* _tmp330_;
						ValaList* _tmp331_;
						ValaList* _tmp332_;
						gint _tmp333_;
						gint _tmp334_;
						ValaStringLiteral* _tmp335_;
						ValaList* _tmp336_;
						ValaIterator* _tmp337_;
						_tmp324_ = vala_string_literal_new ("\"%s\"", NULL);
						_vala_code_node_unref0 (format_literal);
						format_literal = _tmp324_;
						_tmp325_ = format_literal;
						_tmp326_ = vala_code_context_get_analyzer (context);
						_tmp327_ = _tmp326_;
						_tmp328_ = _tmp327_->string_type;
						_tmp329_ = vala_data_type_copy (_tmp328_);
						_tmp330_ = _tmp329_;
						vala_expression_set_target_type ((ValaExpression*) _tmp325_, _tmp330_);
						_vala_code_node_unref0 (_tmp330_);
						_tmp331_ = self->priv->argument_list;
						_tmp332_ = self->priv->argument_list;
						_tmp333_ = vala_collection_get_size ((ValaCollection*) _tmp332_);
						_tmp334_ = _tmp333_;
						_tmp335_ = format_literal;
						vala_list_insert (_tmp331_, _tmp334_ - 1, (ValaExpression*) _tmp335_);
						_tmp336_ = self->priv->argument_list;
						_tmp337_ = vala_iterable_iterator ((ValaIterable*) _tmp336_);
						_vala_iterator_unref0 (arg_it);
						arg_it = _tmp337_;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp338_;
							ValaList* _tmp339_;
							gint _param_size = 0;
							ValaList* _tmp340_;
							gint _tmp341_;
							gint _tmp342_;
							gint _param_index = 0;
							_tmp338_ = m;
							_tmp339_ = vala_callable_get_parameters ((ValaCallable*) _tmp338_);
							_param_list = _tmp339_;
							_tmp340_ = _param_list;
							_tmp341_ = vala_collection_get_size ((ValaCollection*) _tmp340_);
							_tmp342_ = _tmp341_;
							_param_size = _tmp342_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp343_;
								gint _tmp344_;
								ValaParameter* param = NULL;
								ValaList* _tmp345_;
								gpointer _tmp346_;
								gboolean _tmp347_ = FALSE;
								ValaParameter* _tmp348_;
								gboolean _tmp349_;
								gboolean _tmp350_;
								ValaIterator* _tmp354_;
								_param_index = _param_index + 1;
								_tmp343_ = _param_index;
								_tmp344_ = _param_size;
								if (!(_tmp343_ < _tmp344_)) {
									break;
								}
								_tmp345_ = _param_list;
								_tmp346_ = vala_list_get (_tmp345_, _param_index);
								param = (ValaParameter*) _tmp346_;
								_tmp348_ = param;
								_tmp349_ = vala_parameter_get_ellipsis (_tmp348_);
								_tmp350_ = _tmp349_;
								if (_tmp350_) {
									_tmp347_ = TRUE;
								} else {
									ValaParameter* _tmp351_;
									gboolean _tmp352_;
									gboolean _tmp353_;
									_tmp351_ = param;
									_tmp352_ = vala_parameter_get_params_array (_tmp351_);
									_tmp353_ = _tmp352_;
									_tmp347_ = _tmp353_;
								}
								if (_tmp347_) {
									_vala_code_node_unref0 (param);
									break;
								}
								_tmp354_ = arg_it;
								vala_iterator_next (_tmp354_);
								_vala_code_node_unref0 (param);
							}
						}
					}
				}
			}
			_tmp355_ = format_literal;
			if (_tmp355_ != NULL) {
				gchar* format = NULL;
				ValaStringLiteral* _tmp356_;
				gchar* _tmp357_;
				ValaSemanticAnalyzer* _tmp358_;
				ValaSemanticAnalyzer* _tmp359_;
				const gchar* _tmp360_;
				ValaIterator* _tmp361_;
				ValaSourceReference* _tmp362_;
				ValaSourceReference* _tmp363_;
				_tmp356_ = format_literal;
				_tmp357_ = vala_string_literal_eval (_tmp356_);
				format = _tmp357_;
				_tmp358_ = vala_code_context_get_analyzer (context);
				_tmp359_ = _tmp358_;
				_tmp360_ = format;
				_tmp361_ = arg_it;
				_tmp362_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp363_ = _tmp362_;
				if (!vala_semantic_analyzer_check_print_format (_tmp359_, _tmp360_, _tmp361_, _tmp363_)) {
					result = FALSE;
					_g_free0 (format);
					_vala_code_node_unref0 (format_literal);
					_vala_iterator_unref0 (arg_it);
					_vala_code_node_unref0 (last_arg);
					_vala_code_node_unref0 (m);
					_vala_iterable_unref0 (type_args);
					_vala_code_node_unref0 (type_sym);
					_vala_code_node_unref0 (constructor_sym);
					_vala_code_node_unref0 (type);
					return result;
				}
				_g_free0 (format);
			}
			_vala_code_node_unref0 (format_literal);
		}
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp364_;
			gint _arg_size = 0;
			ValaList* _tmp365_;
			gint _tmp366_;
			gint _tmp367_;
			gint _arg_index = 0;
			_tmp364_ = self->priv->argument_list;
			_arg_list = _tmp364_;
			_tmp365_ = _arg_list;
			_tmp366_ = vala_collection_get_size ((ValaCollection*) _tmp365_);
			_tmp367_ = _tmp366_;
			_arg_size = _tmp367_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp368_;
				gint _tmp369_;
				ValaExpression* arg = NULL;
				ValaList* _tmp370_;
				gpointer _tmp371_;
				ValaExpression* _tmp372_;
				_arg_index = _arg_index + 1;
				_tmp368_ = _arg_index;
				_tmp369_ = _arg_size;
				if (!(_tmp368_ < _tmp369_)) {
					break;
				}
				_tmp370_ = _arg_list;
				_tmp371_ = vala_list_get (_tmp370_, _arg_index);
				arg = (ValaExpression*) _tmp371_;
				_tmp372_ = arg;
				vala_code_node_check ((ValaCodeNode*) _tmp372_, context);
				_vala_code_node_unref0 (arg);
			}
		}
		_tmp373_ = vala_code_context_get_analyzer (context);
		_tmp374_ = _tmp373_;
		_tmp375_ = m;
		_tmp376_ = vala_method_type_new (_tmp375_, NULL);
		_tmp377_ = _tmp376_;
		_tmp378_ = m;
		_tmp379_ = vala_callable_get_parameters ((ValaCallable*) _tmp378_);
		_tmp380_ = self->priv->argument_list;
		vala_semantic_analyzer_check_arguments (_tmp374_, (ValaExpression*) self, (ValaDataType*) _tmp377_, _tmp379_, _tmp380_);
		_vala_code_node_unref0 (_tmp377_);
		_vala_iterator_unref0 (arg_it);
		_vala_code_node_unref0 (last_arg);
		_vala_code_node_unref0 (m);
	} else {
		ValaDataType* _tmp381_;
		ValaDataType* _tmp382_;
		_tmp381_ = vala_object_creation_expression_get_type_reference (self);
		_tmp382_ = _tmp381_;
		if (VALA_IS_ERROR_TYPE (_tmp382_)) {
			ValaMemberAccess* _tmp383_;
			ValaMemberAccess* _tmp384_;
			ValaList* _tmp405_;
			gint _tmp406_;
			gint _tmp407_;
			_tmp383_ = vala_object_creation_expression_get_member_name (self);
			_tmp384_ = _tmp383_;
			if (_tmp384_ != NULL) {
				ValaMemberAccess* _tmp385_;
				ValaMemberAccess* _tmp386_;
				_tmp385_ = vala_object_creation_expression_get_member_name (self);
				_tmp386_ = _tmp385_;
				vala_code_node_check ((ValaCodeNode*) _tmp386_, context);
			}
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp387_;
				gint _arg_size = 0;
				ValaList* _tmp388_;
				gint _tmp389_;
				gint _tmp390_;
				gint _arg_index = 0;
				_tmp387_ = self->priv->argument_list;
				_arg_list = _tmp387_;
				_tmp388_ = _arg_list;
				_tmp389_ = vala_collection_get_size ((ValaCollection*) _tmp388_);
				_tmp390_ = _tmp389_;
				_arg_size = _tmp390_;
				_arg_index = -1;
				while (TRUE) {
					gint _tmp391_;
					gint _tmp392_;
					ValaExpression* arg = NULL;
					ValaList* _tmp393_;
					gpointer _tmp394_;
					ValaExpression* _tmp395_;
					_arg_index = _arg_index + 1;
					_tmp391_ = _arg_index;
					_tmp392_ = _arg_size;
					if (!(_tmp391_ < _tmp392_)) {
						break;
					}
					_tmp393_ = _arg_list;
					_tmp394_ = vala_list_get (_tmp393_, _arg_index);
					arg = (ValaExpression*) _tmp394_;
					_tmp395_ = arg;
					vala_code_node_check ((ValaCodeNode*) _tmp395_, context);
					_vala_code_node_unref0 (arg);
				}
			}
			{
				ValaList* _init_list = NULL;
				ValaList* _tmp396_;
				gint _init_size = 0;
				ValaList* _tmp397_;
				gint _tmp398_;
				gint _tmp399_;
				gint _init_index = 0;
				_tmp396_ = self->priv->object_initializer;
				_init_list = _tmp396_;
				_tmp397_ = _init_list;
				_tmp398_ = vala_collection_get_size ((ValaCollection*) _tmp397_);
				_tmp399_ = _tmp398_;
				_init_size = _tmp399_;
				_init_index = -1;
				while (TRUE) {
					gint _tmp400_;
					gint _tmp401_;
					ValaMemberInitializer* init = NULL;
					ValaList* _tmp402_;
					gpointer _tmp403_;
					ValaMemberInitializer* _tmp404_;
					_init_index = _init_index + 1;
					_tmp400_ = _init_index;
					_tmp401_ = _init_size;
					if (!(_tmp400_ < _tmp401_)) {
						break;
					}
					_tmp402_ = _init_list;
					_tmp403_ = vala_list_get (_tmp402_, _init_index);
					init = (ValaMemberInitializer*) _tmp403_;
					_tmp404_ = init;
					vala_code_node_check ((ValaCodeNode*) _tmp404_, context);
					_vala_code_node_unref0 (init);
				}
			}
			_tmp405_ = self->priv->argument_list;
			_tmp406_ = vala_collection_get_size ((ValaCollection*) _tmp405_);
			_tmp407_ = _tmp406_;
			if (_tmp407_ == 0) {
				ValaSourceReference* _tmp408_;
				ValaSourceReference* _tmp409_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp408_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp409_ = _tmp408_;
				vala_report_error (_tmp409_, "Too few arguments, errors need at least 1 argument");
			} else {
				ValaIterator* arg_it = NULL;
				ValaList* _tmp410_;
				ValaIterator* _tmp411_;
				ValaIterator* _tmp412_;
				ValaExpression* ex = NULL;
				ValaIterator* _tmp413_;
				gpointer _tmp414_;
				gboolean _tmp415_ = FALSE;
				ValaExpression* _tmp416_;
				ValaDataType* _tmp417_;
				ValaDataType* _tmp418_;
				ValaStringLiteral* format_literal = NULL;
				ValaExpression* _tmp427_;
				ValaStringLiteral* _tmp428_;
				ValaStringLiteral* _tmp429_;
				ValaList* _tmp438_;
				ValaIterator* _tmp439_;
				ValaIterator* _tmp440_;
				ValaSemanticAnalyzer* _tmp441_;
				ValaSemanticAnalyzer* _tmp442_;
				ValaIterator* _tmp443_;
				ValaSourceReference* _tmp444_;
				ValaSourceReference* _tmp445_;
				_tmp410_ = self->priv->argument_list;
				_tmp411_ = vala_iterable_iterator ((ValaIterable*) _tmp410_);
				arg_it = _tmp411_;
				_tmp412_ = arg_it;
				vala_iterator_next (_tmp412_);
				_tmp413_ = arg_it;
				_tmp414_ = vala_iterator_get (_tmp413_);
				ex = (ValaExpression*) _tmp414_;
				_tmp416_ = ex;
				_tmp417_ = vala_expression_get_value_type (_tmp416_);
				_tmp418_ = _tmp417_;
				if (_tmp418_ == NULL) {
					_tmp415_ = TRUE;
				} else {
					ValaExpression* _tmp419_;
					ValaDataType* _tmp420_;
					ValaDataType* _tmp421_;
					ValaSemanticAnalyzer* _tmp422_;
					ValaSemanticAnalyzer* _tmp423_;
					ValaDataType* _tmp424_;
					_tmp419_ = ex;
					_tmp420_ = vala_expression_get_value_type (_tmp419_);
					_tmp421_ = _tmp420_;
					_tmp422_ = vala_code_context_get_analyzer (context);
					_tmp423_ = _tmp422_;
					_tmp424_ = _tmp423_->string_type;
					_tmp415_ = !vala_data_type_compatible (_tmp421_, _tmp424_);
				}
				if (_tmp415_) {
					ValaSourceReference* _tmp425_;
					ValaSourceReference* _tmp426_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp425_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp426_ = _tmp425_;
					vala_report_error (_tmp426_, "Invalid type for argument 1");
				}
				_tmp427_ = ex;
				_tmp428_ = vala_string_literal_get_format_literal (_tmp427_);
				format_literal = _tmp428_;
				_tmp429_ = format_literal;
				if (_tmp429_ != NULL) {
					gchar* format = NULL;
					ValaStringLiteral* _tmp430_;
					gchar* _tmp431_;
					ValaSemanticAnalyzer* _tmp432_;
					ValaSemanticAnalyzer* _tmp433_;
					const gchar* _tmp434_;
					ValaIterator* _tmp435_;
					ValaSourceReference* _tmp436_;
					ValaSourceReference* _tmp437_;
					_tmp430_ = format_literal;
					_tmp431_ = vala_string_literal_eval (_tmp430_);
					format = _tmp431_;
					_tmp432_ = vala_code_context_get_analyzer (context);
					_tmp433_ = _tmp432_;
					_tmp434_ = format;
					_tmp435_ = arg_it;
					_tmp436_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp437_ = _tmp436_;
					if (!vala_semantic_analyzer_check_print_format (_tmp433_, _tmp434_, _tmp435_, _tmp437_)) {
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						result = FALSE;
						_g_free0 (format);
						_vala_code_node_unref0 (format_literal);
						_vala_code_node_unref0 (ex);
						_vala_iterator_unref0 (arg_it);
						_vala_iterable_unref0 (type_args);
						_vala_code_node_unref0 (type_sym);
						_vala_code_node_unref0 (constructor_sym);
						_vala_code_node_unref0 (type);
						return result;
					}
					_g_free0 (format);
				}
				_tmp438_ = self->priv->argument_list;
				_tmp439_ = vala_iterable_iterator ((ValaIterable*) _tmp438_);
				_vala_iterator_unref0 (arg_it);
				arg_it = _tmp439_;
				_tmp440_ = arg_it;
				vala_iterator_next (_tmp440_);
				_tmp441_ = vala_code_context_get_analyzer (context);
				_tmp442_ = _tmp441_;
				_tmp443_ = arg_it;
				_tmp444_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp445_ = _tmp444_;
				if (!vala_semantic_analyzer_check_variadic_arguments (_tmp442_, _tmp443_, 1, _tmp445_)) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					result = FALSE;
					_vala_code_node_unref0 (format_literal);
					_vala_code_node_unref0 (ex);
					_vala_iterator_unref0 (arg_it);
					_vala_iterable_unref0 (type_args);
					_vala_code_node_unref0 (type_sym);
					_vala_code_node_unref0 (constructor_sym);
					_vala_code_node_unref0 (type);
					return result;
				}
				_vala_code_node_unref0 (format_literal);
				_vala_code_node_unref0 (ex);
				_vala_iterator_unref0 (arg_it);
			}
		}
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp446_;
		gint _arg_size = 0;
		ValaList* _tmp447_;
		gint _tmp448_;
		gint _tmp449_;
		gint _arg_index = 0;
		_tmp446_ = self->priv->argument_list;
		_arg_list = _tmp446_;
		_tmp447_ = _arg_list;
		_tmp448_ = vala_collection_get_size ((ValaCollection*) _tmp447_);
		_tmp449_ = _tmp448_;
		_arg_size = _tmp449_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp450_;
			gint _tmp451_;
			ValaExpression* arg = NULL;
			ValaList* _tmp452_;
			gpointer _tmp453_;
			ValaSizeofExpression* sizeof_expr = NULL;
			ValaExpression* _tmp454_;
			gboolean _tmp455_ = FALSE;
			ValaSizeofExpression* _tmp456_;
			_arg_index = _arg_index + 1;
			_tmp450_ = _arg_index;
			_tmp451_ = _arg_size;
			if (!(_tmp450_ < _tmp451_)) {
				break;
			}
			_tmp452_ = _arg_list;
			_tmp453_ = vala_list_get (_tmp452_, _arg_index);
			arg = (ValaExpression*) _tmp453_;
			_tmp454_ = arg;
			sizeof_expr = VALA_IS_SIZEOF_EXPRESSION (_tmp454_) ? ((ValaSizeofExpression*) _tmp454_) : NULL;
			_tmp456_ = sizeof_expr;
			if (_tmp456_ != NULL) {
				ValaSizeofExpression* _tmp457_;
				ValaDataType* _tmp458_;
				ValaDataType* _tmp459_;
				_tmp457_ = sizeof_expr;
				_tmp458_ = vala_sizeof_expression_get_type_reference (_tmp457_);
				_tmp459_ = _tmp458_;
				_tmp455_ = VALA_IS_GENERIC_TYPE (_tmp459_);
			} else {
				_tmp455_ = FALSE;
			}
			if (_tmp455_) {
				ValaDataType* sizeof_type = NULL;
				ValaSizeofExpression* _tmp460_;
				ValaDataType* _tmp461_;
				ValaDataType* _tmp462_;
				ValaDataType* _tmp463_;
				ValaDataType* _tmp464_;
				ValaDataType* _tmp465_;
				ValaDataType* _tmp466_;
				ValaList* _tmp467_;
				ValaDataType* _tmp468_;
				ValaExpression* _tmp469_;
				ValaDataType* _tmp470_;
				ValaSourceReference* _tmp471_;
				ValaSourceReference* _tmp472_;
				ValaSizeofExpression* _tmp473_;
				ValaSizeofExpression* _tmp474_;
				_tmp460_ = sizeof_expr;
				_tmp461_ = vala_sizeof_expression_get_type_reference (_tmp460_);
				_tmp462_ = _tmp461_;
				_tmp463_ = vala_object_creation_expression_get_type_reference (self);
				_tmp464_ = _tmp463_;
				_tmp465_ = vala_object_creation_expression_get_type_reference (self);
				_tmp466_ = _tmp465_;
				_tmp467_ = vala_data_type_get_type_arguments (_tmp466_);
				_tmp468_ = vala_data_type_get_actual_type (_tmp462_, _tmp464_, _tmp467_, (ValaCodeNode*) self);
				sizeof_type = _tmp468_;
				_tmp469_ = arg;
				_tmp470_ = sizeof_type;
				_tmp471_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp472_ = _tmp471_;
				_tmp473_ = vala_sizeof_expression_new (_tmp470_, _tmp472_);
				_tmp474_ = _tmp473_;
				vala_code_node_replace_expression ((ValaCodeNode*) self, _tmp469_, (ValaExpression*) _tmp474_);
				_vala_code_node_unref0 (_tmp474_);
				_vala_code_node_unref0 (sizeof_type);
			}
			_vala_code_node_unref0 (arg);
		}
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp475_;
		gint _init_size = 0;
		ValaList* _tmp476_;
		gint _tmp477_;
		gint _tmp478_;
		gint _init_index = 0;
		_tmp475_ = vala_object_creation_expression_get_object_initializer (self);
		_init_list = _tmp475_;
		_tmp476_ = _init_list;
		_tmp477_ = vala_collection_get_size ((ValaCollection*) _tmp476_);
		_tmp478_ = _tmp477_;
		_init_size = _tmp478_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp479_;
			gint _tmp480_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp481_;
			gpointer _tmp482_;
			ValaMemberInitializer* _tmp483_;
			ValaExpression* _tmp484_;
			ValaExpression* _tmp485_;
			gint index = 0;
			ValaList* _tmp486_;
			ValaMemberInitializer* _tmp487_;
			ValaList* _tmp488_;
			gpointer _tmp489_;
			ValaMemberInitializer* _tmp490_;
			ValaMemberInitializer* inner_mi = NULL;
			ValaMemberInitializer* _tmp491_;
			ValaExpression* _tmp492_;
			ValaExpression* _tmp493_;
			ValaLocalVariable* local = NULL;
			gchar* _tmp500_;
			gchar* _tmp501_;
			ValaMemberInitializer* _tmp502_;
			ValaExpression* _tmp503_;
			ValaExpression* _tmp504_;
			ValaMemberInitializer* _tmp505_;
			ValaExpression* _tmp506_;
			ValaExpression* _tmp507_;
			ValaSourceReference* _tmp508_;
			ValaSourceReference* _tmp509_;
			ValaLocalVariable* _tmp510_;
			ValaLocalVariable* _tmp511_;
			ValaDeclarationStatement* decl = NULL;
			ValaLocalVariable* _tmp512_;
			ValaMemberInitializer* _tmp513_;
			ValaExpression* _tmp514_;
			ValaExpression* _tmp515_;
			ValaSourceReference* _tmp516_;
			ValaSourceReference* _tmp517_;
			ValaDeclarationStatement* _tmp518_;
			ValaDeclarationStatement* _tmp519_;
			ValaSemanticAnalyzer* _tmp520_;
			ValaSemanticAnalyzer* _tmp521_;
			ValaBlock* _tmp522_;
			ValaDeclarationStatement* _tmp523_;
			_init_index = _init_index + 1;
			_tmp479_ = _init_index;
			_tmp480_ = _init_size;
			if (!(_tmp479_ < _tmp480_)) {
				break;
			}
			_tmp481_ = _init_list;
			_tmp482_ = vala_list_get (_tmp481_, _init_index);
			init = (ValaMemberInitializer*) _tmp482_;
			_tmp483_ = init;
			_tmp484_ = vala_member_initializer_get_initializer (_tmp483_);
			_tmp485_ = _tmp484_;
			if (!VALA_IS_MEMBER_INITIALIZER (_tmp485_)) {
				_vala_code_node_unref0 (init);
				continue;
			}
			_tmp486_ = self->priv->object_initializer;
			_tmp487_ = init;
			index = vala_list_index_of (_tmp486_, _tmp487_);
			_tmp488_ = self->priv->object_initializer;
			_tmp489_ = vala_list_remove_at (_tmp488_, index);
			_tmp490_ = (ValaMemberInitializer*) _tmp489_;
			_vala_code_node_unref0 (_tmp490_);
			_vala_assert (index >= 0, "index >= 0");
			_tmp491_ = init;
			_tmp492_ = vala_member_initializer_get_initializer (_tmp491_);
			_tmp493_ = _tmp492_;
			inner_mi = G_TYPE_CHECK_INSTANCE_CAST (_tmp493_, VALA_TYPE_MEMBER_INITIALIZER, ValaMemberInitializer);
			while (TRUE) {
				ValaMemberInitializer* _tmp494_;
				ValaExpression* _tmp495_;
				ValaExpression* _tmp496_;
				ValaMemberInitializer* _tmp497_;
				ValaExpression* _tmp498_;
				ValaExpression* _tmp499_;
				_tmp494_ = inner_mi;
				_tmp495_ = vala_member_initializer_get_initializer (_tmp494_);
				_tmp496_ = _tmp495_;
				if (!VALA_IS_MEMBER_INITIALIZER (_tmp496_)) {
					break;
				}
				_tmp497_ = inner_mi;
				_tmp498_ = vala_member_initializer_get_initializer (_tmp497_);
				_tmp499_ = _tmp498_;
				inner_mi = G_TYPE_CHECK_INSTANCE_CAST (_tmp499_, VALA_TYPE_MEMBER_INITIALIZER, ValaMemberInitializer);
			}
			_tmp500_ = vala_code_node_get_temp_name ();
			_tmp501_ = _tmp500_;
			_tmp502_ = inner_mi;
			_tmp503_ = vala_member_initializer_get_initializer (_tmp502_);
			_tmp504_ = _tmp503_;
			_tmp505_ = inner_mi;
			_tmp506_ = vala_member_initializer_get_initializer (_tmp505_);
			_tmp507_ = _tmp506_;
			_tmp508_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp507_);
			_tmp509_ = _tmp508_;
			_tmp510_ = vala_local_variable_new (NULL, _tmp501_, _tmp504_, _tmp509_);
			_tmp511_ = _tmp510_;
			_g_free0 (_tmp501_);
			local = _tmp511_;
			_tmp512_ = local;
			_tmp513_ = inner_mi;
			_tmp514_ = vala_member_initializer_get_initializer (_tmp513_);
			_tmp515_ = _tmp514_;
			_tmp516_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp515_);
			_tmp517_ = _tmp516_;
			_tmp518_ = vala_declaration_statement_new ((ValaSymbol*) _tmp512_, _tmp517_);
			decl = _tmp518_;
			_tmp519_ = decl;
			vala_code_node_check ((ValaCodeNode*) _tmp519_, context);
			_tmp520_ = vala_code_context_get_analyzer (context);
			_tmp521_ = _tmp520_;
			_tmp522_ = _tmp521_->insert_block;
			_tmp523_ = decl;
			vala_expression_insert_statement ((ValaExpression*) self, _tmp522_, (ValaStatement*) _tmp523_);
			{
				gboolean _tmp524_ = FALSE;
				_tmp524_ = TRUE;
				while (TRUE) {
					ValaMemberInitializer* member_init = NULL;
					ValaMemberInitializer* _tmp526_;
					const gchar* _tmp527_;
					const gchar* _tmp528_;
					ValaLocalVariable* _tmp529_;
					const gchar* _tmp530_;
					const gchar* _tmp531_;
					ValaMemberInitializer* _tmp532_;
					ValaSourceReference* _tmp533_;
					ValaSourceReference* _tmp534_;
					ValaMemberAccess* _tmp535_;
					ValaMemberAccess* _tmp536_;
					ValaMemberInitializer* _tmp537_;
					ValaSourceReference* _tmp538_;
					ValaSourceReference* _tmp539_;
					ValaMemberInitializer* _tmp540_;
					ValaMemberInitializer* _tmp541_;
					ValaList* _tmp542_;
					gint _tmp543_;
					ValaMemberInitializer* _tmp544_;
					ValaMemberInitializer* _tmp545_;
					ValaCodeNode* _tmp546_;
					ValaCodeNode* _tmp547_;
					if (!_tmp524_) {
						ValaMemberInitializer* _tmp525_;
						_tmp525_ = inner_mi;
						if (!(_tmp525_ != NULL)) {
							break;
						}
					}
					_tmp524_ = FALSE;
					_tmp526_ = inner_mi;
					_tmp527_ = vala_member_initializer_get_name (_tmp526_);
					_tmp528_ = _tmp527_;
					_tmp529_ = local;
					_tmp530_ = vala_symbol_get_name ((ValaSymbol*) _tmp529_);
					_tmp531_ = _tmp530_;
					_tmp532_ = inner_mi;
					_tmp533_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp532_);
					_tmp534_ = _tmp533_;
					_tmp535_ = vala_member_access_new (NULL, _tmp531_, _tmp534_);
					_tmp536_ = _tmp535_;
					_tmp537_ = inner_mi;
					_tmp538_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp537_);
					_tmp539_ = _tmp538_;
					_tmp540_ = vala_member_initializer_new (_tmp528_, (ValaExpression*) _tmp536_, _tmp539_);
					_tmp541_ = _tmp540_;
					_vala_code_node_unref0 (_tmp536_);
					member_init = _tmp541_;
					_tmp542_ = self->priv->object_initializer;
					_tmp543_ = index;
					index = _tmp543_ + 1;
					_tmp544_ = member_init;
					vala_list_insert (_tmp542_, _tmp543_, _tmp544_);
					_tmp545_ = inner_mi;
					_tmp546_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp545_);
					_tmp547_ = _tmp546_;
					inner_mi = VALA_IS_MEMBER_INITIALIZER (_tmp547_) ? ((ValaMemberInitializer*) _tmp547_) : NULL;
					_vala_code_node_unref0 (member_init);
				}
			}
			_vala_code_node_unref0 (decl);
			_vala_code_node_unref0 (local);
			_vala_code_node_unref0 (init);
		}
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp548_;
		gint _init_size = 0;
		ValaList* _tmp549_;
		gint _tmp550_;
		gint _tmp551_;
		gint _init_index = 0;
		_tmp548_ = vala_object_creation_expression_get_object_initializer (self);
		_init_list = _tmp548_;
		_tmp549_ = _init_list;
		_tmp550_ = vala_collection_get_size ((ValaCollection*) _tmp549_);
		_tmp551_ = _tmp550_;
		_init_size = _tmp551_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp552_;
			gint _tmp553_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp554_;
			gpointer _tmp555_;
			ValaMemberInitializer* _tmp556_;
			ValaMemberInitializer* _tmp557_;
			_init_index = _init_index + 1;
			_tmp552_ = _init_index;
			_tmp553_ = _init_size;
			if (!(_tmp552_ < _tmp553_)) {
				break;
			}
			_tmp554_ = _init_list;
			_tmp555_ = vala_list_get (_tmp554_, _init_index);
			init = (ValaMemberInitializer*) _tmp555_;
			_tmp556_ = init;
			vala_code_node_set_parent_node ((ValaCodeNode*) _tmp556_, (ValaCodeNode*) self);
			_tmp557_ = init;
			vala_code_node_check ((ValaCodeNode*) _tmp557_, context);
			_vala_code_node_unref0 (init);
		}
	}
	_tmp558_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
	_tmp559_ = _tmp558_;
	if (_tmp559_) {
		gboolean _tmp560_ = FALSE;
		ValaCodeNode* _tmp561_;
		ValaCodeNode* _tmp562_;
		_tmp561_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp562_ = _tmp561_;
		if (VALA_IS_LOCAL_VARIABLE (_tmp562_)) {
			_tmp560_ = TRUE;
		} else {
			ValaCodeNode* _tmp563_;
			ValaCodeNode* _tmp564_;
			_tmp563_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp564_ = _tmp563_;
			_tmp560_ = VALA_IS_EXPRESSION_STATEMENT (_tmp564_);
		}
		if (_tmp560_) {
		} else {
			ValaSemanticAnalyzer* _tmp565_;
			ValaSemanticAnalyzer* _tmp566_;
			ValaSymbol* _tmp567_;
			ValaSymbol* _tmp568_;
			_tmp565_ = vala_code_context_get_analyzer (context);
			_tmp566_ = _tmp565_;
			_tmp567_ = vala_semantic_analyzer_get_current_symbol (_tmp566_);
			_tmp568_ = _tmp567_;
			if (!VALA_IS_BLOCK (_tmp568_)) {
				ValaSourceReference* _tmp569_;
				ValaSourceReference* _tmp570_;
				_tmp569_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp570_ = _tmp569_;
				vala_report_error (_tmp570_, "Field initializers must not throw errors");
			} else {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp571_;
				ValaCodeNode* _tmp572_;
				ValaCodeNode* _tmp573_;
				ValaLocalVariable* local = NULL;
				ValaDataType* _tmp574_;
				ValaDataType* _tmp575_;
				ValaDataType* _tmp576_;
				ValaDataType* _tmp577_;
				gchar* _tmp578_;
				gchar* _tmp579_;
				ValaSourceReference* _tmp580_;
				ValaSourceReference* _tmp581_;
				ValaLocalVariable* _tmp582_;
				ValaLocalVariable* _tmp583_;
				ValaDeclarationStatement* decl = NULL;
				ValaLocalVariable* _tmp584_;
				ValaSourceReference* _tmp585_;
				ValaSourceReference* _tmp586_;
				ValaDeclarationStatement* _tmp587_;
				ValaSemanticAnalyzer* _tmp588_;
				ValaSemanticAnalyzer* _tmp589_;
				ValaBlock* _tmp590_;
				ValaDeclarationStatement* _tmp591_;
				ValaExpression* temp_access = NULL;
				ValaLocalVariable* _tmp592_;
				ValaDataType* _tmp593_;
				ValaDataType* _tmp594_;
				ValaExpression* _tmp595_;
				ValaExpression* _tmp596_;
				ValaDataType* _tmp597_;
				ValaDataType* _tmp598_;
				ValaLocalVariable* _tmp599_;
				ValaDeclarationStatement* _tmp600_;
				ValaBlock* block = NULL;
				ValaSemanticAnalyzer* _tmp601_;
				ValaSemanticAnalyzer* _tmp602_;
				ValaSymbol* _tmp603_;
				ValaSymbol* _tmp604_;
				ValaBlock* _tmp605_;
				ValaBlock* _tmp606_;
				ValaLocalVariable* _tmp607_;
				ValaSemanticAnalyzer* _tmp608_;
				ValaSemanticAnalyzer* _tmp609_;
				ValaBlock* _tmp610_;
				ValaLocalVariable* _tmp611_;
				ValaCodeNode* _tmp612_;
				ValaExpression* _tmp613_;
				ValaExpression* _tmp614_;
				_tmp571_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp572_ = _tmp571_;
				_tmp573_ = _vala_code_node_ref0 (_tmp572_);
				old_parent_node = _tmp573_;
				_tmp574_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp575_ = _tmp574_;
				_tmp576_ = vala_data_type_copy (_tmp575_);
				_tmp577_ = _tmp576_;
				_tmp578_ = vala_code_node_get_temp_name ();
				_tmp579_ = _tmp578_;
				_tmp580_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp581_ = _tmp580_;
				_tmp582_ = vala_local_variable_new (_tmp577_, _tmp579_, NULL, _tmp581_);
				_tmp583_ = _tmp582_;
				_g_free0 (_tmp579_);
				_vala_code_node_unref0 (_tmp577_);
				local = _tmp583_;
				_tmp584_ = local;
				_tmp585_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp586_ = _tmp585_;
				_tmp587_ = vala_declaration_statement_new ((ValaSymbol*) _tmp584_, _tmp586_);
				decl = _tmp587_;
				_tmp588_ = vala_code_context_get_analyzer (context);
				_tmp589_ = _tmp588_;
				_tmp590_ = _tmp589_->insert_block;
				_tmp591_ = decl;
				vala_expression_insert_statement ((ValaExpression*) self, _tmp590_, (ValaStatement*) _tmp591_);
				_tmp592_ = local;
				_tmp593_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp594_ = _tmp593_;
				_tmp595_ = vala_semantic_analyzer_create_temp_access (_tmp592_, _tmp594_);
				temp_access = _tmp595_;
				_tmp596_ = temp_access;
				_tmp597_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
				_tmp598_ = _tmp597_;
				vala_expression_set_formal_target_type (_tmp596_, _tmp598_);
				vala_expression_set_formal_target_type ((ValaExpression*) self, NULL);
				_tmp599_ = local;
				vala_variable_set_initializer ((ValaVariable*) _tmp599_, (ValaExpression*) self);
				_tmp600_ = decl;
				vala_code_node_check ((ValaCodeNode*) _tmp600_, context);
				_tmp601_ = vala_code_context_get_analyzer (context);
				_tmp602_ = _tmp601_;
				_tmp603_ = vala_semantic_analyzer_get_current_symbol (_tmp602_);
				_tmp604_ = _tmp603_;
				_tmp605_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp604_, VALA_TYPE_BLOCK, ValaBlock));
				block = _tmp605_;
				_tmp606_ = block;
				_tmp607_ = local;
				vala_block_remove_local_variable (_tmp606_, _tmp607_);
				_tmp608_ = vala_code_context_get_analyzer (context);
				_tmp609_ = _tmp608_;
				_tmp610_ = _tmp609_->insert_block;
				_tmp611_ = local;
				vala_block_add_local_variable (_tmp610_, _tmp611_);
				_tmp612_ = old_parent_node;
				_tmp613_ = temp_access;
				vala_code_node_replace_expression (_tmp612_, (ValaExpression*) self, _tmp613_);
				_tmp614_ = temp_access;
				vala_code_node_check ((ValaCodeNode*) _tmp614_, context);
				_vala_code_node_unref0 (block);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (decl);
				_vala_code_node_unref0 (local);
				_vala_code_node_unref0 (old_parent_node);
			}
		}
	}
	_tmp615_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp616_ = _tmp615_;
	result = !_tmp616_;
	_vala_iterable_unref0 (type_args);
	_vala_code_node_unref0 (type_sym);
	_vala_code_node_unref0 (constructor_sym);
	_vala_code_node_unref0 (type);
	return result;
}

static void
vala_object_creation_expression_real_get_error_types (ValaCodeNode* base,
                                                      ValaCollection* collection,
                                                      ValaSourceReference* source_reference)
{
	ValaObjectCreationExpression * self;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	if (VALA_IS_METHOD (_tmp1_)) {
		ValaMethod* m = NULL;
		ValaSymbol* _tmp4_;
		ValaSymbol* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		if (source_reference == NULL) {
			ValaSourceReference* _tmp2_;
			ValaSourceReference* _tmp3_;
			_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp3_ = _tmp2_;
			source_reference = _tmp3_;
		}
		_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, VALA_TYPE_METHOD, ValaMethod));
		m = _tmp6_;
		_tmp7_ = m;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp7_, collection, source_reference);
		_vala_code_node_unref0 (m);
	}
}

static void
vala_object_creation_expression_real_emit (ValaCodeNode* base,
                                           ValaCodeGenerator* codegen)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (codegen != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* arg = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_arg_index = _arg_index + 1;
			_tmp4_ = _arg_index;
			_tmp5_ = _arg_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _arg_list;
			_tmp7_ = vala_list_get (_tmp6_, _arg_index);
			arg = (ValaExpression*) _tmp7_;
			_tmp8_ = arg;
			vala_code_node_emit ((ValaCodeNode*) _tmp8_, codegen);
			_vala_code_node_unref0 (arg);
		}
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp9_;
		gint _init_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _init_index = 0;
		_tmp9_ = self->priv->object_initializer;
		_init_list = _tmp9_;
		_tmp10_ = _init_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_init_size = _tmp12_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp15_;
			gpointer _tmp16_;
			ValaMemberInitializer* _tmp17_;
			_init_index = _init_index + 1;
			_tmp13_ = _init_index;
			_tmp14_ = _init_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _init_list;
			_tmp16_ = vala_list_get (_tmp15_, _init_index);
			init = (ValaMemberInitializer*) _tmp16_;
			_tmp17_ = init;
			vala_code_node_emit ((ValaCodeNode*) _tmp17_, codegen);
			_vala_code_node_unref0 (init);
		}
	}
	vala_code_visitor_visit_object_creation_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_object_creation_expression_real_get_defined_variables (ValaCodeNode* base,
                                                            ValaCollection* collection)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* arg = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_arg_index = _arg_index + 1;
			_tmp4_ = _arg_index;
			_tmp5_ = _arg_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _arg_list;
			_tmp7_ = vala_list_get (_tmp6_, _arg_index);
			arg = (ValaExpression*) _tmp7_;
			_tmp8_ = arg;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp8_, collection);
			_vala_code_node_unref0 (arg);
		}
	}
}

static void
vala_object_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                         ValaCollection* collection)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* arg = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_arg_index = _arg_index + 1;
			_tmp4_ = _arg_index;
			_tmp5_ = _arg_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _arg_list;
			_tmp7_ = vala_list_get (_tmp6_, _arg_index);
			arg = (ValaExpression*) _tmp7_;
			_tmp8_ = arg;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp8_, collection);
			_vala_code_node_unref0 (arg);
		}
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp9_;
		gint _init_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _init_index = 0;
		_tmp9_ = self->priv->object_initializer;
		_init_list = _tmp9_;
		_tmp10_ = _init_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_init_size = _tmp12_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp15_;
			gpointer _tmp16_;
			ValaMemberInitializer* _tmp17_;
			_init_index = _init_index + 1;
			_tmp13_ = _init_index;
			_tmp14_ = _init_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _init_list;
			_tmp16_ = vala_list_get (_tmp15_, _init_index);
			init = (ValaMemberInitializer*) _tmp16_;
			_tmp17_ = init;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp17_, collection);
			_vala_code_node_unref0 (init);
		}
	}
}

static gchar*
vala_object_creation_expression_real_to_string (ValaCodeNode* base)
{
	ValaObjectCreationExpression * self;
	GString* b = NULL;
	GString* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp4_;
	ValaMemberAccess* _tmp6_;
	ValaMemberAccess* _tmp7_;
	GString* _tmp13_;
	gboolean first = FALSE;
	GString* _tmp27_;
	GString* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* result;
	self = (ValaObjectCreationExpression*) base;
	_tmp0_ = g_string_new ("");
	b = _tmp0_;
	_tmp1_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GString* _tmp3_;
		_tmp3_ = b;
		g_string_append (_tmp3_, "yield ");
	}
	_tmp4_ = self->priv->_struct_creation;
	if (!_tmp4_) {
		GString* _tmp5_;
		_tmp5_ = b;
		g_string_append (_tmp5_, "new ");
	}
	_tmp6_ = vala_object_creation_expression_get_member_name (self);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		GString* _tmp8_;
		ValaMemberAccess* _tmp9_;
		ValaMemberAccess* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp8_ = b;
		_tmp9_ = vala_object_creation_expression_get_member_name (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_code_node_to_string ((ValaCodeNode*) _tmp10_);
		_tmp12_ = _tmp11_;
		g_string_append (_tmp8_, _tmp12_);
		_g_free0 (_tmp12_);
	}
	_tmp13_ = b;
	g_string_append_c (_tmp13_, '(');
	first = TRUE;
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp14_;
		gint _expr_size = 0;
		ValaList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _expr_index = 0;
		_tmp14_ = self->priv->argument_list;
		_expr_list = _tmp14_;
		_tmp15_ = _expr_list;
		_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_expr_size = _tmp17_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp18_;
			gint _tmp19_;
			ValaExpression* expr = NULL;
			ValaList* _tmp20_;
			gpointer _tmp21_;
			GString* _tmp23_;
			ValaExpression* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			_expr_index = _expr_index + 1;
			_tmp18_ = _expr_index;
			_tmp19_ = _expr_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _expr_list;
			_tmp21_ = vala_list_get (_tmp20_, _expr_index);
			expr = (ValaExpression*) _tmp21_;
			if (!first) {
				GString* _tmp22_;
				_tmp22_ = b;
				g_string_append (_tmp22_, ", ");
			}
			_tmp23_ = b;
			_tmp24_ = expr;
			_tmp25_ = vala_code_node_to_string ((ValaCodeNode*) _tmp24_);
			_tmp26_ = _tmp25_;
			g_string_append (_tmp23_, _tmp26_);
			_g_free0 (_tmp26_);
			first = FALSE;
			_vala_code_node_unref0 (expr);
		}
	}
	_tmp27_ = b;
	g_string_append_c (_tmp27_, ')');
	_tmp28_ = b;
	_tmp29_ = _tmp28_->str;
	_tmp30_ = g_strdup (_tmp29_);
	result = _tmp30_;
	_g_string_free0 (b);
	return result;
}

static void
vala_object_creation_expression_class_init (ValaObjectCreationExpressionClass * klass,
                                            gpointer klass_data)
{
	vala_object_creation_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_object_creation_expression_finalize;
	g_type_class_adjust_private_offset (klass, &ValaObjectCreationExpression_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_object_creation_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_object_creation_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_object_creation_expression_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_object_creation_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_object_creation_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_object_creation_expression_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_object_creation_expression_real_check;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_object_creation_expression_real_get_error_types;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_object_creation_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_object_creation_expression_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_object_creation_expression_real_get_used_variables;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_object_creation_expression_real_to_string;
}

static void
vala_object_creation_expression_vala_callable_expression_interface_init (ValaCallableExpressionIface * iface,
                                                                         gpointer iface_data)
{
	vala_object_creation_expression_vala_callable_expression_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_argument = (void (*) (ValaCallableExpression*, ValaExpression*)) vala_object_creation_expression_real_add_argument;
	iface->get_argument_list = (ValaList* (*) (ValaCallableExpression*)) vala_object_creation_expression_real_get_argument_list;
	iface->get_call = vala_object_creation_expression_real_get_call;
	iface->get_is_yield_expression = vala_object_creation_expression_real_get_is_yield_expression;
	iface->set_is_yield_expression = vala_object_creation_expression_real_set_is_yield_expression;
	iface->get_is_chainup = vala_object_creation_expression_real_get_is_chainup;
	iface->set_is_chainup = vala_object_creation_expression_real_set_is_chainup;
}

static void
vala_object_creation_expression_instance_init (ValaObjectCreationExpression * self,
                                               gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	self->priv = vala_object_creation_expression_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->argument_list = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_MEMBER_INITIALIZER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->object_initializer = (ValaList*) _tmp3_;
}

static void
vala_object_creation_expression_finalize (ValaCodeNode * obj)
{
	ValaObjectCreationExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpression);
	_vala_iterable_unref0 (self->priv->argument_list);
	_vala_iterable_unref0 (self->priv->object_initializer);
	_vala_code_node_unref0 (self->priv->_data_type);
	_vala_code_node_unref0 (self->priv->_member_name);
	VALA_CODE_NODE_CLASS (vala_object_creation_expression_parent_class)->finalize (obj);
}

/**
 * Represents an object creation expression in the source code.
 */
static GType
vala_object_creation_expression_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaObjectCreationExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_object_creation_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaObjectCreationExpression), 0, (GInstanceInitFunc) vala_object_creation_expression_instance_init, NULL };
	static const GInterfaceInfo vala_callable_expression_info = { (GInterfaceInitFunc) vala_object_creation_expression_vala_callable_expression_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType vala_object_creation_expression_type_id;
	vala_object_creation_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaObjectCreationExpression", &g_define_type_info, 0);
	g_type_add_interface_static (vala_object_creation_expression_type_id, VALA_TYPE_CALLABLE_EXPRESSION, &vala_callable_expression_info);
	ValaObjectCreationExpression_private_offset = g_type_add_instance_private (vala_object_creation_expression_type_id, sizeof (ValaObjectCreationExpressionPrivate));
	return vala_object_creation_expression_type_id;
}

GType
vala_object_creation_expression_get_type (void)
{
	static volatile gsize vala_object_creation_expression_type_id__once = 0;
	if (g_once_init_enter (&vala_object_creation_expression_type_id__once)) {
		GType vala_object_creation_expression_type_id;
		vala_object_creation_expression_type_id = vala_object_creation_expression_get_type_once ();
		g_once_init_leave (&vala_object_creation_expression_type_id__once, vala_object_creation_expression_type_id);
	}
	return vala_object_creation_expression_type_id__once;
}

