#!/bin/sh

testtext="test.txt"

echo "/* Test strings generated by $0, using data from $testtext */"
echo

for i in latin1 cp1252 utf8 utf16 utf16bom_le utf16le utf16bom_be utf16be
do
  enc=$i
  bom=
  case $i in
    utf16bom_be)
      enc=utf16be
      bom="0xfe, 0xff, ";
    ;;
    utf16bom_le*)
      enc=utf16le
      bom="0xff, 0xfe, ";
    ;;
  esac

  echo "const unsigned char ${i}[] = "
  echo -n "{ $bom"
  iconv -f utf8 -t $enc < "$testtext" | hexdump -v -e '1/1 "0x%02x, "'
  echo
  case $i in
    latin1|utf8|cp1252)
      echo "  0x00 };"
    ;;
    utf16*)
      echo "  0x00, 0x00 };"
    ;;
  esac
  echo
done
